/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.config.gui;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.shedaniel.autoconfig.gui.registry.api.GuiProvider;
import me.shedaniel.autoconfig.gui.registry.api.GuiRegistryAccess;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerSliderEntry;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntSliderBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.config.ConfigDefaults;
import randommcsomethin.fallingleaves.config.LeafSettingsEntry;
import randommcsomethin.fallingleaves.util.ModUtil;
import randommcsomethin.fallingleaves.util.RegistryUtil;
import randommcsomethin.fallingleaves.util.TranslationComparator;

public class LeafSettingsGuiProvider
implements GuiProvider {
    private static final class_5250 RESET_TEXT = class_2561.method_43471((String)"text.cloth-config.reset_value");

    public List<AbstractConfigListEntry> get(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess registry) {
        try {
            Map leafSettings = (Map)field.get(config);
            ArrayList<AbstractConfigListEntry> entries = new ArrayList<AbstractConfigListEntry>(leafSettings.size());
            leafSettings.entrySet().stream().filter(e -> RegistryUtil.getBlock((class_2960)e.getKey()) != null).sorted((e1, e2) -> TranslationComparator.INST.compare(RegistryUtil.getBlock((class_2960)e1.getKey()).method_9539(), RegistryUtil.getBlock((class_2960)e2.getKey()).method_9539())).forEachOrdered(e -> {
                class_2960 blockId = (class_2960)e.getKey();
                LeafSettingsEntry leafEntry = (LeafSettingsEntry)e.getValue();
                class_2248 block = RegistryUtil.getBlock(blockId);
                class_5250 text = class_2561.method_43471((String)block.method_9539());
                if (!leafEntry.isDefault(blockId)) {
                    text.method_27693("*");
                }
                SubCategoryBuilder builder = new SubCategoryBuilder((class_2561)RESET_TEXT, (class_2561)text).setTooltip(new class_2561[]{class_2561.method_30163((String)ModUtil.getModName(block))});
                builder.add((AbstractConfigListEntry)LeafSettingsGuiProvider.buildSpawnRateFactorSlider(blockId, leafEntry));
                builder.add((AbstractConfigListEntry)LeafSettingsGuiProvider.buildIsConiferLeavesToggle(blockId, leafEntry));
                entries.add((AbstractConfigListEntry)builder.build());
            });
            return entries;
        }
        catch (IllegalAccessException e3) {
            FallingLeavesClient.LOGGER.error((Object)e3);
            return Collections.emptyList();
        }
    }

    private static IntegerSliderEntry buildSpawnRateFactorSlider(class_2960 blockId, LeafSettingsEntry entry) {
        int min = 0;
        int max = 1000;
        int stepSize = 10;
        int currentValue = (int)(entry.spawnRateFactor * 100.0);
        int defaultValue = (int)(ConfigDefaults.spawnRateFactor(blockId) * 100.0);
        return new IntSliderBuilder((class_2561)RESET_TEXT, (class_2561)class_2561.method_43471((String)"config.fallingleaves.spawn_rate_factor"), currentValue /= stepSize, min /= stepSize, max /= stepSize).setDefaultValue(defaultValue /= stepSize).setSaveConsumer(value -> {
            entry.spawnRateFactor = (double)(value * stepSize) / 100.0;
        }).setTextGetter(value -> class_2561.method_30163((String)(value * stepSize + "%"))).setTooltip(new class_2561[]{class_2561.method_43471((String)"config.fallingleaves.spawn_rate_factor.@Tooltip")}).build();
    }

    private static BooleanListEntry buildIsConiferLeavesToggle(class_2960 blockId, LeafSettingsEntry entry) {
        return new BooleanToggleBuilder((class_2561)RESET_TEXT, (class_2561)class_2561.method_43471((String)"config.fallingleaves.is_conifer"), entry.isConiferBlock).setDefaultValue(ConfigDefaults.isConifer(blockId)).setSaveConsumer(isConiferBlock -> {
            entry.isConiferBlock = isConiferBlock;
        }).build();
    }
}

