/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.content.widget.WidgetUtils;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ScrollableScreen
extends class_437 {
    protected static final Color ENTRY_BACKGROUND_COLOR = new Color(92, 92, 92);
    protected static final Color SCREEN_BACKGROUND_COLOR = new Color(54, 54, 54);
    protected static final Color HEADER_FOOTER_COLOR = new Color(33, 33, 33);
    protected ScrollArea scrollArea;
    protected class_437 parent;
    protected String title;

    public ScrollableScreen(class_437 parent, String title) {
        super((class_2561)class_2561.method_43470((String)""));
        this.parent = parent;
        this.title = title;
        this.scrollArea = new ScrollArea(0, 50, 300, 0);
        this.scrollArea.backgroundColor = ENTRY_BACKGROUND_COLOR;
    }

    protected void method_25426() {
        this.scrollArea.x = this.field_22789 / 2 - 150;
        this.scrollArea.height = this.field_22790 - 100;
    }

    public void method_25419() {
        if (!PopupHandler.isPopupActive()) {
            class_310.method_1551().method_1507(this.parent);
        }
    }

    public boolean method_25422() {
        return true;
    }

    public void method_25394(class_4587 matrix, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableBlend();
        ScrollableScreen.method_25294((class_4587)matrix, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)SCREEN_BACKGROUND_COLOR.getRGB());
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof ScrollAreaEntryBase)) continue;
            ((ScrollAreaEntryBase)e).isOverlayButtonHovered = this.isOverlayButtonHovered();
        }
        this.scrollArea.render(matrix);
        ScrollableScreen.method_25294((class_4587)matrix, (int)0, (int)0, (int)this.field_22789, (int)50, (int)HEADER_FOOTER_COLOR.getRGB());
        ScrollableScreen.method_25300((class_4587)matrix, (class_327)this.field_22793, (String)this.title, (int)(this.field_22789 / 2), (int)20, (int)-1);
        ScrollableScreen.method_25294((class_4587)matrix, (int)0, (int)(this.field_22790 - 50), (int)this.field_22789, (int)this.field_22790, (int)HEADER_FOOTER_COLOR.getRGB());
        super.method_25394(matrix, mouseX, mouseY, partialTicks);
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof ScrollAreaEntryBase) || !((ScrollAreaEntryBase)e).isOverlayButtonHoveredAndOverlapsArea() || ((ScrollAreaEntryBase)e).description == null) continue;
            ScrollableScreen.renderDescription(matrix, ((ScrollAreaEntryBase)e).description, MouseInput.getMouseX(), MouseInput.getMouseY());
            break;
        }
    }

    protected static void renderDescription(class_4587 matrix, List<String> desc, int mouseX, int mouseY) {
        if (desc != null) {
            int width = 10;
            int height = 10;
            for (String s : desc) {
                int i = class_310.method_1551().field_1772.method_1727(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (class_310.method_1551().field_1755.field_22789 < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (class_310.method_1551().field_1755.field_22790 < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderUtils.setZLevelPre((class_4587)matrix, (int)600);
            ScrollableScreen.renderDescriptionBackground(matrix, mouseX, mouseY, width, height);
            RenderSystem.enableBlend();
            int i2 = 5;
            for (String s : desc) {
                ScrollableScreen.method_25303((class_4587)matrix, (class_327)class_310.method_1551().field_1772, (String)s, (int)(mouseX + 5), (int)(mouseY + i2), (int)Color.WHITE.getRGB());
                i2 += 10;
            }
            RenderUtils.setZLevelPost((class_4587)matrix);
            RenderSystem.disableBlend();
        }
    }

    protected static void renderDescriptionBackground(class_4587 matrix, int x, int y, int width, int height) {
        class_329.method_25294((class_4587)matrix, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)new Color(26, 26, 26, 250).getRGB());
    }

    public boolean isOverlayButtonHovered() {
        return false;
    }

    public static class ScrollAreaEntryBase
    extends ScrollAreaEntry {
        protected int entryHeight = 25;
        protected List<String> description = null;
        protected Consumer<EntryRenderCallback> renderBody;
        protected boolean isOverlayButtonHovered = false;

        public ScrollAreaEntryBase(ScrollArea parent, Consumer<EntryRenderCallback> renderBody) {
            super(parent);
            this.renderBody = renderBody;
        }

        public void renderEntry(class_4587 matrix) {
            EntryRenderCallback c = new EntryRenderCallback();
            c.entry = this;
            c.matrix = matrix;
            this.renderBody.accept(c);
        }

        public int getHeight() {
            return this.entryHeight;
        }

        public void setHeight(int height) {
            this.entryHeight = height;
        }

        public List<String> getDescription() {
            return this.description;
        }

        public boolean isOverlayButtonHoveredAndOverlapsArea() {
            return this.isOverlayButtonHovered && this.isHovered();
        }

        public void setDescription(List<String> desc) {
            this.description = desc;
        }

        public void setDescription(String[] desc) {
            this.description = Arrays.asList(desc);
        }

        public static class EntryRenderCallback {
            public ScrollAreaEntryBase entry;
            public class_4587 matrix;
        }
    }

    public static class SeparatorEntry
    extends ScrollAreaEntryBase {
        public SeparatorEntry(ScrollArea parent, int height, Color color) {
            super(parent, null);
            this.renderBody = render -> SeparatorEntry.method_25294((class_4587)render.matrix, (int)render.entry.x, (int)render.entry.y, (int)(render.entry.x + render.entry.getWidth()), (int)(render.entry.y + render.entry.getHeight()), (int)color.getRGB());
            this.setHeight(height);
        }
    }

    public static class EmptySpaceEntry
    extends ScrollAreaEntryBase {
        public EmptySpaceEntry(ScrollArea parent, int height) {
            super(parent, null);
            this.renderBody = render -> {};
            this.setHeight(height);
        }
    }

    public static class TextEntry
    extends ScrollAreaEntryBase {
        public String text;
        public boolean bold;

        public TextEntry(ScrollArea parent, String text, boolean bold) {
            super(parent, null);
            this.text = text;
            this.bold = bold;
            this.renderBody = render -> {
                if (this.text != null) {
                    class_327 font = class_310.method_1551().field_1772;
                    int xCenter = render.entry.x + render.entry.getWidth() / 2;
                    int yCenter = render.entry.y + render.entry.getHeight() / 2;
                    Object s = this.text;
                    if (this.bold) {
                        s = "\u00a7l" + this.text;
                    }
                    class_4587 class_45872 = render.matrix;
                    Objects.requireNonNull(font);
                    TextEntry.method_25300((class_4587)class_45872, (class_327)font, (String)s, (int)xCenter, (int)(yCenter - 9 / 2), (int)-1);
                }
            };
            this.setHeight(18);
        }
    }

    public static class TextFieldEntry
    extends ScrollAreaEntryBase {
        public AdvancedTextField textField;

        public TextFieldEntry(ScrollArea parent, AdvancedTextField textField) {
            super(parent, null);
            this.textField = textField;
            this.textField.method_1880(10000);
            this.renderBody = render -> {
                int xCenter = render.entry.x + render.entry.getWidth() / 2;
                this.textField.field_22763 = !this.isOverlayButtonHoveredAndOverlapsArea();
                this.textField.method_25358(200);
                WidgetUtils.setHeight((class_339)this.textField, (int)20);
                this.textField.method_16872(xCenter - this.textField.method_25368() / 2);
                this.textField.setY(render.entry.y + 2);
                this.textField.method_25394(render.matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), class_310.method_1551().method_1534());
            };
            this.setHeight(24);
        }
    }

    public static class ButtonEntry
    extends ScrollAreaEntryBase {
        public AdvancedButton button;

        public ButtonEntry(ScrollArea parent, AdvancedButton button) {
            super(parent, null);
            this.button = button;
            this.renderBody = render -> {
                int xCenter = render.entry.x + render.entry.getWidth() / 2;
                UIBase.colorizeButton(this.button);
                this.button.field_22763 = !this.isOverlayButtonHoveredAndOverlapsArea();
                this.button.method_25358(200);
                this.button.setHeight(20);
                this.button.setX(xCenter - this.button.method_25368() / 2);
                this.button.setY(render.entry.y + 2);
                this.button.method_25394(render.matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), class_310.method_1551().method_1534());
            };
            this.setHeight(24);
        }
    }
}

