/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollbar;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollbar.ScrollBarHandler;
import de.keksuccino.konkrete.events.client.GuiScreenEvent;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ScrollBar
extends class_332 {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final ScrollBarDirection direction;
    public int grabberWidth;
    public int grabberHeight;
    public int scrollAreaStartX;
    public int scrollAreaStartY;
    public int scrollAreaEndX;
    public int scrollAreaEndY;
    public Color idleBarColor;
    public Color hoverBarColor;
    public class_2960 idleBarTexture;
    public class_2960 hoverBarTexture;
    public boolean active = true;
    protected boolean allowScrollWheel = false;
    protected float grabberScrollSpeed = 1.0f;
    protected float wheelScrollSpeed = 1.0f;
    protected float scroll = 0.0f;
    protected boolean leftMouseDown = false;
    protected int lastGrabberX = 0;
    protected int lastGrabberY = 0;
    protected boolean grabbed = false;
    protected int grabbedAtX = 0;
    protected int grabbedAtY = 0;
    protected float grabbedAtScroll = 0.0f;
    protected volatile long lastTick;
    protected List<Consumer<ScrollBar>> scrollListeners = new ArrayList<Consumer<ScrollBar>>();

    public ScrollBar(@NotNull ScrollBarDirection direction, int grabberWidth, int grabberHeight, int scrollAreaStartX, int scrollAreaStartY, int scrollAreaEndX, int scrollAreaEndY, Color idleBarColor, Color hoverBarColor) {
        this(direction, grabberWidth, grabberHeight, scrollAreaStartX, scrollAreaStartY, scrollAreaEndX, scrollAreaEndY);
        this.idleBarColor = idleBarColor;
        this.hoverBarColor = hoverBarColor;
    }

    public ScrollBar(@NotNull ScrollBarDirection direction, int grabberWidth, int grabberHeight, int scrollAreaStartX, int scrollAreaStartY, int scrollAreaEndX, int scrollAreaEndY, class_2960 idleBarTexture, class_2960 hoverBarTexture) {
        this(direction, grabberWidth, grabberHeight, scrollAreaStartX, scrollAreaStartY, scrollAreaEndX, scrollAreaEndY);
        this.idleBarTexture = idleBarTexture;
        this.hoverBarTexture = hoverBarTexture;
    }

    protected ScrollBar(ScrollBarDirection direction, int grabberWidth, int grabberHeight, int scrollAreaStartX, int scrollAreaStartY, int scrollAreaEndX, int scrollAreaEndY) {
        this.direction = direction;
        this.grabberWidth = grabberWidth;
        this.grabberHeight = grabberHeight;
        this.scrollAreaStartX = scrollAreaStartX;
        this.scrollAreaStartY = scrollAreaStartY;
        this.scrollAreaEndX = scrollAreaEndX;
        this.scrollAreaEndY = scrollAreaEndY;
    }

    public void render(class_4587 matrix) {
        int x = this.scrollAreaEndX - this.grabberWidth;
        int y = this.scrollAreaEndY - this.grabberHeight;
        if (this.direction == ScrollBarDirection.VERTICAL) {
            int usableAreaHeight = this.scrollAreaEndY - this.scrollAreaStartY - this.grabberHeight;
            y = this.scrollAreaStartY + (int)((float)usableAreaHeight * this.scroll);
        } else {
            int usableAreaWidth = this.scrollAreaEndX - this.scrollAreaStartX - this.grabberWidth;
            x = this.scrollAreaStartX + (int)((float)usableAreaWidth * this.scroll);
        }
        this.lastGrabberX = x;
        this.lastGrabberY = y;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isGrabberHovered() || this.isGrabberGrabbed()) {
            if (this.hoverBarTexture != null) {
                RenderUtils.bindTexture((class_2960)this.hoverBarTexture);
                ScrollBar.method_25290((class_4587)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.grabberWidth, (int)this.grabberHeight, (int)this.grabberWidth, (int)this.grabberHeight);
            } else if (this.hoverBarColor != null) {
                ScrollBar.method_25294((class_4587)matrix, (int)x, (int)y, (int)(x + this.grabberWidth), (int)(y + this.grabberHeight), (int)this.hoverBarColor.getRGB());
            }
        } else if (this.idleBarTexture != null) {
            RenderUtils.bindTexture((class_2960)this.idleBarTexture);
            ScrollBar.method_25290((class_4587)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.grabberWidth, (int)this.grabberHeight, (int)this.grabberWidth, (int)this.grabberHeight);
        } else if (this.idleBarColor != null) {
            ScrollBar.method_25294((class_4587)matrix, (int)x, (int)y, (int)(x + this.grabberWidth), (int)(y + this.grabberHeight), (int)this.idleBarColor.getRGB());
        }
        this.handleGrabberScrolling();
        ScrollBarHandler.handleScrollBar(this);
    }

    protected void handleGrabberScrolling() {
        if (!this.active) {
            return;
        }
        int mouseX = MouseInput.getMouseX();
        int mouseY = MouseInput.getMouseY();
        if (this.isGrabberHovered() && MouseInput.isLeftMouseDown()) {
            if (!this.grabbed && !this.leftMouseDown) {
                this.grabbed = true;
                this.grabbedAtX = mouseX;
                this.grabbedAtY = mouseY;
                this.grabbedAtScroll = this.scroll;
            }
        } else if (!MouseInput.isLeftMouseDown()) {
            this.grabbed = false;
        }
        this.leftMouseDown = MouseInput.isLeftMouseDown();
        if (this.grabbed) {
            float scrollOffset;
            int usableAreaWidth = this.scrollAreaEndX - this.scrollAreaStartX - this.grabberWidth;
            int usableAreaHeight = this.scrollAreaEndY - this.scrollAreaStartY - this.grabberHeight;
            int diffX = (int)(((float)Math.max(mouseX, this.grabbedAtX) - (float)Math.min(mouseX, this.grabbedAtX)) * this.grabberScrollSpeed);
            int diffY = (int)(((float)Math.max(mouseY, this.grabbedAtY) - (float)Math.min(mouseY, this.grabbedAtY)) * this.grabberScrollSpeed);
            if (this.direction == ScrollBarDirection.VERTICAL) {
                scrollOffset = (float)diffY / (float)usableAreaHeight;
                if (mouseY < this.grabbedAtY) {
                    scrollOffset = -scrollOffset;
                }
            } else {
                scrollOffset = (float)diffX / (float)usableAreaWidth;
                if (mouseX < this.grabbedAtX) {
                    scrollOffset = -scrollOffset;
                }
            }
            this.setScroll(this.grabbedAtScroll + scrollOffset);
        }
    }

    protected void handleWheelScrolling(GuiScreenEvent.MouseScrollEvent.Pre e) {
        if (this.active && this.allowScrollWheel && this.isMouseInsideScrollArea(true) && !this.grabbed) {
            float scrollOffset = 0.1f * this.wheelScrollSpeed;
            if (e.getScrollDelta() > 0.0) {
                scrollOffset = -scrollOffset;
            }
            this.setScroll(this.getScroll() + scrollOffset);
        }
    }

    public boolean isGrabberHovered() {
        if (!this.active) {
            return false;
        }
        int x = this.lastGrabberX;
        int y = this.lastGrabberY;
        int mouseX = MouseInput.getMouseX();
        int mouseY = MouseInput.getMouseY();
        return mouseX >= x && mouseX <= x + this.grabberWidth && mouseY >= y && mouseY <= y + this.grabberHeight;
    }

    public boolean isGrabberGrabbed() {
        return this.active && this.grabbed;
    }

    public boolean isMouseInsideScrollArea(boolean ignoreGrabber) {
        if (!this.active) {
            return false;
        }
        if (!ignoreGrabber && (this.isGrabberGrabbed() || this.isGrabberHovered())) {
            return false;
        }
        int x = this.scrollAreaStartX;
        int y = this.scrollAreaStartY;
        int width = this.scrollAreaEndX - this.scrollAreaStartX;
        int height = this.scrollAreaEndY - this.scrollAreaStartY;
        int mouseX = MouseInput.getMouseX();
        int mouseY = MouseInput.getMouseY();
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public float getScroll() {
        return this.scroll;
    }

    public void setScroll(float scroll) {
        this.setScroll(scroll, true);
    }

    public void setScroll(float scroll, boolean informScrollListeners) {
        this.scroll = Math.min(1.0f, Math.max(0.0f, scroll));
        if (informScrollListeners) {
            for (Consumer<ScrollBar> listener : this.scrollListeners) {
                listener.accept(this);
            }
        }
    }

    public float getGrabberScrollSpeed() {
        return this.grabberScrollSpeed;
    }

    public void setGrabberScrollSpeed(float speed) {
        this.grabberScrollSpeed = Math.max(0.0f, speed);
    }

    public float getWheelScrollSpeed() {
        return this.wheelScrollSpeed;
    }

    public void setWheelScrollSpeed(float speed) {
        this.wheelScrollSpeed = Math.max(0.0f, speed);
    }

    public boolean isScrollWheelAllowed() {
        return this.allowScrollWheel;
    }

    public void setScrollWheelAllowed(boolean allowed) {
        this.allowScrollWheel = allowed;
    }

    public ScrollBarDirection getDirection() {
        return this.direction;
    }

    public void registerScrollListener(Consumer<ScrollBar> listener) {
        this.scrollListeners.add(listener);
    }

    public static enum ScrollBarDirection {
        HORIZONTAL,
        VERTICAL;

    }
}

