/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderParser;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class StringCustomizationItem
extends CustomizationItemBase {
    public float scale = 1.0f;
    public boolean shadow = false;
    public CustomizationItemBase.Alignment alignment = CustomizationItemBase.Alignment.LEFT;
    public String valueRaw;

    public StringCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addtext")) {
            String al;
            String sc;
            this.valueRaw = item.getEntryValue("value");
            this.updateValue();
            String sh = item.getEntryValue("shadow");
            if (sh != null && sh.equalsIgnoreCase("true")) {
                this.shadow = true;
            }
            if ((sc = item.getEntryValue("scale")) != null && MathUtils.isFloat((String)sc)) {
                this.scale = Float.parseFloat(sc);
            }
            if ((al = item.getEntryValue("alignment")) != null) {
                if (al.equalsIgnoreCase("right")) {
                    this.alignment = CustomizationItemBase.Alignment.RIGHT;
                }
                if (al.equalsIgnoreCase("centered")) {
                    this.alignment = CustomizationItemBase.Alignment.CENTERED;
                }
            }
        }
    }

    protected void updateValue() {
        if (this.valueRaw != null) {
            this.value = !StringCustomizationItem.isEditorActive() ? PlaceholderParser.replacePlaceholders(this.valueRaw) : StringUtils.convertFormatCodes((String)this.valueRaw, (String)"&", (String)"\u00a7");
        }
        this.setWidth((int)((float)class_310.method_1551().field_1772.method_1727(this.value) * this.scale));
        Objects.requireNonNull(class_310.method_1551().field_1772);
        this.setHeight((int)(9.0f * this.scale));
    }

    @Override
    public void render(class_4587 matrix, class_437 menu) throws IOException {
        if (!this.shouldRender()) {
            return;
        }
        this.updateValue();
        int x = this.getPosX(menu);
        int y = this.getPosY(menu);
        class_327 font = class_310.method_1551().field_1772;
        RenderSystem.enableBlend();
        matrix.method_22903();
        matrix.method_22905(this.scale, this.scale, this.scale);
        if (this.shadow) {
            font.method_1720(matrix, "\u00a7f" + this.value, (float)x, (float)y, 0 | class_3532.method_15386((float)(this.opacity * 255.0f)) << 24);
        } else {
            font.method_1729(matrix, "\u00a7f" + this.value, (float)x, (float)y, 0 | class_3532.method_15386((float)(this.opacity * 255.0f)) << 24);
        }
        matrix.method_22909();
        RenderSystem.disableBlend();
    }

    @Override
    public int getPosX(class_437 menu) {
        int x = super.getPosX(menu);
        if (this.value != null) {
            if (this.alignment == CustomizationItemBase.Alignment.CENTERED) {
                x -= (int)((float)(class_310.method_1551().field_1772.method_1727(this.value) / 2) * this.scale);
            } else if (this.alignment == CustomizationItemBase.Alignment.RIGHT) {
                x -= (int)((float)class_310.method_1551().field_1772.method_1727(this.value) * this.scale);
            }
        }
        x = (int)((float)x / this.scale);
        return x;
    }

    @Override
    public int getPosY(class_437 menu) {
        return (int)((float)super.getPosY(menu) / this.scale);
    }
}

