/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.items.slider;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.api.item.CustomizationItem;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.slider.AdvancedSliderButton;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.slider.ListSliderButton;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.slider.RangeSliderButton;
import de.keksuccino.fancymenu.menu.variables.VariableHandler;
import de.keksuccino.konkrete.gui.content.widget.WidgetUtils;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class SliderCustomizationItem
extends CustomizationItem {
    public String linkedVariable;
    public SliderType type = SliderType.RANGE;
    public List<String> listValues = new ArrayList<String>();
    public int minRangeValue = 1;
    public int maxRangeValue = 10;
    public String labelPrefix;
    public String labelSuffix;
    public AdvancedSliderButton slider;

    public SliderCustomizationItem(CustomizationItemContainer parentContainer, PropertiesSection item) {
        super(parentContainer, item);
        String listValueString;
        SliderType t;
        this.linkedVariable = item.getEntryValue("linked_variable");
        String sliderTypeString = item.getEntryValue("slider_type");
        if (sliderTypeString != null && (t = SliderType.getByName(sliderTypeString)) != null) {
            this.type = t;
        }
        this.labelPrefix = item.getEntryValue("label_prefix");
        this.labelSuffix = item.getEntryValue("label_suffix");
        if (this.type == SliderType.RANGE) {
            String maxRangeString;
            String minRangeString = item.getEntryValue("min_range_value");
            if (minRangeString != null && MathUtils.isInteger((String)minRangeString)) {
                this.minRangeValue = Integer.parseInt(minRangeString);
            }
            if ((maxRangeString = item.getEntryValue("max_range_value")) != null && MathUtils.isInteger((String)maxRangeString)) {
                this.maxRangeValue = Integer.parseInt(maxRangeString);
            }
        }
        if (this.type == SliderType.LIST && (listValueString = item.getEntryValue("list_values")) != null) {
            this.listValues = SliderCustomizationItem.deserializeValuesList(listValueString);
        }
        if (this.listValues.isEmpty()) {
            this.listValues.add("some_value");
            this.listValues.add("another_value");
            this.listValues.add("yet_another_value");
        }
        if (this.listValues.size() == 1) {
            this.listValues.add("dummy_value");
        }
        this.initializeSlider();
    }

    public void initializeSlider() {
        String valString = null;
        if (this.linkedVariable != null) {
            valString = VariableHandler.getVariable(this.linkedVariable);
        }
        class_437 current = class_310.method_1551().field_1755;
        if (this.type == SliderType.RANGE) {
            int selectedRangeValue = this.minRangeValue;
            if (valString != null && MathUtils.isInteger((String)valString)) {
                selectedRangeValue = Integer.parseInt(valString);
            }
            this.slider = new RangeSliderButton(this.getPosX(current), this.getPosY(current), this.getWidth(), this.getHeight(), true, this.minRangeValue, this.maxRangeValue, selectedRangeValue, apply -> {
                if (this.linkedVariable != null) {
                    VariableHandler.setVariable(this.linkedVariable, "" + ((RangeSliderButton)((Object)apply)).getSelectedRangeValue());
                }
            });
        }
        if (this.type == SliderType.LIST) {
            int selectedIndex = 0;
            if (valString != null) {
                int i = 0;
                for (String s : this.listValues) {
                    if (s.equals(valString)) {
                        selectedIndex = i;
                        break;
                    }
                    ++i;
                }
            }
            this.slider = new ListSliderButton(this.getPosX(current), this.getPosY(current), this.getWidth(), this.getHeight(), true, this.listValues, selectedIndex, apply -> {
                if (this.linkedVariable != null) {
                    VariableHandler.setVariable(this.linkedVariable, ((ListSliderButton)((Object)apply)).getSelectedListValue());
                }
            });
        }
        if (this.slider != null) {
            this.slider.setLabelPrefix(this.labelPrefix);
            this.slider.setLabelSuffix(this.labelSuffix);
        }
    }

    @Override
    public void render(class_4587 matrix, class_437 menu) throws IOException {
        if (this.shouldRender()) {
            String valString;
            RenderSystem.enableBlend();
            if (SliderCustomizationItem.isEditorActive()) {
                this.slider.field_22763 = false;
            }
            this.slider.field_22760 = this.getPosX(menu);
            this.slider.field_22761 = this.getPosY(menu);
            this.slider.method_25358(this.getWidth());
            WidgetUtils.setHeight((class_339)this.slider, (int)this.getHeight());
            this.slider.method_25394(matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), class_310.method_1551().method_1534());
            if (this.linkedVariable != null && (valString = VariableHandler.getVariable(this.linkedVariable)) != null) {
                if (this.type == SliderType.RANGE && MathUtils.isInteger((String)valString)) {
                    int val = Integer.parseInt(valString);
                    if (((RangeSliderButton)this.slider).getSelectedRangeValue() != val) {
                        ((RangeSliderButton)this.slider).setSelectedRangeValue(val);
                    }
                }
                if (this.type == SliderType.LIST && !((ListSliderButton)this.slider).getSelectedListValue().equals(valString)) {
                    int newIndex = 0;
                    int i = 0;
                    for (String s : this.listValues) {
                        if (s.equals(valString)) {
                            newIndex = i;
                            break;
                        }
                        ++i;
                    }
                    ((ListSliderButton)this.slider).setSelectedIndex(newIndex);
                }
            }
            if (this.type == SliderType.RANGE) {
                ((RangeSliderButton)this.slider).maxValue = this.maxRangeValue;
                ((RangeSliderButton)this.slider).minValue = this.minRangeValue;
            }
        }
    }

    public static String serializeValuesList(List<String> list) {
        Object s = "";
        for (String s2 : list) {
            s = (String)s + s2 + ";";
        }
        return s;
    }

    public static List<String> deserializeValuesList(String list) {
        ArrayList<String> l = new ArrayList<String>();
        if (list.contains(";")) {
            for (String s : list.split("[;]")) {
                if (s.replace(" ", "").equals("")) continue;
                l.add(s);
            }
        }
        return l;
    }

    public static enum SliderType {
        LIST("list"),
        RANGE("range");

        String name;

        private SliderType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static SliderType getByName(String name) {
            for (SliderType i : SliderType.values()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }
    }
}

