/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.items.text;

import com.google.common.collect.LinkedListMultimap;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.api.item.CustomizationItem;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationHelper;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderParser;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.web.WebUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5348;

public class TextCustomizationItem
extends CustomizationItem {
    public SourceMode sourceMode = SourceMode.DIRECT;
    public String source;
    public boolean shadow = true;
    public CaseMode caseMode = CaseMode.NORMAL;
    public float scale = 1.0f;
    public CustomizationItemBase.Alignment alignment = CustomizationItemBase.Alignment.LEFT;
    public String baseColorHex = null;
    public int textBorder = 0;
    public int lineSpacing = 1;
    public String scrollGrabberTextureNormal = null;
    public String scrollGrabberTextureHover = null;
    public String scrollGrabberColorHexNormal = null;
    public String scrollGrabberColorHexHover = null;
    public boolean enableScrolling = true;
    protected class_327 font;
    public volatile ScrollArea scrollArea;
    public volatile LinkedListMultimap<String, Float> lines;
    public volatile boolean updating;
    public volatile int cachedTextWidth;

    public TextCustomizationItem(CustomizationItemContainer parentContainer, PropertiesSection item) {
        super(parentContainer, item);
        String lineSpacingString;
        String textBorderString;
        Color c;
        String baseColorString;
        CustomizationItemBase.Alignment a;
        String alignmentString;
        String scaleString;
        CaseMode c2;
        String caseModeString;
        String shadowString;
        SourceMode s;
        this.font = class_310.method_1551().field_1772;
        this.lines = LinkedListMultimap.create();
        this.updating = false;
        this.cachedTextWidth = 0;
        this.source = item.getEntryValue("source");
        String sourceModeString = item.getEntryValue("source_mode");
        if (sourceModeString != null && (s = SourceMode.getByName(sourceModeString)) != null) {
            this.sourceMode = s;
        }
        if ((shadowString = item.getEntryValue("shadow")) != null && shadowString.equals("false")) {
            this.shadow = false;
        }
        if ((caseModeString = item.getEntryValue("case_mode")) != null && (c2 = CaseMode.getByName(caseModeString)) != null) {
            this.caseMode = c2;
        }
        if ((scaleString = item.getEntryValue("scale")) != null && MathUtils.isFloat((String)scaleString)) {
            this.scale = Float.parseFloat(scaleString);
        }
        if ((alignmentString = item.getEntryValue("alignment")) != null && (a = CustomizationItemBase.Alignment.getByName(alignmentString)) != null) {
            this.alignment = a;
        }
        if ((baseColorString = item.getEntryValue("base_color")) != null && (c = RenderUtils.getColorFromHexString((String)baseColorString)) != null) {
            this.baseColorHex = baseColorString;
        }
        if ((textBorderString = item.getEntryValue("text_border")) != null && MathUtils.isInteger((String)textBorderString)) {
            this.textBorder = Integer.parseInt(textBorderString);
        }
        if ((lineSpacingString = item.getEntryValue("line_spacing")) != null && MathUtils.isInteger((String)lineSpacingString)) {
            this.lineSpacing = Integer.parseInt(lineSpacingString);
        }
        this.scrollGrabberColorHexNormal = item.getEntryValue("grabber_color_normal");
        this.scrollGrabberColorHexHover = item.getEntryValue("grabber_color_hover");
        this.scrollGrabberTextureNormal = item.getEntryValue("grabber_texture_normal");
        this.scrollGrabberTextureHover = item.getEntryValue("grabber_texture_hover");
        String enableScrollingString = item.getEntryValue("enable_scrolling");
        if (enableScrollingString != null && enableScrollingString.equals("false")) {
            this.enableScrolling = false;
        }
        this.updateContent();
    }

    public void updateScrollArea() {
        ExternalTextureResourceLocation r;
        Color c;
        this.scrollArea = new ScrollArea(0, 0, this.getWidth(), this.getHeight()){

            @Override
            public void render(class_4587 matrix, int mouseX, int mouseY, float partial) {
                super.render(matrix, mouseX, mouseY, partial);
                this.verticalScrollBar.active = this.getTotalEntryHeight() > this.getInnerHeight() && TextCustomizationItem.this.enableScrolling;
            }

            @Override
            public void updateScrollArea() {
                super.updateScrollArea();
                if (class_310.method_1551().field_1755 != null) {
                    this.verticalScrollBar.scrollAreaEndX = TextCustomizationItem.this.getPosX(class_310.method_1551().field_1755) + TextCustomizationItem.this.getWidth() + 12;
                    this.horizontalScrollBar.scrollAreaEndY = TextCustomizationItem.this.getPosY(class_310.method_1551().field_1755) + TextCustomizationItem.this.getHeight() + 12;
                }
            }
        };
        this.scrollArea.verticalScrollBar.grabberWidth = 10;
        this.scrollArea.verticalScrollBar.grabberHeight = 20;
        this.scrollArea.horizontalScrollBar.grabberWidth = 20;
        this.scrollArea.horizontalScrollBar.grabberHeight = 10;
        this.scrollArea.backgroundColor = new Color(0, 0, 0, 0);
        this.scrollArea.borderColor = new Color(0, 0, 0, 0);
        this.scrollArea.verticalScrollBar.setScrollWheelAllowed(this.enableScrolling);
        this.scrollArea.verticalScrollBar.active = false;
        this.scrollArea.horizontalScrollBar.active = false;
        if (this.scrollGrabberColorHexNormal != null && (c = RenderUtils.getColorFromHexString((String)this.scrollGrabberColorHexNormal)) != null) {
            this.scrollArea.verticalScrollBar.idleBarColor = c;
            this.scrollArea.horizontalScrollBar.idleBarColor = c;
        }
        if (this.scrollGrabberColorHexHover != null && (c = RenderUtils.getColorFromHexString((String)this.scrollGrabberColorHexHover)) != null) {
            this.scrollArea.verticalScrollBar.hoverBarColor = c;
            this.scrollArea.horizontalScrollBar.hoverBarColor = c;
        }
        if (this.scrollGrabberTextureNormal != null && (r = TextureHandler.getResource((String)this.scrollGrabberTextureNormal)) != null) {
            this.scrollArea.verticalScrollBar.idleBarTexture = r.getResourceLocation();
            this.scrollArea.horizontalScrollBar.idleBarTexture = r.getResourceLocation();
        }
        if (this.scrollGrabberTextureHover != null && (r = TextureHandler.getResource((String)this.scrollGrabberTextureHover)) != null) {
            this.scrollArea.verticalScrollBar.hoverBarTexture = r.getResourceLocation();
            this.scrollArea.horizontalScrollBar.hoverBarTexture = r.getResourceLocation();
        }
        LineScrollEntry borderTop = new LineScrollEntry(this.scrollArea, " ", false, 1.0f, this);
        borderTop.setHeight(this.textBorder);
        this.scrollArea.addEntry(borderTop);
        for (Map.Entry m : this.lines.entries()) {
            this.scrollArea.addEntry(new LineScrollEntry(this.scrollArea, (String)m.getKey(), false, this.scale, this));
        }
        LineScrollEntry borderBottom = new LineScrollEntry(this.scrollArea, " ", false, 1.0f, this);
        borderBottom.setHeight(this.textBorder);
        this.scrollArea.addEntry(borderBottom);
    }

    public Color getBaseColor() {
        if (this.baseColorHex != null) {
            return RenderUtils.getColorFromHexString((String)this.baseColorHex);
        }
        return null;
    }

    @Override
    public void render(class_4587 matrix, class_437 menu) throws IOException {
        try {
            if (this.source != null) {
                this.value = this.source;
            }
            if (this.shouldRender()) {
                if (!this.updating) {
                    RenderSystem.enableBlend();
                    if (this.scrollArea != null) {
                        this.scrollArea.customGuiScale = this.customGuiScale;
                        this.scrollArea.setX(this.getPosX(menu), true);
                        this.scrollArea.setY(this.getPosY(menu), true);
                        this.scrollArea.setWidth(this.getWidth(), true);
                        this.scrollArea.setHeight(this.getHeight(), true);
                        this.scrollArea.render(matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), UIBase.getPartialTick());
                    }
                } else if (TextCustomizationItem.isEditorActive()) {
                    TextCustomizationItem.method_25294((class_4587)matrix, (int)this.getPosX(menu), (int)this.getPosY(menu), (int)(this.getPosX(menu) + this.getWidth()), (int)(this.getPosY(menu) + this.getHeight()), (int)Color.MAGENTA.getRGB());
                    String string = Locals.localize((String)"fancymenu.customization.items.text.status.loading", (String[])new String[0]);
                    int n = this.getPosX(menu) + this.getWidth() / 2;
                    int n2 = this.getPosY(menu) + this.getHeight() / 2;
                    Objects.requireNonNull(this.font);
                    TextCustomizationItem.method_25300((class_4587)matrix, (class_327)this.font, (String)string, (int)n, (int)(n2 - 9 / 2), (int)-1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateContent() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        this.cachedTextWidth = 0;
        new Thread(() -> {
            ArrayList<String> linesRaw;
            block24: {
                linesRaw = new ArrayList<String>();
                try {
                    if (this.source != null && !this.source.equals("")) {
                        if (this.sourceMode == SourceMode.DIRECT) {
                            if (this.source.replace("\\n", "%n%").replace("\\r", "%n%").contains("%n%")) {
                                linesRaw.addAll(Arrays.asList(StringUtils.splitLines((String)this.source.replace("\\n", "%n%").replace("\\r", "%n%"), (String)"%n%")));
                            } else {
                                linesRaw.add(this.source);
                            }
                            break block24;
                        }
                        if (this.sourceMode == SourceMode.LOCAL_SOURCE) {
                            File f = new File(PlaceholderParser.replacePlaceholders(this.source));
                            if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/"))) {
                                f = new File(class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/") + "/" + PlaceholderParser.replacePlaceholders(this.source));
                            }
                            if (f.isFile()) {
                                linesRaw.addAll(FileUtils.getFileLines((File)f));
                            }
                            break block24;
                        }
                        if (this.sourceMode != SourceMode.WEB_SOURCE) break block24;
                        if (WebUtils.isValidUrl((String)StringUtils.convertFormatCodes((String)PlaceholderParser.replacePlaceholders(this.source), (String)"\u00a7", (String)"&"))) {
                            String path;
                            Object fixedSource = StringUtils.convertFormatCodes((String)PlaceholderParser.replacePlaceholders(this.source), (String)"\u00a7", (String)"&");
                            if (((String)fixedSource).toLowerCase().contains("/blob/") && (((String)fixedSource).toLowerCase().startsWith("http://github.com/") || ((String)fixedSource).toLowerCase().startsWith("https://github.com/") || ((String)fixedSource).toLowerCase().startsWith("http://www.github.com/") || ((String)fixedSource).toLowerCase().startsWith("https://www.github.com/"))) {
                                path = ((String)fixedSource).replace("//", "").split("/", 2)[1].replace("/blob/", "/");
                                fixedSource = "https://raw.githubusercontent.com/" + path;
                            }
                            if (!((String)fixedSource).toLowerCase().contains("/raw/") && (((String)fixedSource).toLowerCase().startsWith("http://pastebin.com/") || ((String)fixedSource).toLowerCase().startsWith("https://pastebin.com/") || ((String)fixedSource).toLowerCase().startsWith("http://www.pastebin.com/") || ((String)fixedSource).toLowerCase().startsWith("https://www.pastebin.com/"))) {
                                path = ((String)fixedSource).replace("//", "").split("/", 2)[1];
                                fixedSource = "https://pastebin.com/raw/" + path;
                            }
                            BufferedReader r = null;
                            try {
                                URL url = new URL((String)fixedSource);
                                r = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                                String s = r.readLine();
                                while (s != null) {
                                    linesRaw.add(s);
                                    s = r.readLine();
                                }
                                r.close();
                            }
                            catch (Exception e) {
                                if (r != null) {
                                    try {
                                        r.close();
                                    }
                                    catch (Exception e2) {
                                        e2.printStackTrace();
                                    }
                                }
                                linesRaw.clear();
                            }
                            break block24;
                        }
                        linesRaw.clear();
                        break block24;
                    }
                    linesRaw.add(Locals.localize((String)"fancymenu.customization.items.text.placeholder", (String[])new String[0]));
                }
                catch (Exception e) {
                    linesRaw.clear();
                }
            }
            this.lines.clear();
            if (linesRaw.isEmpty()) {
                if (TextCustomizationItem.isEditorActive()) {
                    linesRaw.add(Locals.localize((String)"fancymenu.customization.items.text.status.unable_to_load", (String[])new String[0]));
                } else {
                    linesRaw.add("");
                }
            }
            for (String s : linesRaw) {
                float sc = TextCustomizationItem.getScaleMultiplicator(s);
                s = TextCustomizationItem.getWithoutHeadlineCodes(s);
                if (this.caseMode == CaseMode.ALL_LOWER) {
                    s = s.toLowerCase();
                }
                if (this.caseMode == CaseMode.ALL_UPPER) {
                    s = s.toUpperCase();
                }
                this.lines.put((Object)s, (Object)Float.valueOf(sc));
            }
            CustomizationHelper.runTaskInMainThread(this::updateScrollArea);
            this.updating = false;
        }).start();
    }

    protected static float getScaleMultiplicator(String s) {
        if (s.startsWith("### ")) {
            return 1.1f;
        }
        if (s.startsWith("## ")) {
            return 1.3f;
        }
        if (s.startsWith("# ")) {
            return 1.5f;
        }
        return 1.0f;
    }

    protected static String getWithoutHeadlineCodes(String s) {
        if (s.startsWith("### ")) {
            return s.substring(4);
        }
        if (s.startsWith("## ")) {
            return s.substring(3);
        }
        if (s.startsWith("# ")) {
            return s.substring(2);
        }
        return s;
    }

    public static enum SourceMode {
        DIRECT("direct"),
        LOCAL_SOURCE("local"),
        WEB_SOURCE("web");

        String name;

        private SourceMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static SourceMode getByName(String name) {
            for (SourceMode i : SourceMode.values()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }
    }

    public static enum CaseMode {
        NORMAL("normal"),
        ALL_LOWER("lower"),
        ALL_UPPER("upper");

        String name;

        private CaseMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static CaseMode getByName(String name) {
            for (CaseMode i : CaseMode.values()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }
    }

    public static class LineScrollEntry
    extends TextScrollAreaEntry {
        public final String textRaw;
        public final boolean bold;
        public final float scale;
        public final TextCustomizationItem parentItem;
        protected String lastTextToRender;

        public LineScrollEntry(ScrollArea parent, String textRaw, boolean bold, float scale, TextCustomizationItem parentItem) {
            super(parent, (class_2561)class_2561.method_43470((String)""), entry -> {});
            this.textRaw = textRaw;
            this.bold = bold;
            this.scale = scale;
            this.parentItem = parentItem;
            this.focusable = false;
            this.playClickSound = false;
            this.backgroundColorIdle = new Color(0, 0, 0, 0);
            this.backgroundColorHover = new Color(0, 0, 0, 0);
            this.buttonBase.method_25350(0.0f);
            Objects.requireNonNull(class_310.method_1551().field_1772);
            this.setHeight((int)(9.0f * scale) + parentItem.lineSpacing);
        }

        @Override
        public void render(class_4587 matrix, int mouseX, int mouseY, float partial) {
            String textToRender;
            RenderSystem.enableBlend();
            String string = textToRender = TextCustomizationItem.isEditorActive() ? StringUtils.convertFormatCodes((String)this.textRaw, (String)"&", (String)"\u00a7") : PlaceholderParser.replacePlaceholders(this.textRaw);
            if (this.parentItem.caseMode == CaseMode.ALL_LOWER) {
                textToRender = textToRender.toLowerCase();
            } else if (this.parentItem.caseMode == CaseMode.ALL_UPPER) {
                textToRender = textToRender.toUpperCase();
            }
            if (this.lastTextToRender == null || !this.lastTextToRender.equals(textToRender)) {
                this.setTextOfLine(class_2561.method_43470((String)textToRender));
                ((class_5250)this.getText()).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(this.bold)));
            }
            this.lastTextToRender = textToRender;
            this.updateEntry();
            this.buttonBase.method_25394(matrix, mouseX, mouseY, partial);
            int textX = (int)((float)this.getX() / this.scale);
            if (this.parentItem.alignment == CustomizationItemBase.Alignment.LEFT) {
                textX += this.parentItem.textBorder;
            } else if (this.parentItem.alignment == CustomizationItemBase.Alignment.RIGHT) {
                textX = (int)((float)textX + (float)(this.getWidth() - this.textWidth) / this.scale);
                textX -= this.parentItem.textBorder;
            } else if (this.parentItem.alignment == CustomizationItemBase.Alignment.CENTERED) {
                textX = (int)((float)textX + (float)(this.getWidth() - this.textWidth) / this.scale / 2.0f);
            }
            int centerY = (int)((float)this.getY() / this.scale) + this.getHeight() / 2;
            Objects.requireNonNull(this.font);
            int textY = centerY - (int)((float)(9 / 2) * this.scale);
            matrix.method_22903();
            matrix.method_22905(this.scale, this.scale, this.scale);
            Color c = this.parentItem.getBaseColor();
            int textColor = c != null ? class_5253.class_5254.method_27764((int)Math.max(0, Math.min(255, (int)(this.parentItem.opacity * 255.0f))), (int)c.getRed(), (int)c.getGreen(), (int)c.getBlue()) : class_5253.class_5254.method_27764((int)Math.max(0, Math.min(255, (int)(this.parentItem.opacity * 255.0f))), (int)255, (int)255, (int)255);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!this.parentItem.shadow) {
                this.font.method_30883(matrix, this.text, (float)textX, (float)textY, textColor);
            } else {
                this.font.method_30881(matrix, this.text, (float)textX, (float)textY, textColor);
            }
            matrix.method_22909();
        }

        public void setTextOfLine(class_5250 text) {
            this.text = text;
            this.textWidth = (int)((float)this.font.method_27525((class_5348)this.text) * this.scale);
            this.setWidth(this.parentItem.textBorder + this.textWidth + this.parentItem.textBorder);
        }
    }
}

