/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.panorama;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.CurrentScreenHandler;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class ExternalTexturePanoramaRenderer
extends class_332 {
    private ExternalTextureResourceLocation overlay_texture;
    private float time;
    private String name = null;
    public String dir;
    private boolean prepared = false;
    private List<ExternalTextureResourceLocation> pano = new ArrayList<ExternalTextureResourceLocation>();
    private float speed = 1.0f;
    private double fov = 85.0;
    private float angle = 25.0f;
    private class_310 mc = class_310.method_1551();
    public float opacity = 1.0f;

    public ExternalTexturePanoramaRenderer(String panoDir) {
        this.dir = panoDir;
        File props = new File(this.dir + "/properties.txt");
        if (props.exists()) {
            PropertiesSet s = PropertiesSerializer.getProperties((String)props.getPath());
            if (s != null) {
                List l = s.getPropertiesOfType("panorama-meta");
                if (l != null && !l.isEmpty()) {
                    String an;
                    String fo;
                    String sp;
                    this.name = ((PropertiesSection)l.get(0)).getEntryValue("name");
                    if (this.name == null) {
                        System.out.println("############## ERROR [FANCYMENU] ##############");
                        System.out.println("Missing 'name' value in properties file for panorama cube: " + this.dir);
                        System.out.println("###############################################");
                    }
                    if ((sp = ((PropertiesSection)l.get(0)).getEntryValue("speed")) != null && MathUtils.isFloat((String)sp)) {
                        this.speed = Float.parseFloat(sp);
                    }
                    if ((fo = ((PropertiesSection)l.get(0)).getEntryValue("fov")) != null && MathUtils.isDouble((String)fo)) {
                        this.fov = Double.parseDouble(fo);
                    }
                    if ((an = ((PropertiesSection)l.get(0)).getEntryValue("angle")) != null && MathUtils.isFloat((String)an)) {
                        this.angle = Float.parseFloat(an);
                    }
                } else {
                    System.out.println("############## ERROR [FANCYMENU] ##############");
                    System.out.println("Missing 'panorama-meta' section in properties file for panorama cube: " + this.dir);
                    System.out.println("###############################################");
                }
            } else {
                System.out.println("############## ERROR [FANCYMENU] ##############");
                System.out.println("An error happened while trying to get properties for panorama cube: " + this.dir);
                System.out.println("###############################################");
            }
        } else {
            System.out.println("############## ERROR [FANCYMENU] ##############");
            System.out.println("Properties file not found for panorama cube: " + this.dir);
            System.out.println("###############################################");
        }
    }

    public void preparePanorama() {
        File imagesDir;
        if (!this.prepared && this.name != null && (imagesDir = new File(this.dir + "/panorama")).exists() && imagesDir.isDirectory()) {
            for (int i = 0; i < 6; ++i) {
                File f = new File(this.dir + "/panorama/panorama_" + i + ".png");
                if (!f.exists() || !f.isFile()) {
                    System.out.println("############## ERROR [FANCYMENU] ##############");
                    System.out.println("Missing panorama image 'panorama_" + i + ".png' for panorama cube: " + this.name);
                    System.out.println("###############################################");
                    return;
                }
                ExternalTextureResourceLocation r = new ExternalTextureResourceLocation(f.getPath());
                this.pano.add(r);
            }
            File overlay = new File(this.dir + "/overlay.png");
            if (overlay.exists()) {
                this.overlay_texture = new ExternalTextureResourceLocation(overlay.getPath());
            }
            this.prepared = true;
        }
    }

    public void render() {
        try {
            this.renderRaw(this.opacity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void renderRaw(float panoramaAlpha) {
        if (this.prepared) {
            this.time += class_310.method_1551().method_1534() * this.speed;
            float pitch = class_3532.method_15374((float)(this.time * 0.001f)) * 5.0f + this.angle;
            float yaw = -this.time * 0.1f;
            class_289 tessellator = class_289.method_1348();
            class_287 bufferBuilder = tessellator.method_1349();
            class_1159 matrix4f = class_1159.method_4929((double)this.fov, (float)((float)this.mc.method_22683().method_4489() / (float)this.mc.method_22683().method_4506()), (float)0.05f, (float)10.0f);
            RenderSystem.backupProjectionMatrix();
            RenderSystem.setProjectionMatrix((class_1159)matrix4f);
            class_4587 matrix = RenderSystem.getModelViewStack();
            matrix.method_22903();
            matrix.method_34426();
            matrix.method_22907(class_1160.field_20703.method_23214(180.0f));
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.defaultBlendFunc();
            for (int j = 0; j < 4; ++j) {
                matrix.method_22903();
                float f = ((float)(j % 2) / 2.0f - 0.5f) / 256.0f;
                float g = ((float)(j / 2) / 2.0f - 0.5f) / 256.0f;
                matrix.method_22904((double)f, (double)g, 0.0);
                matrix.method_22907(class_1160.field_20703.method_23214(pitch));
                matrix.method_22907(class_1160.field_20705.method_23214(yaw));
                RenderSystem.applyModelViewMatrix();
                for (int k = 0; k < 6; ++k) {
                    ExternalTextureResourceLocation r = this.pano.get(k);
                    if (r == null) continue;
                    if (!r.isReady()) {
                        r.loadTexture();
                    }
                    RenderSystem.setShaderTexture((int)0, (class_2960)r.getResourceLocation());
                    bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                    int l = Math.round(255.0f * panoramaAlpha) / (j + 1);
                    if (k == 0) {
                        bufferBuilder.method_22912(-1.0, -1.0, 1.0).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(-1.0, 1.0, 1.0).method_22913(0.0f, 1.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(1.0, 1.0, 1.0).method_22913(1.0f, 1.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(1.0, -1.0, 1.0).method_22913(1.0f, 0.0f).method_1336(255, 255, 255, l).method_1344();
                    }
                    if (k == 1) {
                        bufferBuilder.method_22912(1.0, -1.0, 1.0).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(1.0, 1.0, 1.0).method_22913(0.0f, 1.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(1.0, 1.0, -1.0).method_22913(1.0f, 1.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(1.0, -1.0, -1.0).method_22913(1.0f, 0.0f).method_1336(255, 255, 255, l).method_1344();
                    }
                    if (k == 2) {
                        bufferBuilder.method_22912(1.0, -1.0, -1.0).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(1.0, 1.0, -1.0).method_22913(0.0f, 1.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(-1.0, 1.0, -1.0).method_22913(1.0f, 1.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(-1.0, -1.0, -1.0).method_22913(1.0f, 0.0f).method_1336(255, 255, 255, l).method_1344();
                    }
                    if (k == 3) {
                        bufferBuilder.method_22912(-1.0, -1.0, -1.0).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(-1.0, 1.0, -1.0).method_22913(0.0f, 1.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(-1.0, 1.0, 1.0).method_22913(1.0f, 1.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(-1.0, -1.0, 1.0).method_22913(1.0f, 0.0f).method_1336(255, 255, 255, l).method_1344();
                    }
                    if (k == 4) {
                        bufferBuilder.method_22912(-1.0, -1.0, -1.0).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(-1.0, -1.0, 1.0).method_22913(0.0f, 1.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(1.0, -1.0, 1.0).method_22913(1.0f, 1.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(1.0, -1.0, -1.0).method_22913(1.0f, 0.0f).method_1336(255, 255, 255, l).method_1344();
                    }
                    if (k == 5) {
                        bufferBuilder.method_22912(-1.0, 1.0, 1.0).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(-1.0, 1.0, -1.0).method_22913(0.0f, 1.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(1.0, 1.0, -1.0).method_22913(1.0f, 1.0f).method_1336(255, 255, 255, l).method_1344();
                        bufferBuilder.method_22912(1.0, 1.0, 1.0).method_22913(1.0f, 0.0f).method_1336(255, 255, 255, l).method_1344();
                    }
                    tessellator.method_1350();
                }
                matrix.method_22909();
                RenderSystem.applyModelViewMatrix();
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            }
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.restoreProjectionMatrix();
            matrix.method_22909();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            if (this.overlay_texture != null) {
                if (!this.overlay_texture.isReady()) {
                    this.overlay_texture.loadTexture();
                }
                RenderSystem.setShader(class_757::method_34543);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                RenderSystem.enableBlend();
                RenderSystem.setShaderTexture((int)0, (class_2960)this.overlay_texture.getResourceLocation());
                ExternalTexturePanoramaRenderer.method_25290((class_4587)CurrentScreenHandler.getMatrixStack(), (int)0, (int)0, (float)0.0f, (float)0.0f, (int)class_310.method_1551().field_1755.field_22789, (int)class_310.method_1551().field_1755.field_22790, (int)class_310.method_1551().field_1755.field_22789, (int)class_310.method_1551().field_1755.field_22790);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public String getName() {
        return this.name;
    }

    public void setSpeed(float speed) {
        if (speed < 0.0f) {
            speed = 0.0f;
        }
        this.speed = speed;
    }

    public void setFov(double fov) {
        if (fov > 179.0) {
            fov = 179.0;
        }
        this.fov = fov;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }
}

