/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.placeholder.v2.placeholders.other;

import de.keksuccino.fancymenu.menu.placeholder.v2.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.menu.placeholder.v2.Placeholder;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RandomTextPlaceholder
extends Placeholder {
    public static Map<String, RandomTextPackage> randomTextIntervals = new HashMap<String, RandomTextPackage>();

    public RandomTextPlaceholder() {
        super("randomtext");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String pathString = dps.values.get("path");
        String intervalString = dps.values.get("interval");
        if (pathString != null && intervalString != null) {
            File path = new File(pathString);
            if (!path.exists() || !path.getAbsolutePath().replace("\\", "/").startsWith(class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/"))) {
                path = new File(class_310.method_1551().field_1697, pathString);
            }
            if (MathUtils.isLong((String)intervalString) && path.isFile() && path.getPath().toLowerCase().endsWith(".txt")) {
                RandomTextPackage p;
                long interval = Long.parseLong(intervalString) * 1000L;
                if (interval < 0L) {
                    interval = 0L;
                }
                long currentTime = System.currentTimeMillis();
                if (randomTextIntervals.containsKey(path.getPath())) {
                    p = randomTextIntervals.get(path.getPath());
                } else {
                    p = new RandomTextPackage();
                    randomTextIntervals.put(path.getPath(), p);
                }
                if ((interval > 0L || p.currentText == null) && p.lastChange + interval <= currentTime) {
                    p.lastChange = currentTime;
                    List txtLines = FileUtils.getFileLines((File)path);
                    p.currentText = !txtLines.isEmpty() ? (String)txtLines.get(MathUtils.getRandomNumberInRange((int)0, (int)(txtLines.size() - 1))) : null;
                }
                if (p.currentText != null) {
                    return p.currentText;
                }
                return "";
            }
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("path");
        l.add("interval");
        return l;
    }

    @Override
    public String getDisplayName() {
        return Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.variables.randomtext", (String[])new String[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.variables.randomtext.desc", (String[])new String[0]), (String)"%n%"));
    }

    @Override
    public String getCategory() {
        return Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        DeserializedPlaceholderString dps = new DeserializedPlaceholderString();
        dps.placeholder = this.getIdentifier();
        dps.values.put("path", "randomtexts.txt");
        dps.values.put("interval", "10");
        return dps;
    }

    public static class RandomTextPackage {
        public String currentText = null;
        public long lastChange = 0L;
    }
}

