/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.network;

import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import java.util.UUID;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.menu.MarketClientMenu;
import net.blay09.mods.farmingforblockheads.registry.MarketEntry;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class MarketListMessage {
    private final ArrayListMultimap<IMarketCategory, IMarketEntry> entryMap;

    public MarketListMessage(ArrayListMultimap<IMarketCategory, IMarketEntry> entryMap) {
        this.entryMap = entryMap;
    }

    public static MarketListMessage decode(class_2540 buf) {
        ArrayListMultimap entryMap = ArrayListMultimap.create();
        int categoryCount = buf.readByte();
        MarketRegistry.resetCategories();
        for (int i = 0; i < categoryCount; ++i) {
            class_2960 categoryId = buf.method_10810();
            String tooltipLangKey = buf.method_19772();
            class_1799 icon = buf.method_10819();
            byte sortIndex = buf.readByte();
            IMarketCategory category = FarmingForBlockheadsAPI.registerMarketCategoryAndReturn(categoryId, tooltipLangKey, icon, sortIndex);
            int entryCount = buf.readShort();
            for (int j = 0; j < entryCount; ++j) {
                entryMap.put((Object)category, (Object)MarketListMessage.readEntry(buf, category));
            }
        }
        return new MarketListMessage((ArrayListMultimap<IMarketCategory, IMarketEntry>)entryMap);
    }

    public static void encode(MarketListMessage message, class_2540 buf) {
        buf.writeByte(message.entryMap.keySet().size());
        for (IMarketCategory category : message.entryMap.keySet()) {
            buf.method_10812(category.getRegistryName());
            buf.method_10814(category.getTooltipLangKey());
            buf.method_10793(category.getIconStack());
            buf.writeByte(category.getSortIndex());
            List entries = message.entryMap.get((Object)category);
            buf.writeShort(entries.size());
            for (IMarketEntry entry : entries) {
                MarketListMessage.writeEntry(entry, buf);
            }
        }
    }

    public static void handle(class_1657 player, MarketListMessage message) {
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof MarketClientMenu) {
            MarketClientMenu marketClientMenu = (MarketClientMenu)class_17032;
            marketClientMenu.setCategoryList(message.entryMap.keySet());
            marketClientMenu.setEntryList(message.entryMap.values());
        }
    }

    private static MarketEntry readEntry(class_2540 buf, IMarketCategory category) {
        UUID entryId = buf.method_10790();
        class_1799 outputItem = buf.method_10819();
        class_1799 costItem = buf.method_10819();
        return new MarketEntry(entryId, outputItem, costItem, category);
    }

    private static void writeEntry(IMarketEntry entry, class_2540 buf) {
        buf.method_10797(entry.getEntryId());
        buf.method_10793(entry.getOutputItem());
        buf.method_10793(entry.getCostItem());
    }
}

