/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.data.ClaimResult;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.net.ChunkChangeResponsePacket;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.math.XZ;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_2168;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class RequestChunkChangePacket
extends BaseC2SMessage {
    private static final String[] ACTION_NAMES = new String[]{"claim", "unclaim", "load", "unload"};
    public static final int CLAIM = 0;
    public static final int UNCLAIM = 1;
    public static final int LOAD = 2;
    public static final int UNLOAD = 3;
    private final int action;
    private final Set<XZ> chunks;

    public RequestChunkChangePacket(int a, Set<XZ> c) {
        this.action = a;
        this.chunks = c;
    }

    RequestChunkChangePacket(class_2540 buf) {
        this.action = buf.method_10816();
        int s = buf.method_10816();
        this.chunks = new LinkedHashSet<XZ>(s);
        for (int i = 0; i < s; ++i) {
            int x = buf.method_10816();
            int z = buf.method_10816();
            this.chunks.add(XZ.of((int)x, (int)z));
        }
    }

    public MessageType getType() {
        return FTBChunksNet.REQUEST_CHUNK_CHANGE;
    }

    public void write(class_2540 buf) {
        buf.method_10804(this.action);
        buf.method_10804(this.chunks.size());
        for (XZ pos : this.chunks) {
            buf.method_10804(pos.x);
            buf.method_10804(pos.z);
        }
    }

    public void handle(NetworkManager.PacketContext context) {
        Function<XZ, ClaimResult> consumer;
        class_3222 player = (class_3222)context.getPlayer();
        class_2168 source = player.method_5671();
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        switch (this.action) {
            case 0: {
                consumer = pos -> data.claim(source, pos.dim(player.field_6002), false);
                break;
            }
            case 1: {
                consumer = pos -> data.unclaim(source, pos.dim(player.field_6002), false);
                break;
            }
            case 2: {
                consumer = pos -> data.load(source, pos.dim(player.field_6002), false);
                break;
            }
            case 3: {
                consumer = pos -> data.unload(source, pos.dim(player.field_6002), false);
                break;
            }
            default: {
                FTBChunks.LOGGER.warn("Unknown chunk action ID: " + this.action);
                return;
            }
        }
        HashMap<String, Integer> problems = new HashMap<String, Integer>();
        int changed = 0;
        for (XZ pos2 : this.chunks) {
            ClaimResult r = consumer.apply(pos2);
            if (!r.isSuccess()) {
                FTBChunks.LOGGER.debug(String.format("%s tried to %s @ %s:%d:%d but got result %s", player.method_5820(), ACTION_NAMES[this.action], player.field_6002.method_27983().method_29177(), pos2.x, pos2.z, r));
                problems.put(r.getTranslationKey(), problems.getOrDefault(r.getTranslationKey(), 0) + 1);
                continue;
            }
            ++changed;
        }
        new ChunkChangeResponsePacket(this.chunks.size(), changed, problems).sendTo(player);
        SendGeneralDataPacket.send(data, player);
    }
}

