/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.FTBEssentialsPlatform;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.DurationInfo;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.OtherPlayerInventory;
import dev.ftb.mods.ftblibrary.util.PlayerDisplayNameUtil;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_5250;

public class CheatCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        if (FTBEConfig.HEAL.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"heal").requires(FTBEConfig.HEAL.enabledAndOp())).executes(context -> CheatCommands.heal(((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CheatCommands.heal(class_2186.method_9315((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.FLY.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fly").requires(FTBEConfig.FLY.enabledAndOp())).executes(context -> CheatCommands.fly(((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CheatCommands.fly(class_2186.method_9315((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.GOD.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"god").requires(FTBEConfig.GOD.enabledAndOp())).executes(context -> CheatCommands.god(((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CheatCommands.god(class_2186.method_9315((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.INVSEE.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"invsee").requires(FTBEConfig.INVSEE.enabledAndOp())).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CheatCommands.invsee(((class_2168)context.getSource()).method_9207(), class_2186.method_9315((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.NICK.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"nicknamefor").requires(FTBEConfig.NICK.enabledAndOp())).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> source.method_9259(2))).executes(context -> CheatCommands.nicknamefor((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), ""))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"nickname", (ArgumentType)StringArgumentType.greedyString()).requires(source -> source.method_9259(2))).executes(context -> CheatCommands.nicknamefor((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"nickname"))))));
        }
        if (FTBEConfig.MUTE.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mute").requires(FTBEConfig.MUTE.enabledAndOp())).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CheatCommands.mute((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), ""))).then(class_2170.method_9244((String)"until", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> CheatCommands.suggestTimeouts(builder)).executes(context -> CheatCommands.mute((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"until"))))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"unmute").requires(FTBEConfig.MUTE.enabledAndOp())).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CheatCommands.unmute((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))));
        }
    }

    public static int heal(class_3222 player) {
        player.method_6033(player.method_6063());
        player.method_7344().method_7585(40, 40.0f);
        player.method_5646();
        FTBEssentialsPlatform.curePotionEffects(player);
        return 1;
    }

    public static int fly(class_3222 player) {
        FTBEPlayerData data = FTBEPlayerData.get((class_1657)player);
        if (data == null) {
            return 0;
        }
        class_1656 abilities = player.method_31549();
        if (data.fly) {
            data.fly = false;
            data.markDirty();
            abilities.field_7478 = false;
            abilities.field_7479 = false;
            player.method_7353((class_2561)class_2561.method_43470((String)"Flight disabled"), true);
        } else {
            data.fly = true;
            data.markDirty();
            abilities.field_7478 = true;
            player.method_7353((class_2561)class_2561.method_43470((String)"Flight enabled"), true);
        }
        player.method_7355();
        return 1;
    }

    public static int god(class_3222 player) {
        FTBEPlayerData data = FTBEPlayerData.get((class_1657)player);
        if (data == null) {
            return 0;
        }
        class_1656 abilities = player.method_31549();
        if (data.god) {
            data.god = false;
            data.markDirty();
            abilities.field_7480 = false;
            player.method_7353((class_2561)class_2561.method_43470((String)"God mode disabled"), true);
        } else {
            data.god = true;
            data.markDirty();
            abilities.field_7480 = true;
            player.method_7353((class_2561)class_2561.method_43470((String)"God mode enabled"), true);
        }
        player.method_7355();
        return 1;
    }

    public static int invsee(class_3222 source, final class_3222 player) {
        source.method_17355(new class_3908(){

            public class_2561 method_5476() {
                return player.method_5476();
            }

            public class_1703 createMenu(int id, class_1661 playerInventory, class_1657 p) {
                return new class_1707(class_3917.field_18667, id, playerInventory, (class_1263)new OtherPlayerInventory(player), 5);
            }
        });
        return 1;
    }

    public static int nicknamefor(class_2168 source, class_3222 player, String nick) {
        if (nick.length() > 30) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Nickname too long!"), false);
            return 0;
        }
        FTBEPlayerData data = FTBEPlayerData.get((class_1657)player);
        if (data == null) {
            return 0;
        }
        data.nick = nick.trim();
        data.markDirty();
        PlayerDisplayNameUtil.refreshDisplayName((class_1657)player);
        if (data.nick.isEmpty()) {
            source.method_9226((class_2561)class_2561.method_43470((String)"Nickname reset!"), true);
        } else {
            source.method_9226((class_2561)class_2561.method_43470((String)("Nickname changed to '" + data.nick + "'")), true);
        }
        data.sendTabName(source.method_9211());
        return 1;
    }

    public static int mute(class_2168 source, class_3222 player, String duration) {
        FTBEPlayerData data = FTBEPlayerData.get((class_1657)player);
        if (data == null) {
            return 0;
        }
        try {
            DurationInfo info = DurationInfo.fromString(duration);
            data.muted = true;
            FTBEWorldData.instance.setMuteTimeout(player, info.until());
            data.markDirty();
            class_5250 msg = player.method_5476().method_27661().method_27693(" has been muted by ").method_10852(source.method_9223()).method_27693(", ").method_27693(info.desc());
            CheatCommands.notifyMuting(source, (class_1657)player, (class_2561)msg);
            return 1;
        }
        catch (IllegalArgumentException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Invalid duration syntax: '" + duration + "': " + e.getMessage())));
            return 0;
        }
    }

    private static CompletableFuture<Suggestions> suggestTimeouts(SuggestionsBuilder builder) {
        return class_2172.method_9264(Stream.of("5m", "10m", "1h", "1d", "1w", "<number>[smhdw]"), (SuggestionsBuilder)builder);
    }

    public static int unmute(class_2168 source, class_3222 player) {
        FTBEPlayerData data = FTBEPlayerData.get((class_1657)player);
        if (data == null) {
            return 0;
        }
        data.muted = false;
        FTBEWorldData.instance.setMuteTimeout(player, -1L);
        data.markDirty();
        class_5250 msg = player.method_5476().method_27661().method_27693(" has been unmuted by ").method_10852(source.method_9223());
        CheatCommands.notifyMuting(source, (class_1657)player, (class_2561)msg);
        return 1;
    }

    private static void notifyMuting(class_2168 source, class_1657 target, class_2561 msg) {
        source.method_9211().method_3760().method_14571().forEach(p -> {
            if (p.method_5687(2) || p == target) {
                p.method_7353(msg, false);
            }
        });
        if (!source.method_43737()) {
            source.method_9226(msg, true);
        }
    }
}

