/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import com.mojang.authlib.GameProfile;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbessentials.FTBEssentials;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.net.UpdateTabNameMessage;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import dev.ftb.mods.ftbessentials.util.WarmupCooldownTeleporter;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class FTBEPlayerData {
    public static final Map<UUID, FTBEPlayerData> MAP = new HashMap<UUID, FTBEPlayerData>();
    public final UUID uuid;
    public String name;
    private boolean needSave;
    public boolean muted;
    public boolean fly;
    public boolean god;
    public String nick;
    public TeleportPos lastSeen;
    public final LinkedHashMap<String, TeleportPos> homes;
    public int recording;
    public final WarmupCooldownTeleporter backTeleporter;
    public final WarmupCooldownTeleporter spawnTeleporter;
    public final WarmupCooldownTeleporter warpTeleporter;
    public final WarmupCooldownTeleporter homeTeleporter;
    public final WarmupCooldownTeleporter tpaTeleporter;
    public final WarmupCooldownTeleporter rtpTeleporter;
    public final LinkedList<TeleportPos> teleportHistory;

    @Nullable
    public static FTBEPlayerData get(@Nullable GameProfile profile) {
        if (profile == null || profile.getId() == null || profile.getName() == null) {
            return null;
        }
        FTBEPlayerData data = MAP.get(profile.getId());
        if (data == null) {
            data = new FTBEPlayerData(profile.getId());
            if (profile.getName() != null && !profile.getName().isEmpty()) {
                data.name = profile.getName();
            }
            MAP.put(profile.getId(), data);
        }
        return data;
    }

    @Nullable
    public static FTBEPlayerData get(class_1657 player) {
        return PlayerHooks.isFake((class_1657)player) ? null : FTBEPlayerData.get(player.method_7334());
    }

    public static void addTeleportHistory(class_3222 player, class_5321<class_1937> dimension, class_2338 pos) {
        FTBEPlayerData data = FTBEPlayerData.get((class_1657)player);
        if (data != null) {
            data.addTeleportHistory(player, new TeleportPos(dimension, pos, Float.valueOf(player.method_36454()), Float.valueOf(player.method_36455())));
        }
    }

    public static void addTeleportHistory(class_3222 player) {
        FTBEPlayerData.addTeleportHistory(player, (class_5321<class_1937>)player.field_6002.method_27983(), player.method_24515());
    }

    public FTBEPlayerData(UUID u) {
        this.uuid = u;
        this.name = "Unknown";
        this.needSave = false;
        this.muted = false;
        this.fly = false;
        this.god = false;
        this.nick = "";
        this.lastSeen = new TeleportPos((class_5321<class_1937>)class_1937.field_25179, class_2338.field_10980);
        this.homes = new LinkedHashMap();
        this.recording = 0;
        this.backTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.BACK::getCooldown, FTBEConfig.BACK::getWarmup, true);
        this.spawnTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.SPAWN::getCooldown, FTBEConfig.SPAWN::getWarmup);
        this.warpTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.WARP::getCooldown, FTBEConfig.WARP::getWarmup);
        this.homeTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.HOME::getCooldown, FTBEConfig.HOME::getWarmup);
        this.tpaTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.TPA::getCooldown, FTBEConfig.TPA::getWarmup);
        this.rtpTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.RTP::getCooldown, FTBEConfig.RTP::getWarmup);
        this.teleportHistory = new LinkedList();
    }

    public void markDirty() {
        this.needSave = true;
    }

    public SNBTCompoundTag write() {
        SNBTCompoundTag nbt = new SNBTCompoundTag();
        nbt.method_10556("muted", this.muted);
        nbt.method_10556("fly", this.fly);
        nbt.method_10556("god", this.god);
        nbt.method_10582("nick", this.nick);
        nbt.method_10566("last_seen", (class_2520)this.lastSeen.write());
        nbt.method_10569("recording", this.recording);
        class_2499 tph = new class_2499();
        for (TeleportPos pos : this.teleportHistory) {
            tph.add((Object)pos.write());
        }
        nbt.method_10566("teleport_history", (class_2520)tph);
        SNBTCompoundTag hm = new SNBTCompoundTag();
        for (Map.Entry<String, TeleportPos> h : this.homes.entrySet()) {
            hm.method_10566(h.getKey(), (class_2520)h.getValue().write());
        }
        nbt.method_10566("homes", (class_2520)hm);
        return nbt;
    }

    public void read(class_2487 tag) {
        this.muted = tag.method_10577("muted");
        this.fly = tag.method_10577("fly");
        this.god = tag.method_10577("god");
        this.nick = tag.method_10558("nick");
        this.recording = tag.method_10550("recording");
        this.lastSeen = tag.method_10545("last_seen") ? new TeleportPos(tag.method_10562("last_seen")) : null;
        this.teleportHistory.clear();
        class_2499 th = tag.method_10554("teleport_history", 10);
        for (int i = 0; i < th.size(); ++i) {
            this.teleportHistory.add(new TeleportPos(th.method_10602(i)));
        }
        this.homes.clear();
        class_2487 h = tag.method_10562("homes");
        for (String key : h.method_10541()) {
            this.homes.put(key, new TeleportPos(h.method_10562(key)));
        }
    }

    public void addTeleportHistory(class_3222 player, TeleportPos pos) {
        this.teleportHistory.add(pos);
        while (this.teleportHistory.size() > FTBEConfig.MAX_BACK.get(player)) {
            this.teleportHistory.removeFirst();
        }
        this.markDirty();
    }

    public void popTeleportHistory() {
        if (!this.teleportHistory.isEmpty()) {
            this.teleportHistory.removeLast();
            this.markDirty();
        } else {
            FTBEssentials.LOGGER.warn("attempted to pop empty back history for {}", (Object)this.uuid);
        }
    }

    public void load() {
        SNBTCompoundTag tag = SNBT.read((Path)FTBEWorldData.instance.mkdirs("playerdata").resolve(this.uuid + ".snbt"));
        if (tag != null) {
            this.read((class_2487)tag);
        }
    }

    public void saveNow() {
        if (this.needSave && SNBT.write((Path)FTBEWorldData.instance.mkdirs("playerdata").resolve(this.uuid + ".snbt"), (class_2487)this.write())) {
            this.needSave = false;
        }
    }

    public void sendTabName(MinecraftServer server) {
        new UpdateTabNameMessage(this.uuid, this.name, this.nick, this.recording, false).sendToAll(server);
    }

    public void sendTabName(class_3222 to) {
        new UpdateTabNameMessage(this.uuid, this.name, this.nick, this.recording, false).sendTo(to);
    }
}

