/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconProperties;
import dev.ftb.mods.ftblibrary.icon.IconWithParent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;

public class PartIcon
extends IconWithParent {
    public final Icon parent;
    public int textureWidth;
    public int textureHeight;
    public int posX;
    public int posY;
    public int corner;
    public int width;
    public int height;
    private Icon all;
    private Icon middleU;
    private Icon middleD;
    private Icon middleL;
    private Icon middleR;
    private Icon cornerNN;
    private Icon cornerPN;
    private Icon cornerNP;
    private Icon cornerPP;
    private Icon center;

    public PartIcon(Icon icon, int x, int y, int w, int h, int c) {
        super(icon);
        this.parent = icon;
        this.textureWidth = 256;
        this.textureHeight = 256;
        this.posX = x;
        this.posY = y;
        this.width = w;
        this.height = h;
        this.corner = c;
        this.updateParts();
    }

    public PartIcon(Icon icon) {
        this(icon, 0, 0, 256, 256, 6);
    }

    public PartIcon setTextureSize(int w, int h) {
        this.textureWidth = w;
        this.textureHeight = h;
        return this;
    }

    private Icon get(int x, int y, int w, int h) {
        return this.parent.withUV(this.posX + x, this.posY + y, w, h, this.textureWidth, this.textureHeight);
    }

    public void updateParts() {
        int mw = this.width - this.corner * 2;
        int mh = this.height - this.corner * 2;
        this.all = this.get(0, 0, this.width, this.height);
        this.middleU = this.get(this.corner, 0, mw, this.corner);
        this.middleD = this.get(this.corner, this.height - this.corner, mw, this.corner);
        this.middleL = this.get(0, this.corner, this.corner, mh);
        this.middleR = this.get(this.width - this.corner, this.corner, this.corner, mh);
        this.cornerNN = this.get(0, 0, this.corner, this.corner);
        this.cornerPN = this.get(this.width - this.corner, 0, this.corner, this.corner);
        this.cornerNP = this.get(0, this.height - this.corner, this.corner, this.corner);
        this.cornerPP = this.get(this.width - this.corner, this.height - this.corner, this.corner, this.corner);
        this.center = this.get(this.corner, this.corner, mw, mh);
    }

    @Override
    public PartIcon copy() {
        PartIcon icon = new PartIcon(this.parent.copy());
        icon.posX = this.posX;
        icon.posY = this.posY;
        icon.width = this.width;
        icon.height = this.height;
        icon.corner = this.corner;
        icon.textureWidth = this.textureWidth;
        icon.textureHeight = this.textureHeight;
        return icon;
    }

    @Override
    protected void setProperties(IconProperties properties) {
        String[] s1;
        super.setProperties(properties);
        this.posX = properties.getInt("x", this.posX);
        this.posY = properties.getInt("y", this.posY);
        this.width = properties.getInt("width", this.height);
        this.height = properties.getInt("height", this.height);
        this.corner = properties.getInt("corner", this.corner);
        this.textureWidth = properties.getInt("texture_w", this.textureWidth);
        this.textureHeight = properties.getInt("texture_h", this.textureHeight);
        String s = properties.getString("pos", "");
        if (!s.isEmpty() && (s1 = s.split(",", 4)).length == 4) {
            this.posX = Integer.parseInt(s1[0]);
            this.posY = Integer.parseInt(s1[1]);
            this.width = Integer.parseInt(s1[2]);
            this.height = Integer.parseInt(s1[3]);
        }
        this.updateParts();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void draw(class_4587 matrixStack, int x, int y, int w, int h) {
        if (w == this.width && h == this.height) {
            this.all.draw(matrixStack, x, y, w, h);
            return;
        }
        int c = this.corner;
        int mw = w - c * 2;
        int mh = h - c * 2;
        this.middleU.draw(matrixStack, x + c, y, mw, c);
        this.middleR.draw(matrixStack, x + w - c, y + c, c, mh);
        this.middleD.draw(matrixStack, x + c, y + h - c, mw, c);
        this.middleL.draw(matrixStack, x, y + c, c, mh);
        this.cornerNN.draw(matrixStack, x, y, c, c);
        this.cornerNP.draw(matrixStack, x, y + h - c, c, c);
        this.cornerPN.draw(matrixStack, x + w - c, y, c, c);
        this.cornerPP.draw(matrixStack, x + w - c, y + h - c, c, c);
        this.center.draw(matrixStack, x + c, y + c, mw, mh);
    }

    @Override
    public JsonElement getJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", "part");
        json.add("parent", this.parent.getJson());
        json.addProperty("x", (Number)this.posX);
        json.addProperty("y", (Number)this.posY);
        json.addProperty("width", (Number)this.width);
        json.addProperty("height", (Number)this.height);
        json.addProperty("corner", (Number)this.corner);
        json.addProperty("texture_width", (Number)this.textureWidth);
        json.addProperty("texture_height", (Number)this.textureHeight);
        return json;
    }
}

