/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import dev.architectury.event.EventActor;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientChatEvent;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_407;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class ClientUtils {
    public static final BooleanSupplier IS_CLIENT_OP = () -> class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_5687(1);
    public static final List<Runnable> RUN_LATER = new ArrayList<Runnable>();
    private static final MethodType EMPTY_METHOD_TYPE = MethodType.methodType(Void.TYPE);
    private static final HashMap<String, Optional<MethodHandle>> staticMethodCache = new HashMap();

    public static void execClientCommand(String command, boolean printChat) {
        EventResult res;
        if (!command.isEmpty() && class_310.method_1551().field_1724 != null && !(res = ((ClientChatEvent.Send)ClientChatEvent.SEND.invoker()).send(command, null)).interruptsFurtherEvaluation()) {
            if (printChat) {
                class_310.method_1551().field_1705.method_1743().method_1803(command);
            }
            class_310.method_1551().field_1724.method_44098(command.replace("/", ""), null);
        }
    }

    public static void runLater(Runnable runnable) {
        RUN_LATER.add(runnable);
    }

    @Nullable
    public static <T> T getGuiAs(class_437 gui, Class<T> clazz) {
        BaseScreen guiBase;
        if (gui instanceof IScreenWrapper && clazz.isAssignableFrom((guiBase = ((IScreenWrapper)gui).getGui()).getClass())) {
            return (T)guiBase;
        }
        return (T)(clazz.isAssignableFrom(gui.getClass()) ? class_310.method_1551().field_1755 : null);
    }

    @Nullable
    public static <T> T getCurrentGuiAs(Class<T> clazz) {
        return class_310.method_1551().field_1755 == null ? null : (T)ClientUtils.getGuiAs(class_310.method_1551().field_1755, clazz);
    }

    public static boolean handleClick(String scheme, String path) {
        switch (scheme) {
            case "http": 
            case "https": {
                try {
                    URI uri = new URI(scheme + ":" + path);
                    if (((Boolean)class_310.method_1551().field_1690.method_42431().method_41753()).booleanValue()) {
                        class_437 currentScreen = class_310.method_1551().field_1755;
                        class_310.method_1551().method_1507((class_437)new class_407(result -> {
                            if (result) {
                                try {
                                    class_156.method_668().method_673(uri);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            class_310.method_1551().method_1507(currentScreen);
                        }, scheme + ":" + path, false));
                    } else {
                        class_156.method_668().method_673(uri);
                    }
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            case "file": {
                try {
                    class_156.method_668().method_673(new URI("file:" + path));
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            case "command": {
                ClientUtils.execClientCommand(path, false);
                return true;
            }
            case "static_method": {
                Optional<MethodHandle> handle = staticMethodCache.get(path);
                if (handle == null) {
                    handle = Optional.empty();
                    String[] s = path.split(":", 2);
                    try {
                        Class<?> c = Class.forName(s[0]);
                        MethodHandle h = MethodHandles.publicLookup().findStatic(c, s[1], EMPTY_METHOD_TYPE);
                        handle = Optional.ofNullable(h);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                    staticMethodCache.put(path, handle);
                }
                if (handle.isPresent()) {
                    try {
                        handle.get().invoke();
                        return true;
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                return false;
            }
            case "custom": {
                if (!class_2960.method_20207((String)path)) break;
                return ((EventActor)CustomClickEvent.EVENT.invoker()).act((Object)new CustomClickEvent(new class_2960(path))).isPresent();
            }
        }
        if (class_2960.method_20207((String)(scheme + ":" + path))) {
            return ((EventActor)CustomClickEvent.EVENT.invoker()).act((Object)new CustomClickEvent(new class_2960(scheme, path))).isPresent();
        }
        FTBLibrary.LOGGER.warn("invalid scheme/path resourcelocation for handleClick(): {}:{}", (Object)scheme, (Object)path);
        return false;
    }
}

