/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamBase;
import dev.ftb.mods.ftbteams.data.TeamMessage;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_2540;

public class ClientTeam
extends TeamBase {
    private static List<TeamProperty> SYNCABLE_PROPS = List.of(DISPLAY_NAME, COLOR);
    public final ClientTeamManager manager;
    public boolean invalid;
    TeamType type;
    private final UUID ownerID;

    public static ClientTeam invalidTeam(ClientTeamManager m, Team team) {
        return new ClientTeam(m, team.getId());
    }

    private ClientTeam(ClientTeamManager m, UUID id) {
        this.id = id;
        this.manager = m;
        this.ownerID = class_156.field_25140;
        this.invalid = true;
        this.type = TeamType.PARTY;
    }

    public ClientTeam(ClientTeamManager m, class_2540 buffer) {
        this.manager = m;
        this.id = buffer.method_10790();
        this.type = (TeamType)buffer.method_10818(TeamType.class);
        this.properties.read(buffer);
        int rs = buffer.method_10816();
        for (int i = 0; i < rs; ++i) {
            this.ranks.put(buffer.method_10790(), (TeamRank)buffer.method_10818(TeamRank.class));
        }
        this.extraData = buffer.method_10798();
        this.ownerID = buffer.readBoolean() ? buffer.method_10790() : class_156.field_25140;
        this.invalid = buffer.readBoolean();
    }

    public ClientTeam(ClientTeamManager m, Team team) {
        this.manager = m;
        this.id = team.getId();
        this.type = team.getType();
        this.properties.updateFrom(team.properties);
        this.ranks.putAll(team.ranks);
        this.extraData = team.extraData == null ? null : team.extraData.method_10553();
        this.ownerID = team.getOwner();
    }

    @Override
    public TeamType getType() {
        return this.type;
    }

    @Override
    public boolean isValid() {
        return this.manager.teamMap.containsKey(this.id);
    }

    public void write(class_2540 buffer, boolean writeAllProperties) {
        buffer.method_10797(this.id);
        buffer.method_10817((Enum)this.type);
        if (writeAllProperties) {
            this.properties.write(buffer);
        } else {
            this.properties.writeSyncableOnly(buffer, SYNCABLE_PROPS);
        }
        buffer.method_10804(this.ranks.size());
        for (Map.Entry entry : this.ranks.entrySet()) {
            buffer.method_10797((UUID)entry.getKey());
            buffer.method_10817((Enum)entry.getValue());
        }
        buffer.method_10794(this.extraData);
        boolean hasOwner = !this.ownerID.equals(class_156.field_25140);
        buffer.writeBoolean(hasOwner);
        if (hasOwner) {
            buffer.method_10797(this.ownerID);
        }
        buffer.writeBoolean(this.invalid);
    }

    public boolean isSelf() {
        return this == this.manager.selfTeam;
    }

    public UUID getOwnerID() {
        return this.ownerID;
    }

    public void setMessageHistory(List<TeamMessage> messages) {
        this.messageHistory.clear();
        this.messageHistory.addAll(messages);
    }
}

