/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class ClientTeamManager {
    public static ClientTeamManager INSTANCE;
    private final UUID managerId;
    private boolean invalid;
    public final Map<UUID, ClientTeam> teamMap;
    public final Map<UUID, KnownClientPlayer> knownPlayers;
    public ClientTeam selfTeam;
    public KnownClientPlayer selfKnownPlayer;

    public ClientTeamManager(UUID managerId) {
        this.managerId = managerId;
        this.invalid = false;
        this.teamMap = new HashMap<UUID, ClientTeam>();
        this.knownPlayers = new HashMap<UUID, KnownClientPlayer>();
    }

    public ClientTeamManager(class_2540 buffer) {
        this(buffer.method_10790());
        int nTeams = buffer.method_10816();
        for (int i = 0; i < nTeams; ++i) {
            ClientTeam t = new ClientTeam(this, buffer);
            this.teamMap.put(t.getId(), t);
        }
        int nPlayers = buffer.method_10816();
        for (int i = 0; i < nPlayers; ++i) {
            KnownClientPlayer knownClientPlayer = new KnownClientPlayer(buffer);
            this.knownPlayers.put(knownClientPlayer.uuid, knownClientPlayer);
        }
    }

    public UUID getManagerId() {
        return this.managerId;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void write(class_2540 buffer, UUID selfTeamID) {
        buffer.method_10797(this.getManagerId());
        buffer.method_10804(this.teamMap.size());
        this.teamMap.values().forEach(clientTeam -> clientTeam.write(buffer, selfTeamID.equals(clientTeam.getId())));
        buffer.method_10804(this.knownPlayers.size());
        for (KnownClientPlayer knownClientPlayer : this.knownPlayers.values()) {
            knownClientPlayer.write(buffer);
        }
    }

    public void initSelfDetails(UUID selfTeamID) {
        this.selfTeam = this.teamMap.get(selfTeamID);
        UUID userId = class_310.method_1551().method_1548().method_1677().getId();
        this.selfKnownPlayer = this.knownPlayers.get(userId);
        if (this.selfKnownPlayer == null) {
            FTBTeams.LOGGER.warn("Local player id {} was not found in the known players list [{}]! FTB Teams will not be able to function correctly!", (Object)userId, (Object)String.join((CharSequence)",", this.knownPlayers.keySet().stream().map(UUID::toString).toList()));
        }
    }

    @Nullable
    public KnownClientPlayer getKnownPlayer(UUID id) {
        return this.knownPlayers.get(id);
    }

    @Nullable
    public ClientTeam getTeam(UUID id) {
        return this.teamMap.get(id);
    }

    public class_2561 getName(@Nullable UUID id) {
        if (id == null || id.equals(class_156.field_25140)) {
            return class_2561.method_43470((String)"System").method_27692(class_124.field_1076);
        }
        KnownClientPlayer p = this.knownPlayers.get(id);
        return class_2561.method_43470((String)(p == null ? "Unknown" : p.name)).method_27692(class_124.field_1054);
    }

    public void invalidate() {
        this.teamMap.values().forEach(team -> {
            team.invalid = true;
        });
        this.invalid = true;
    }

    public static void syncFromServer(ClientTeamManager syncedData, UUID selfTeamID, boolean fullSync) {
        if (fullSync) {
            syncedData.initSelfDetails(selfTeamID);
            if (INSTANCE != null) {
                INSTANCE.invalidate();
            }
            INSTANCE = syncedData;
        } else if (INSTANCE != null) {
            syncedData.teamMap.forEach((teamID, clientTeam) -> {
                if (clientTeam.invalid) {
                    FTBTeams.LOGGER.debug("remove {} from client team map", teamID);
                    ClientTeamManager.INSTANCE.teamMap.remove(teamID);
                } else {
                    ClientTeam existing = ClientTeamManager.INSTANCE.teamMap.get(teamID);
                    if (existing != null) {
                        FTBTeams.LOGGER.debug("update {} in client team map", teamID);
                    } else {
                        FTBTeams.LOGGER.debug("insert {} into client team map", teamID);
                    }
                    ClientTeamManager.INSTANCE.teamMap.put((UUID)teamID, (ClientTeam)clientTeam);
                }
            });
            ClientTeamManager.INSTANCE.knownPlayers.putAll(syncedData.knownPlayers);
            INSTANCE.initSelfDetails(selfTeamID);
        }
    }
}

