/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbxmodcompat.ftbchunks.ftbranks;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.integration.PermissionsHelper;
import dev.ftb.mods.ftbranks.api.RankManager;
import dev.ftb.mods.ftbranks.api.event.ConditionChangedEvent;
import dev.ftb.mods.ftbranks.api.event.PermissionNodeChangedEvent;
import dev.ftb.mods.ftbranks.api.event.PlayerAddedToRankEvent;
import dev.ftb.mods.ftbranks.api.event.PlayerRemovedFromRankEvent;
import dev.ftb.mods.ftbranks.api.event.RankEvent;
import dev.ftb.mods.ftbranks.api.event.RanksReloadedEvent;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbxmodcompat.FTBXModCompat;
import java.util.UUID;
import net.minecraft.class_3222;

public class FTBRanksEventHandler {
    public static void registerEvents() {
        RankEvent.ADD_PLAYER.register(FTBRanksEventHandler::playerAdded);
        RankEvent.REMOVE_PLAYER.register(FTBRanksEventHandler::playerRemoved);
        RankEvent.PERMISSION_CHANGED.register(FTBRanksEventHandler::permissionSet);
        RankEvent.RELOADED.register(FTBRanksEventHandler::ranksReloaded);
        RankEvent.CONDITION_CHANGED.register(FTBRanksEventHandler::conditionChanged);
        FTBXModCompat.LOGGER.info("[FTB Chunks] FTB Ranks detected, listening for ranks events");
    }

    private static void playerAdded(PlayerAddedToRankEvent event) {
        FTBRanksEventHandler.updateForPlayer(event.getManager(), event.getPlayer());
    }

    private static void playerRemoved(PlayerRemovedFromRankEvent event) {
        FTBRanksEventHandler.updateForPlayer(event.getManager(), event.getPlayer());
    }

    private static void permissionSet(PermissionNodeChangedEvent event) {
        String node = event.getNode();
        if (node.equals("ftbchunks.max_claimed") || node.equals("ftbchunks.max_force_loaded") || node.equals("ftbchunks.chunk_load_offline")) {
            FTBRanksEventHandler.updateAll(event.getManager());
        }
    }

    private static void ranksReloaded(RanksReloadedEvent event) {
        FTBRanksEventHandler.updateAll(event.getManager());
    }

    private static void conditionChanged(ConditionChangedEvent event) {
        FTBRanksEventHandler.updateAll(event.getManager());
    }

    private static void updateAll(RankManager manager) {
        if (FTBChunksAPI.isManagerLoaded()) {
            manager.getServer().method_3760().method_14571().forEach(player -> {
                FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
                data.setForceLoadMember(player.method_5667(), PermissionsHelper.getChunkLoadOffline((class_3222)player, (boolean)false));
            });
            FTBTeamsAPI.getManager().getTeams().forEach(team -> FTBChunksAPI.getManager().getData(team).updateLimits());
        }
    }

    private static void updateForPlayer(RankManager manager, GameProfile profile) {
        Team team = FTBTeamsAPI.getPlayerTeam((UUID)profile.getId());
        if (team != null) {
            FTBChunksTeamData teamData = FTBChunksAPI.getManager().getData(team);
            class_3222 player = manager.getServer().method_3760().method_14602(profile.getId());
            if (player != null) {
                teamData.setForceLoadMember(player.method_5667(), PermissionsHelper.getChunkLoadOffline((class_3222)player, (boolean)false));
            }
            teamData.updateLimits();
        }
    }
}

