/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.lib;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import net.creeperhost.levelio.lib.ChunkPos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCAFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(MCAFile.class);
    public final FileChannel dataChannel;
    public final ByteBuffer posBuffer;
    public final IntBuffer chunkPositions;
    public final ByteBuffer timeBuffer;
    public final IntBuffer timeStamps;

    public MCAFile(Path file, boolean readOnly) throws IOException {
        if (Files.size(file) < 8192L) {
            throw new IllegalArgumentException("mca file size must be at least 4kiB, is this region corrupt? " + file);
        }
        this.dataChannel = readOnly ? FileChannel.open(file, StandardOpenOption.READ) : FileChannel.open(file, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.posBuffer = ByteBuffer.allocate(4096);
        this.timeBuffer = ByteBuffer.allocate(4096);
        this.dataChannel.read(this.posBuffer);
        this.posBuffer.flip();
        this.chunkPositions = this.posBuffer.asIntBuffer();
        this.dataChannel.read(this.timeBuffer);
        this.timeBuffer.flip();
        this.timeStamps = this.timeBuffer.asIntBuffer();
    }

    public Map<ChunkPos, Long> getPopulatedChunks(ChunkPos regionPos) {
        HashMap<ChunkPos, Long> map = new HashMap<ChunkPos, Long>();
        for (int index = 0; index < 1024; ++index) {
            int data = this.chunkPositions.get(index);
            if (data == 0) continue;
            int x = (index & 0x1F) + (regionPos.x << 5);
            int z = (index >> 5) + (regionPos.z << 5);
            long timestamp = this.timeStamps.get(index);
            map.put(new ChunkPos(x, z), timestamp);
        }
        return map;
    }

    public boolean hasChunk(ChunkPos pos) {
        int index = pos.getRegionChunkIndex();
        int chunkDataPos = this.chunkPositions.get(index) >>> 8;
        return chunkDataPos > 0;
    }

    public int getChunkModifiedTime(ChunkPos pos) {
        int index = pos.getRegionChunkIndex();
        return this.timeStamps.get(index);
    }

    public ByteBuffer getChunkBuffer(ChunkPos pos) throws IOException {
        int index = pos.getRegionChunkIndex();
        int chunkDataPos = this.chunkPositions.get(index) >>> 8;
        int chunkDataLen = this.chunkPositions.get(index) & 0xFF;
        ByteBuffer buffer = ByteBuffer.allocate(4096 * chunkDataLen);
        this.dataChannel.read(buffer, 4096L * (long)chunkDataPos);
        buffer.flip();
        return buffer;
    }

    public void close() {
        try {
            this.dataChannel.close();
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while closing mca file", (Throwable)e);
        }
    }
}

