/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.geocluster.api.deposits;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.sterner.geocluster.Geocluster;
import dev.sterner.geocluster.GeoclusterConfig;
import dev.sterner.geocluster.api.DepositUtils;
import dev.sterner.geocluster.api.IDeposit;
import dev.sterner.geocluster.api.deposits.Deposit;
import dev.sterner.geocluster.common.components.IWorldChunkComponent;
import dev.sterner.geocluster.common.components.IWorldDepositComponent;
import dev.sterner.geocluster.common.utils.FeatureUtils;
import dev.sterner.geocluster.common.utils.GeoclusterUtils;
import dev.sterner.geocluster.common.utils.SerializerUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class DikeDeposit
extends Deposit
implements IDeposit {
    public static final String JSON_TYPE = "geocluster:deposit_dike";
    public final HashMap<String, HashMap<class_2680, Float>> oreToWeightMap;
    public final HashMap<class_2680, Float> sampleToWeightMap;
    public final HashMap<String, Float> cumulativeOreWeightMap = new HashMap();
    public float sumWeightSamples = 0.0f;
    private final int yMin;
    private final int yMax;
    private final int maxHeight;
    private final int baseRadius;
    private final int weight;
    private final HashSet<class_2680> blockStateMatchers;
    private final class_6862<class_1959> biomeTag;

    public DikeDeposit(HashMap<String, HashMap<class_2680, Float>> oreBlocks, HashMap<class_2680, Float> sampleBlocks, int yMin, int yMax, int baseRadius, int maxHeight, int weight, class_6862<class_1959> biomeTag, HashSet<class_2680> blockStateMatchers) {
        this.oreToWeightMap = oreBlocks;
        this.sampleToWeightMap = sampleBlocks;
        this.yMin = yMin;
        this.yMax = yMax;
        this.maxHeight = maxHeight;
        this.baseRadius = baseRadius;
        this.weight = weight;
        this.biomeTag = biomeTag;
        this.blockStateMatchers = blockStateMatchers;
        DikeDeposit.validateFormat(this.oreToWeightMap, this.cumulativeOreWeightMap, this.sampleToWeightMap, this.sumWeightSamples);
    }

    @Nullable
    public class_2680 getOre(class_2680 currentState, class_5819 rand) {
        String res = GeoclusterUtils.getRegistryName(currentState);
        if (this.oreToWeightMap.containsKey(res)) {
            HashMap<class_2680, Float> mp = this.oreToWeightMap.get(res);
            return DepositUtils.pick(mp, rand);
        }
        return DepositUtils.pick(this.oreToWeightMap.get("default"), rand);
    }

    @Nullable
    public class_2680 getSample(class_5819 rand) {
        return DepositUtils.pick(this.sampleToWeightMap, rand);
    }

    @Override
    @Nullable
    public HashSet<class_2680> getAllOres() {
        HashSet<class_2680> ret = new HashSet<class_2680>();
        this.oreToWeightMap.values().forEach(x -> ret.addAll(x.keySet()));
        ret.remove(class_2246.field_10124.method_9564());
        return ret.isEmpty() ? null : ret;
    }

    @Override
    public boolean canPlaceInBiome(class_6880<class_1959> b) {
        return b.method_40220(this.biomeTag);
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public String toString() {
        return "Dike deposit with Blocks=" + this.getAllOres() + ", Samples=" + Arrays.toString(this.sampleToWeightMap.keySet().toArray()) + ", Y Range=[" + this.yMin + "," + this.yMax + "], Radius of Base=" + this.baseRadius;
    }

    @Override
    public int generate(class_5281 world, class_2338 pos, IWorldDepositComponent deposits, IWorldChunkComponent chunksGenerated) {
        if (!this.canPlaceInBiome((class_6880<class_1959>)world.method_23753(pos))) {
            return 0;
        }
        class_1923 thisChunk = new class_1923(pos);
        int height = Math.abs(this.yMax - this.yMin);
        int x = thisChunk.method_8326() + world.method_8409().method_43048(16);
        int z = thisChunk.method_8328() + world.method_8409().method_43048(16);
        int yMin = this.yMin + world.method_8409().method_43048(height / 4);
        int yMax = this.yMax - world.method_8409().method_43048(height / 4);
        int cmaxHeight = this.maxHeight - world.method_8409().method_39332(0, this.maxHeight / 4);
        int maxStart = class_3532.method_15382((int)(yMax - cmaxHeight - yMin));
        yMin = world.method_8409().method_43048(maxStart + 1) + yMin;
        yMax = yMin + cmaxHeight;
        class_2338 basePos = new class_2338(x, yMin, z);
        int totlPlaced = 0;
        int htRnd = Math.abs(yMax - yMin);
        int rad = this.baseRadius / 2;
        boolean shouldSub = false;
        for (int dY = yMin; dY <= yMax; ++dY) {
            for (int dX = -rad; dX <= rad; ++dX) {
                for (int dZ = -rad; dZ <= rad; ++dZ) {
                    class_2338 placePos;
                    class_2680 current;
                    class_2680 tmp;
                    float dist = dX * dX + dZ * dZ;
                    if (dist > (float)rad || (tmp = this.getOre(current = world.method_8320(placePos = new class_2338(basePos.method_10263() + dX, dY, basePos.method_10260() + dZ)), world.method_8409())) == null || !this.getBlockStateMatchers().contains(current) && !this.oreToWeightMap.containsKey(GeoclusterUtils.getRegistryName(current)) || !FeatureUtils.enqueueBlockPlacement(world, placePos, tmp, deposits, chunksGenerated)) continue;
                    ++totlPlaced;
                }
            }
            if (yMin + htRnd / 2 <= dY) {
                shouldSub = true;
            }
            if (world.method_8409().method_43048(3) != 0 || (rad += shouldSub ? -1 : 1) > 0) continue;
            return totlPlaced;
        }
        return totlPlaced;
    }

    @Override
    public void generatePost(class_5281 world, class_2338 pos, IWorldDepositComponent deposits, IWorldChunkComponent chunksGenerated) {
        if (GeoclusterConfig.DEBUG_WORLD_GEN) {
            Geocluster.LOGGER.info("Generated {} in Chunk {} (Pos [{} {} {}])", new Object[]{this, new class_1923(pos), pos.method_10263(), pos.method_10264(), pos.method_10260()});
        }
        int maxSampleCnt = Math.min(GeoclusterConfig.MAX_SAMPLES_PER_CHUNK, this.baseRadius / GeoclusterConfig.MAX_SAMPLES_PER_CHUNK + this.baseRadius % GeoclusterConfig.MAX_SAMPLES_PER_CHUNK);
        Deposit.findAndPlaceSample(maxSampleCnt, this.getSample(world.method_8409()), world, pos, deposits, chunksGenerated);
    }

    @Override
    public HashSet<class_2680> getBlockStateMatchers() {
        return this.blockStateMatchers == null ? DepositUtils.getDefaultMatchers() : this.blockStateMatchers;
    }

    public static DikeDeposit deserialize(JsonObject json) {
        if (json == null) {
            return null;
        }
        try {
            HashMap<String, HashMap<class_2680, Float>> oreBlocks = SerializerUtils.buildMultiBlockMatcherMap(json.get("blocks").getAsJsonObject());
            HashMap<class_2680, Float> sampleBlocks = SerializerUtils.buildMultiBlockMap(json.get("samples").getAsJsonArray());
            int yMin = json.get("yMin").getAsInt();
            int yMax = json.get("yMax").getAsInt();
            int baseRadius = json.get("baseRadius").getAsInt();
            int maxHeight = json.get("maxHeight").getAsInt();
            int genWt = json.get("generationWeight").getAsInt();
            class_6862 biomeTag = class_6862.method_40092((class_5321)class_2378.field_25114, (class_2960)new class_2960(json.get("biomeTag").getAsString().replace("#", "")));
            HashSet<class_2680> blockStateMatchers = DepositUtils.getDefaultMatchers();
            if (json.has("blockStateMatchers")) {
                blockStateMatchers = SerializerUtils.toBlockStateList(json.get("blockStateMatchers").getAsJsonArray());
            }
            return new DikeDeposit(oreBlocks, sampleBlocks, yMin, yMax, baseRadius, maxHeight, genWt, (class_6862<class_1959>)biomeTag, blockStateMatchers);
        }
        catch (Exception e) {
            Geocluster.LOGGER.error("Failed to parse: {}", (Object)e.getMessage());
            return null;
        }
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        JsonObject config = new JsonObject();
        config.add("blocks", (JsonElement)SerializerUtils.deconstructMultiBlockMatcherMap(this.oreToWeightMap));
        config.add("samples", (JsonElement)SerializerUtils.deconstructMultiBlockMap(this.sampleToWeightMap));
        config.addProperty("yMin", (Number)this.yMin);
        config.addProperty("yMax", (Number)this.yMax);
        config.addProperty("baseRadius", (Number)this.baseRadius);
        config.addProperty("maxHeight", (Number)this.maxHeight);
        config.addProperty("generationWeight", (Number)this.getWeight());
        config.addProperty("biomeTag", this.biomeTag.comp_327().toString());
        json.addProperty("type", JSON_TYPE);
        json.add("config", (JsonElement)config);
        return json;
    }
}

