/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.geocluster.api.deposits;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.sterner.geocluster.Geocluster;
import dev.sterner.geocluster.GeoclusterConfig;
import dev.sterner.geocluster.api.DepositUtils;
import dev.sterner.geocluster.api.IDeposit;
import dev.sterner.geocluster.api.deposits.Deposit;
import dev.sterner.geocluster.common.components.IWorldChunkComponent;
import dev.sterner.geocluster.common.components.IWorldDepositComponent;
import dev.sterner.geocluster.common.utils.FeatureUtils;
import dev.sterner.geocluster.common.utils.GeoclusterUtils;
import dev.sterner.geocluster.common.utils.SerializerUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class LayerDeposit
extends Deposit
implements IDeposit {
    public static final String JSON_TYPE = "geocluster:deposit_layer";
    public final HashMap<String, HashMap<class_2680, Float>> oreToWeightMap;
    public final HashMap<class_2680, Float> sampleToWeightMap;
    public final HashMap<String, Float> cumulativeOreWeightMap = new HashMap();
    public float sumWeightSamples = 0.0f;
    private final int yMin;
    private final int yMax;
    private final int radius;
    private final int depth;
    private final int weight;
    private final HashSet<class_2680> blockStateMatchers;
    private final class_6862<class_1959> biomeTag;

    public LayerDeposit(HashMap<String, HashMap<class_2680, Float>> oreBlocks, HashMap<class_2680, Float> sampleBlocks, int yMin, int yMax, int radius, int depth, int weight, class_6862<class_1959> biomeTag, HashSet<class_2680> blockStateMatchers) {
        this.oreToWeightMap = oreBlocks;
        this.sampleToWeightMap = sampleBlocks;
        this.yMin = yMin;
        this.yMax = yMax;
        this.radius = radius;
        this.depth = depth;
        this.weight = weight;
        this.biomeTag = biomeTag;
        this.blockStateMatchers = blockStateMatchers;
        LayerDeposit.validateFormat(this.oreToWeightMap, this.cumulativeOreWeightMap, this.sampleToWeightMap, this.sumWeightSamples);
    }

    @Nullable
    public class_2680 getOre(class_2680 currentState, class_5819 rand) {
        String res = GeoclusterUtils.getRegistryName(currentState);
        if (this.oreToWeightMap.containsKey(res)) {
            HashMap<class_2680, Float> mp = this.oreToWeightMap.get(res);
            return DepositUtils.pick(mp, rand);
        }
        return DepositUtils.pick(this.oreToWeightMap.get("default"), rand);
    }

    @Nullable
    public class_2680 getSample(class_5819 rand) {
        return DepositUtils.pick(this.sampleToWeightMap, rand);
    }

    @Override
    @Nullable
    public HashSet<class_2680> getAllOres() {
        HashSet<class_2680> ret = new HashSet<class_2680>();
        this.oreToWeightMap.values().forEach(x -> ret.addAll(x.keySet()));
        ret.remove(class_2246.field_10124.method_9564());
        return ret.isEmpty() ? null : ret;
    }

    @Override
    public boolean canPlaceInBiome(class_6880<class_1959> b) {
        return b.method_40220(this.biomeTag);
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public String toString() {
        return "Layer deposit with Blocks=" + this.getAllOres() + ", Samples=" + Arrays.toString(this.sampleToWeightMap.keySet().toArray()) + ", Y Range=[" + this.yMin + "," + this.yMax + "], Radius=" + this.radius + ", Depth=" + this.depth;
    }

    @Override
    public int generate(class_5281 world, class_2338 pos, IWorldDepositComponent deposits, IWorldChunkComponent chunksGenerated) {
        if (!this.canPlaceInBiome((class_6880<class_1959>)world.method_23753(pos))) {
            return 0;
        }
        int totlPlaced = 0;
        class_1923 thisChunk = new class_1923(pos);
        int x = (thisChunk.method_8326() + thisChunk.method_8327()) / 2 - world.method_8409().method_43048(8) + world.method_8409().method_43048(16);
        int y = this.yMin + world.method_8409().method_43048(Math.abs(this.yMax - this.yMin));
        int z = (thisChunk.method_8328() + thisChunk.method_8329()) / 2 - world.method_8409().method_43048(8) + world.method_8409().method_43048(16);
        int max = GeoclusterUtils.getTopSolidBlock((class_4538)world, pos).method_10264();
        if (y > max) {
            y = Math.max(this.yMin, max);
        }
        class_2338 basePos = new class_2338(x, y, z);
        for (int dX = -this.radius; dX <= this.radius; ++dX) {
            for (int dZ = -this.radius; dZ <= this.radius; ++dZ) {
                for (int dY = 0; dY < this.depth; ++dY) {
                    class_2338 placePos;
                    class_2680 current;
                    class_2680 tmp;
                    float dist = dX * dX + dZ * dZ;
                    if (dist > (float)(this.radius * 2) || (tmp = this.getOre(current = world.method_8320(placePos = basePos.method_10069(dX, dY, dZ)), world.method_8409())) == null || !this.getBlockStateMatchers().contains(current) && !this.oreToWeightMap.containsKey(GeoclusterUtils.getRegistryName(current)) || !FeatureUtils.enqueueBlockPlacement(world, placePos, tmp, deposits, chunksGenerated)) continue;
                    ++totlPlaced;
                }
            }
        }
        return totlPlaced;
    }

    @Override
    public void generatePost(class_5281 world, class_2338 pos, IWorldDepositComponent deposits, IWorldChunkComponent chunksGenerated) {
        if (GeoclusterConfig.DEBUG_WORLD_GEN) {
            Geocluster.LOGGER.info("Generated {} in Chunk {} (Pos [{} {} {}])", new Object[]{this, new class_1923(pos), pos.method_10263(), pos.method_10264(), pos.method_10260()});
        }
        int maxSampleCnt = Math.min(GeoclusterConfig.MAX_SAMPLES_PER_CHUNK, this.radius / GeoclusterConfig.MAX_SAMPLES_PER_CHUNK + this.radius % GeoclusterConfig.MAX_SAMPLES_PER_CHUNK);
        Deposit.findAndPlaceSample(maxSampleCnt, this.getSample(world.method_8409()), world, pos, deposits, chunksGenerated);
    }

    @Override
    public HashSet<class_2680> getBlockStateMatchers() {
        return this.blockStateMatchers == null ? DepositUtils.getDefaultMatchers() : this.blockStateMatchers;
    }

    public static LayerDeposit deserialize(JsonObject json) {
        if (json == null) {
            return null;
        }
        try {
            HashMap<String, HashMap<class_2680, Float>> oreBlocks = SerializerUtils.buildMultiBlockMatcherMap(json.get("blocks").getAsJsonObject());
            HashMap<class_2680, Float> sampleBlocks = SerializerUtils.buildMultiBlockMap(json.get("samples").getAsJsonArray());
            int yMin = json.get("yMin").getAsInt();
            int yMax = json.get("yMax").getAsInt();
            int radius = json.get("radius").getAsInt();
            int depth = json.get("depth").getAsInt();
            int genWt = json.get("generationWeight").getAsInt();
            class_6862 biomeTag = class_6862.method_40092((class_5321)class_2378.field_25114, (class_2960)new class_2960(json.get("biomeTag").getAsString().replace("#", "")));
            HashSet<class_2680> blockStateMatchers = DepositUtils.getDefaultMatchers();
            if (json.has("blockStateMatchers")) {
                blockStateMatchers = SerializerUtils.toBlockStateList(json.get("blockStateMatchers").getAsJsonArray());
            }
            return new LayerDeposit(oreBlocks, sampleBlocks, yMin, yMax, radius, depth, genWt, (class_6862<class_1959>)biomeTag, blockStateMatchers);
        }
        catch (Exception e) {
            Geocluster.LOGGER.error("Failed to parse: {}", (Object)e.getMessage());
            return null;
        }
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        JsonObject config = new JsonObject();
        config.add("blocks", (JsonElement)SerializerUtils.deconstructMultiBlockMatcherMap(this.oreToWeightMap));
        config.add("samples", (JsonElement)SerializerUtils.deconstructMultiBlockMap(this.sampleToWeightMap));
        config.addProperty("yMin", (Number)this.yMin);
        config.addProperty("yMax", (Number)this.yMax);
        config.addProperty("radius", (Number)this.radius);
        config.addProperty("depth", (Number)this.depth);
        config.addProperty("generationWeight", (Number)this.getWeight());
        config.addProperty("biomeTag", this.biomeTag.comp_327().toString());
        json.addProperty("type", JSON_TYPE);
        json.add("config", (JsonElement)config);
        return json;
    }
}

