/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.geocluster.api.deposits;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.sterner.geocluster.Geocluster;
import dev.sterner.geocluster.GeoclusterConfig;
import dev.sterner.geocluster.api.DepositUtils;
import dev.sterner.geocluster.api.IDeposit;
import dev.sterner.geocluster.api.deposits.Deposit;
import dev.sterner.geocluster.common.components.IWorldChunkComponent;
import dev.sterner.geocluster.common.components.IWorldDepositComponent;
import dev.sterner.geocluster.common.utils.FeatureUtils;
import dev.sterner.geocluster.common.utils.GeoclusterUtils;
import dev.sterner.geocluster.common.utils.SerializerUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class TopLayerDeposit
extends Deposit
implements IDeposit {
    public static final String JSON_TYPE = "geocluster:deposit_top_layer";
    public final HashMap<String, HashMap<class_2680, Float>> oreToWeightMap;
    public final HashMap<class_2680, Float> sampleToWeightMap;
    public final HashMap<String, Float> cumulativeOreWeightMap = new HashMap();
    public float sumWeightSamples = 0.0f;
    private final int radius;
    private final int depth;
    private final float sampleChance;
    private final int weight;
    private final HashSet<class_2680> blockStateMatchers;
    private final class_6862<class_1959> biomeTag;

    public TopLayerDeposit(HashMap<String, HashMap<class_2680, Float>> oreBlocks, HashMap<class_2680, Float> sampleBlocks, int radius, int depth, float sampleChance, int weight, class_6862<class_1959> biomeTag, HashSet<class_2680> blockStateMatchers) {
        this.oreToWeightMap = oreBlocks;
        this.sampleToWeightMap = sampleBlocks;
        this.radius = radius;
        this.depth = depth;
        this.sampleChance = sampleChance;
        this.weight = weight;
        this.biomeTag = biomeTag;
        this.blockStateMatchers = blockStateMatchers;
        TopLayerDeposit.validateFormat(this.oreToWeightMap, this.cumulativeOreWeightMap, this.sampleToWeightMap, this.sumWeightSamples);
    }

    @Nullable
    public class_2680 getOre(class_2680 currentState, class_5819 rand) {
        String res = GeoclusterUtils.getRegistryName(currentState);
        if (this.oreToWeightMap.containsKey(res)) {
            HashMap<class_2680, Float> mp = this.oreToWeightMap.get(res);
            return DepositUtils.pick(mp, rand);
        }
        return DepositUtils.pick(this.oreToWeightMap.get("default"), rand);
    }

    @Nullable
    public class_2680 getSample(class_5819 rand) {
        return DepositUtils.pick(this.sampleToWeightMap, rand);
    }

    @Override
    @Nullable
    public HashSet<class_2680> getAllOres() {
        return null;
    }

    @Override
    public boolean canPlaceInBiome(class_6880<class_1959> b) {
        return b.method_40220(this.biomeTag);
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public String toString() {
        return "Top Layer deposit with Blocks=" + this.getAllOres() + ", Samples=" + Arrays.toString(this.sampleToWeightMap.keySet().toArray()) + ", Radius=" + this.radius + ", Depth=" + this.depth;
    }

    @Override
    public int generate(class_5281 level, class_2338 pos, IWorldDepositComponent deposits, IWorldChunkComponent chunksGenerated) {
        if (!this.canPlaceInBiome((class_6880<class_1959>)level.method_23753(pos))) {
            return 0;
        }
        int totlPlaced = 0;
        class_1923 thisChunk = new class_1923(pos);
        int x = (thisChunk.method_8326() + thisChunk.method_8327()) / 2 - level.method_8409().method_43048(8) + level.method_8409().method_43048(16);
        int z = (thisChunk.method_8328() + thisChunk.method_8329()) / 2 - level.method_8409().method_43048(8) + level.method_8409().method_43048(16);
        int radX = this.radius / 2 + level.method_8409().method_43048(this.radius / 2);
        int radZ = this.radius / 2 + level.method_8409().method_43048(this.radius / 2);
        class_2338 basePos = new class_2338(x, 0, z);
        for (int dX = -radX; dX <= radX; ++dX) {
            for (int dZ = -radZ; dZ <= radZ; ++dZ) {
                if (dX * dX + dZ * dZ > this.radius + level.method_8409().method_43048(Math.max(1, this.radius / 2))) continue;
                class_2338 baseForXZ = GeoclusterUtils.getTopSolidBlock((class_4538)level, basePos.method_10069(dX, 0, dZ));
                for (int i = 0; i < this.depth; ++i) {
                    class_2680 smpl;
                    boolean isTop;
                    class_2338 placePos = baseForXZ.method_10087(i);
                    class_2680 current = level.method_8320(placePos);
                    class_2680 tmp = this.getOre(current, level.method_8409());
                    boolean bl = isTop = i == 0;
                    if (tmp == null) continue;
                    if (tmp.method_28498((class_2769)class_2741.field_16562)) {
                        tmp = (class_2680)tmp.method_11657((class_2769)class_2741.field_16562, (Comparable)Boolean.valueOf(!isTop));
                    }
                    if (!this.getBlockStateMatchers().contains(current) && !this.oreToWeightMap.containsKey(GeoclusterUtils.getRegistryName(current)) || !FeatureUtils.enqueueBlockPlacement(level, placePos, tmp, deposits, chunksGenerated)) continue;
                    ++totlPlaced;
                    if (!isTop || !(level.method_8409().method_43057() <= this.sampleChance) || (smpl = this.getSample(level.method_8409())) == null) continue;
                    FeatureUtils.enqueueBlockPlacement(level, placePos.method_10084(), smpl, deposits, chunksGenerated);
                    FeatureUtils.fixSnowyBlock(level, placePos);
                }
            }
        }
        return totlPlaced;
    }

    @Override
    public void generatePost(class_5281 level, class_2338 pos, IWorldDepositComponent deposits, IWorldChunkComponent chunksGenerated) {
        if (GeoclusterConfig.DEBUG_WORLD_GEN) {
            Geocluster.LOGGER.info("Generated {} in Chunk {} (Pos [{} {} {}])", new Object[]{this, new class_1923(pos), pos.method_10263(), pos.method_10264(), pos.method_10260()});
        }
    }

    @Override
    public HashSet<class_2680> getBlockStateMatchers() {
        return this.blockStateMatchers == null ? DepositUtils.getDefaultMatchers() : this.blockStateMatchers;
    }

    public static TopLayerDeposit deserialize(JsonObject json) {
        if (json == null) {
            return null;
        }
        try {
            HashMap<String, HashMap<class_2680, Float>> oreBlocks = SerializerUtils.buildMultiBlockMatcherMap(json.get("blocks").getAsJsonObject());
            HashMap<class_2680, Float> sampleBlocks = SerializerUtils.buildMultiBlockMap(json.get("samples").getAsJsonArray());
            int radius = json.get("radius").getAsInt();
            int depth = json.get("depth").getAsInt();
            float sampleChance = json.get("chanceForSample").getAsFloat();
            int genWt = json.get("generationWeight").getAsInt();
            class_6862 biomeTag = class_6862.method_40092((class_5321)class_2378.field_25114, (class_2960)new class_2960(json.get("biomeTag").getAsString().replace("#", "")));
            HashSet<class_2680> blockStateMatchers = DepositUtils.getDefaultMatchers();
            if (json.has("blockStateMatchers")) {
                blockStateMatchers = SerializerUtils.toBlockStateList(json.get("blockStateMatchers").getAsJsonArray());
            }
            return new TopLayerDeposit(oreBlocks, sampleBlocks, radius, depth, sampleChance, genWt, (class_6862<class_1959>)biomeTag, blockStateMatchers);
        }
        catch (Exception e) {
            Geocluster.LOGGER.error("Failed to parse: {}", (Object)e.getMessage());
            return null;
        }
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        JsonObject config = new JsonObject();
        config.add("blocks", (JsonElement)SerializerUtils.deconstructMultiBlockMatcherMap(this.oreToWeightMap));
        config.add("samples", (JsonElement)SerializerUtils.deconstructMultiBlockMap(this.sampleToWeightMap));
        config.addProperty("radius", (Number)this.radius);
        config.addProperty("depth", (Number)this.depth);
        config.addProperty("chanceForSample", (Number)Float.valueOf(this.sampleChance));
        config.addProperty("generationWeight", (Number)this.getWeight());
        config.addProperty("biomeTag", this.biomeTag.comp_327().toString());
        json.addProperty("type", JSON_TYPE);
        json.add("config", (JsonElement)config);
        return json;
    }
}

