/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.geocluster.common.components;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.sterner.geocluster.common.components.IWorldDepositComponent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class WorldDepositComponent
implements AutoSyncedComponent,
IWorldDepositComponent {
    private final ConcurrentHashMap<class_1923, ConcurrentLinkedQueue<PendingBlock>> pendingBlocks;
    public class_1937 world;

    public WorldDepositComponent(class_1937 world) {
        this.world = world;
        this.pendingBlocks = new ConcurrentHashMap();
    }

    public void readFromNbt(class_2487 tag) {
        tag.method_10541().forEach(chunkPosAsString -> {
            String[] parts = chunkPosAsString.split("_");
            class_1923 cp = new class_1923(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
            class_2499 pending = tag.method_10554(chunkPosAsString, 10);
            ConcurrentLinkedQueue lq = new ConcurrentLinkedQueue();
            pending.forEach(x -> {
                PendingBlock pendingBlock = PendingBlock.readNbt(x);
                if (pendingBlock != null) {
                    lq.add(pendingBlock);
                }
            });
            this.pendingBlocks.put(cp, lq);
        });
    }

    public void writeToNbt(class_2487 tag) {
        class_2487 compound = new class_2487();
        this.pendingBlocks.forEach((pos, pending) -> {
            class_2499 nbtList = new class_2499();
            String key = pos.field_9181 + "_" + pos.field_9180;
            pending.forEach(pendingBlock -> nbtList.add((Object)pendingBlock.writeNbt()));
            compound.method_10566(key, (class_2520)nbtList);
        });
    }

    @Override
    public void putPendingBlock(class_2338 pos, class_2680 state) {
        PendingBlock p = new PendingBlock(pos, state);
        class_1923 cp = new class_1923(pos);
        this.pendingBlocks.putIfAbsent(cp, new ConcurrentLinkedQueue());
        this.pendingBlocks.get(cp).add(p);
    }

    @Override
    public void removePendingBlocksForChunk(class_1923 p) {
        this.pendingBlocks.remove(p);
    }

    @Override
    public int getPendingBlockCount() {
        return (int)this.pendingBlocks.values().stream().collect(Collectors.summarizingInt(ConcurrentLinkedQueue::size)).getSum();
    }

    @Override
    public ConcurrentLinkedQueue<PendingBlock> getPendingBlocks(class_1923 chunkPos) {
        return this.pendingBlocks.getOrDefault(chunkPos, new ConcurrentLinkedQueue());
    }

    public record PendingBlock(class_2338 pos, class_2680 state) {
        public class_2487 writeNbt() {
            class_2487 tmp = new class_2487();
            class_2487 posTag = class_2512.method_10692((class_2338)this.pos);
            class_2487 stateTag = class_2512.method_10686((class_2680)this.state);
            tmp.method_10566("pos", (class_2520)posTag);
            tmp.method_10566("state", (class_2520)stateTag);
            return tmp;
        }

        @Nullable
        public static PendingBlock readNbt(class_2520 element) {
            if (element instanceof class_2487) {
                class_2487 tag = (class_2487)element;
                class_2338 pos = class_2512.method_10691((class_2487)tag.method_10562("pos"));
                class_2680 state = class_2512.method_10681((class_2487)tag.method_10562("state"));
                return new PendingBlock(pos, state);
            }
            return null;
        }

        @Override
        public String toString() {
            return "[" + this.pos.method_10263() + " " + this.pos.method_10264() + " " + this.pos.method_10260() + "]: " + class_2378.field_11146.method_10221((Object)this.state.method_26204());
        }
    }
}

