/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.world.spawner;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.world.spawner.GoblinData;
import com.mrcrayfish.goblintraders.world.spawner.GoblinTraderData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.server.MinecraftServer;

public class GoblinTraderSpawner {
    private final GoblinData data;
    private final class_1299<? extends AbstractGoblinEntity> entityType;
    private int delayBeforeSpawnLogic;
    private final int traderSpawnDelay;
    private final int traderSpawnChance;
    private int currentTraderSpawnDelay;
    private int currentTraderSpawnChance;
    private final int minLevel;
    private final int maxLevel;

    public GoblinTraderSpawner(MinecraftServer server, String key, class_1299<? extends AbstractGoblinEntity> entityType, Config.Entities.Goblin goblin) {
        this.data = GoblinTraderData.get(server).getGoblinData(key);
        this.entityType = entityType;
        this.delayBeforeSpawnLogic = 600;
        this.currentTraderSpawnDelay = this.data.getGoblinTraderSpawnDelay();
        this.currentTraderSpawnChance = this.data.getGoblinTraderSpawnChance();
        this.traderSpawnDelay = (Integer)goblin.traderSpawnDelay.get();
        this.traderSpawnChance = (Integer)goblin.traderSpawnChance.get();
        this.minLevel = Math.min((Integer)goblin.traderMinSpawnLevel.get(), (Integer)goblin.traderMaxSpawnLevel.get());
        this.maxLevel = Math.max((Integer)goblin.traderMinSpawnLevel.get(), (Integer)goblin.traderMaxSpawnLevel.get());
        if (this.currentTraderSpawnDelay == 0 && this.currentTraderSpawnChance == 0) {
            this.currentTraderSpawnDelay = this.traderSpawnDelay;
            this.currentTraderSpawnChance = this.traderSpawnChance;
            this.data.setGoblinTraderSpawnDelay(this.currentTraderSpawnDelay);
            this.data.setGoblinTraderSpawnChance(this.currentTraderSpawnChance);
        }
    }

    public int tick(class_1937 level) {
        if (level.method_8450().method_8355(class_1928.field_21832) && --this.delayBeforeSpawnLogic <= 0) {
            int delay;
            this.delayBeforeSpawnLogic = delay = Math.max(this.traderSpawnDelay / 20, 1);
            this.currentTraderSpawnDelay -= delay;
            this.data.setGoblinTraderSpawnDelay(this.currentTraderSpawnDelay);
            if (this.currentTraderSpawnDelay <= 0) {
                this.currentTraderSpawnDelay = this.traderSpawnDelay;
                if (level.method_8450().method_8355(class_1928.field_19390)) {
                    int spawnChance = this.currentTraderSpawnChance;
                    this.currentTraderSpawnChance = class_3532.method_15340((int)(this.currentTraderSpawnChance + this.traderSpawnChance), (int)this.traderSpawnChance, (int)100);
                    this.data.setGoblinTraderSpawnChance(this.currentTraderSpawnChance);
                    if (level.method_8409().method_43048(100) <= spawnChance && this.spawnTrader(level)) {
                        this.currentTraderSpawnChance = this.traderSpawnChance;
                    }
                }
            }
        }
        return 0;
    }

    private boolean spawnTrader(class_1937 level) {
        List players = level.method_18456();
        if (players.isEmpty()) {
            return false;
        }
        class_1657 randomPlayer = (class_1657)players.get(level.method_8409().method_43048(players.size()));
        if (randomPlayer == null) {
            return true;
        }
        class_2338 blockpos = randomPlayer.method_23312();
        class_2338 safestPos = this.getSafePositionAroundPlayer(randomPlayer.field_6002, blockpos, 10);
        if (safestPos != null && this.isEmptyCollision(randomPlayer.field_6002, safestPos)) {
            if (level.method_23753(safestPos).method_40225(class_1972.field_9473)) {
                return false;
            }
            if (safestPos.method_10264() < this.minLevel || safestPos.method_10264() >= this.maxLevel) {
                return false;
            }
            AbstractGoblinEntity goblin = (AbstractGoblinEntity)this.entityType.method_5899((class_3218)randomPlayer.field_6002, null, null, null, safestPos, class_3730.field_16467, false, false);
            if (goblin != null) {
                goblin.setDespawnDelay(this.traderSpawnDelay);
                goblin.method_18408(safestPos, 16);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private class_2338 getSafePositionAroundPlayer(class_1937 level, class_2338 pos, int range) {
        if (range == 0) {
            return null;
        }
        class_2338 safestPos = null;
        for (int attempts = 0; attempts < 50; ++attempts) {
            int posZ;
            int posY;
            int posX = pos.method_10263() + level.method_8409().method_43048(range * 2) - range;
            class_2338 testPos = this.findGround(level, new class_2338(posX, posY = pos.method_10264() + level.method_8409().method_43048(range) - range / 2, posZ = pos.method_10260() + level.method_8409().method_43048(range * 2) - range), range);
            if (testPos == null || !class_1948.method_8660((class_1317.class_1319)class_1317.class_1319.field_6317, (class_4538)level, (class_2338)testPos, this.entityType)) continue;
            safestPos = testPos;
            break;
        }
        return safestPos != null ? safestPos : this.getSafePositionAroundPlayer(level, pos, range / 2);
    }

    @Nullable
    private class_2338 findGround(class_1937 level, class_2338 pos, int maxDistance) {
        if (level.method_8320(pos).method_26215()) {
            class_2338 downPos = pos;
            while (class_1937.method_25953((class_2338)downPos.method_10074()) && level.method_8320(downPos.method_10074()).method_26215() && downPos.method_10074().method_19771((class_2382)pos, (double)maxDistance)) {
                downPos = downPos.method_10074();
            }
            if (!level.method_8320(downPos.method_10074()).method_26215()) {
                return downPos;
            }
        } else {
            class_2338 upPos = pos;
            while (class_1937.method_25953((class_2338)upPos.method_10084()) && !level.method_8320(upPos.method_10084()).method_26215() && upPos.method_10084().method_19771((class_2382)pos, (double)maxDistance)) {
                upPos = upPos.method_10084();
            }
            if (!level.method_8320(upPos.method_10074()).method_26215()) {
                return upPos;
            }
        }
        return null;
    }

    private boolean isEmptyCollision(class_1937 level, class_2338 pos) {
        return level.method_8320(pos).method_26220((class_1922)level, pos).method_1110();
    }
}

