/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Properties;
import net.coderbot.iris.Iris;
import net.coderbot.iris.colorspace.ColorSpace;
import net.coderbot.iris.gui.option.IrisVideoSettings;

public class IrisConfig {
    private static final String COMMENT = "This file stores configuration options for Iris, such as the currently active shaderpack";
    private String shaderPackName = null;
    private boolean enableShaders = true;
    private boolean enableDebugOptions = false;
    private boolean disableUpdateMessage = false;
    private final Path propertiesPath;

    public IrisConfig(Path path) {
        this.propertiesPath = path;
    }

    public void initialize() throws IOException {
        this.load();
        if (!Files.exists(this.propertiesPath, new LinkOption[0])) {
            this.save();
        }
    }

    public boolean isInternal() {
        return false;
    }

    public Optional<String> getShaderPackName() {
        return Optional.ofNullable(this.shaderPackName);
    }

    public void setShaderPackName(String string) {
        this.shaderPackName = string == null || string.equals("(internal)") || string.isEmpty() ? null : string;
    }

    public boolean areShadersEnabled() {
        return this.enableShaders;
    }

    public boolean areDebugOptionsEnabled() {
        return this.enableDebugOptions;
    }

    public boolean shouldDisableUpdateMessage() {
        return this.disableUpdateMessage;
    }

    public void setDebugEnabled(boolean bl) {
        this.enableDebugOptions = bl;
    }

    public void setShadersEnabled(boolean bl) {
        this.enableShaders = bl;
    }

    public void load() throws IOException {
        if (!Files.exists(this.propertiesPath, new LinkOption[0])) {
            return;
        }
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(this.propertiesPath, new OpenOption[0]);){
            properties.load(inputStream);
        }
        this.shaderPackName = properties.getProperty("shaderPack");
        this.enableShaders = !"false".equals(properties.getProperty("enableShaders"));
        this.enableDebugOptions = "true".equals(properties.getProperty("enableDebugOptions"));
        this.disableUpdateMessage = "true".equals(properties.getProperty("disableUpdateMessage"));
        try {
            IrisVideoSettings.shadowDistance = Integer.parseInt(properties.getProperty("maxShadowRenderDistance", "32"));
            IrisVideoSettings.colorSpace = ColorSpace.valueOf(properties.getProperty("colorSpace", "SRGB"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Iris.logger.error("Shadow distance setting reset; value is invalid.");
            IrisVideoSettings.shadowDistance = 32;
            IrisVideoSettings.colorSpace = ColorSpace.SRGB;
            this.save();
        }
        if (this.shaderPackName != null && (this.shaderPackName.equals("(internal)") || this.shaderPackName.isEmpty())) {
            this.shaderPackName = null;
        }
    }

    public void save() throws IOException {
        Properties properties = new Properties();
        properties.setProperty("shaderPack", this.getShaderPackName().orElse(""));
        properties.setProperty("enableShaders", this.enableShaders ? "true" : "false");
        properties.setProperty("enableDebugOptions", this.enableDebugOptions ? "true" : "false");
        properties.setProperty("disableUpdateMessage", this.disableUpdateMessage ? "true" : "false");
        properties.setProperty("maxShadowRenderDistance", String.valueOf(IrisVideoSettings.shadowDistance));
        properties.setProperty("colorSpace", IrisVideoSettings.colorSpace.name());
        try (OutputStream outputStream = Files.newOutputStream(this.propertiesPath, new OpenOption[0]);){
            properties.store(outputStream, COMMENT);
        }
    }
}

