/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.parsing;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import kroppeb.stareval.function.FunctionReturn;
import kroppeb.stareval.function.Type;
import net.coderbot.iris.vendored.joml.Vector2f;
import net.coderbot.iris.vendored.joml.Vector2i;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vendored.joml.Vector3i;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.coderbot.iris.vendored.joml.Vector4i;

public abstract class VectorType
extends Type.ObjectType {
    public static final JOMLVector<Vector2f> VEC2 = new JOMLVector<Vector2f>("vec2", Vector2f::new);
    public static final JOMLVector<Vector3f> VEC3 = new JOMLVector<Vector3f>("vec3", Vector3f::new);
    public static final JOMLVector<Vector4f> VEC4 = new JOMLVector<Vector4f>("vec4", Vector4f::new);
    public static final JOMLVector<Vector2i> I_VEC2 = new JOMLVector<Vector2i>("ivec2", Vector2i::new);
    public static final JOMLVector<Vector3i> I_VEC3 = new JOMLVector<Vector3i>("ivec3", Vector3i::new);
    public static final JOMLVector<Vector4i> I_VEC4 = new JOMLVector<Vector4i>("ivec4", Vector4i::new);
    public static final VectorType B_VEC2 = new ArrayVector(Type.Boolean, 2);
    public static final VectorType B_VEC3 = new ArrayVector(Type.Boolean, 3);
    public static final VectorType B_VEC4 = new ArrayVector(Type.Boolean, 4);
    public static final ArrayVector[] AllArrayVectorTypes = (ArrayVector[])Stream.of(Type.Int, Type.Boolean).flatMap(primitive -> IntStream.rangeClosed(2, 4).mapToObj(n -> new ArrayVector((Type)primitive, n))).toArray(ArrayVector[]::new);
    public static final VectorType[] AllVectorTypes = (VectorType[])Arrays.stream(Type.AllPrimitives).flatMap(primitive -> IntStream.rangeClosed(2, 4).mapToObj(n -> VectorType.of(primitive, n))).toArray(VectorType[]::new);

    public static VectorType of(Type.Primitive primitive, int n) {
        if (primitive.equals(Type.Float)) {
            switch (n) {
                case 2: {
                    return VEC2;
                }
                case 3: {
                    return VEC3;
                }
                case 4: {
                    return VEC4;
                }
            }
            throw new IllegalArgumentException("not a valid vector");
        }
        return new ArrayVector(primitive, n);
    }

    public static class JOMLVector<T>
    extends VectorType {
        private final String name;
        private final Supplier<T> supplier;

        public JOMLVector(String string, Supplier<T> supplier) {
            this.name = string;
            this.supplier = supplier;
        }

        @Override
        public String toString() {
            return this.name;
        }

        public T create() {
            return this.supplier.get();
        }
    }

    public static class ArrayVector
    extends VectorType {
        private final Type inner;
        private final int size;

        public ArrayVector(Type type, int n) {
            this.inner = type;
            this.size = n;
        }

        public Object createObject() {
            return this.inner.createArray(this.size);
        }

        public void setValue(Object object, int n, FunctionReturn functionReturn) {
            this.inner.setValueFromReturn(object, n, functionReturn);
        }

        public void getValue(Object object, int n, FunctionReturn functionReturn) {
            this.inner.getValueFromArray(object, n, functionReturn);
        }

        public <T1, T2> void map(T1 T1, T2 T2, FunctionReturn functionReturn, IntObjectObjectObjectConsumer<T1, T2, FunctionReturn> intObjectObjectObjectConsumer) {
            Object object = this.createObject();
            for (int i = 0; i < this.size; ++i) {
                intObjectObjectObjectConsumer.accept(i, T1, T2, functionReturn);
                this.setValue(object, i, functionReturn);
            }
            functionReturn.objectReturn = object;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ArrayVector)) {
                return false;
            }
            ArrayVector arrayVector = (ArrayVector)object;
            return this.size == arrayVector.size && this.inner.equals(arrayVector.inner);
        }

        public int hashCode() {
            return Objects.hash(this.inner, this.size);
        }

        @Override
        public String toString() {
            String string = this.inner.equals(Type.Float) ? "" : this.inner.toString().substring(0, 1);
            return "__" + string + "vec" + this.size;
        }

        public static interface IntObjectObjectObjectConsumer<TB, TC, TD> {
            public void accept(int var1, TB var2, TC var3, TD var4);
        }
    }
}

