/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.rendertarget.NativeImageBackedSingleColorTexture;
import net.coderbot.iris.texture.TextureTracker;
import net.coderbot.iris.texture.pbr.PBRTextureHolder;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.texture.pbr.loader.PBRTextureLoader;
import net.coderbot.iris.texture.pbr.loader.PBRTextureLoaderRegistry;
import net.minecraft.class_1044;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class PBRTextureManager {
    public static final PBRTextureManager INSTANCE = new PBRTextureManager();
    public static final boolean DEBUG = System.getProperty("iris.pbr.debug") != null;
    private static Runnable normalTextureChangeListener;
    private static Runnable specularTextureChangeListener;
    private final Int2ObjectMap<PBRTextureHolder> holders = new Int2ObjectOpenHashMap();
    private final PBRTextureConsumerImpl consumer = new PBRTextureConsumerImpl();
    private NativeImageBackedSingleColorTexture defaultNormalTexture;
    private NativeImageBackedSingleColorTexture defaultSpecularTexture;
    private final PBRTextureHolder defaultHolder;

    private PBRTextureManager() {
        class Net_coderbot_iris_texture_pbr_PBRTextureManager$1
        implements PBRTextureHolder {
            Net_coderbot_iris_texture_pbr_PBRTextureManager$1() {
            }

            @Override
            @NotNull
            public class_1044 getNormalTexture() {
                return PBRTextureManager.this.defaultNormalTexture;
            }

            @Override
            @NotNull
            public class_1044 getSpecularTexture() {
                return PBRTextureManager.this.defaultSpecularTexture;
            }
        }
        this.defaultHolder = new Net_coderbot_iris_texture_pbr_PBRTextureManager$1();
    }

    public void init() {
        this.defaultNormalTexture = new NativeImageBackedSingleColorTexture(PBRType.NORMAL.getDefaultValue());
        this.defaultSpecularTexture = new NativeImageBackedSingleColorTexture(PBRType.SPECULAR.getDefaultValue());
    }

    public PBRTextureHolder getHolder(int n) {
        PBRTextureHolder pBRTextureHolder = (PBRTextureHolder)this.holders.get(n);
        if (pBRTextureHolder == null) {
            return this.defaultHolder;
        }
        return pBRTextureHolder;
    }

    public PBRTextureHolder getOrLoadHolder(int n) {
        PBRTextureHolder pBRTextureHolder = (PBRTextureHolder)this.holders.get(n);
        if (pBRTextureHolder == null) {
            pBRTextureHolder = this.loadHolder(n);
            this.holders.put(n, (Object)pBRTextureHolder);
        }
        return pBRTextureHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PBRTextureHolder loadHolder(int n) {
        Class<?> clazz;
        PBRTextureLoader<?> pBRTextureLoader;
        class_1044 class_10442 = TextureTracker.INSTANCE.getTexture(n);
        if (class_10442 != null && (pBRTextureLoader = PBRTextureLoaderRegistry.INSTANCE.getLoader(clazz = class_10442.getClass())) != null) {
            int n2 = RenderSystem.getTextureId((int)GlStateManagerAccessor.getActiveTexture());
            this.consumer.clear();
            try {
                pBRTextureLoader.load(class_10442, class_310.method_1551().method_1478(), this.consumer);
                PBRTextureHolder pBRTextureHolder = this.consumer.toHolder();
                return pBRTextureHolder;
            }
            catch (Exception exception) {
                Iris.logger.debug("Failed to load PBR textures for texture " + n, exception);
            }
            finally {
                GlStateManager._bindTexture((int)n2);
            }
        }
        return this.defaultHolder;
    }

    public void onDeleteTexture(int n) {
        PBRTextureHolder pBRTextureHolder = (PBRTextureHolder)this.holders.remove(n);
        if (pBRTextureHolder != null) {
            this.closeHolder(pBRTextureHolder);
        }
    }

    public void clear() {
        for (PBRTextureHolder pBRTextureHolder : this.holders.values()) {
            if (pBRTextureHolder == this.defaultHolder) continue;
            this.closeHolder(pBRTextureHolder);
        }
        this.holders.clear();
    }

    public void close() {
        this.clear();
        this.defaultNormalTexture.close();
        this.defaultSpecularTexture.close();
    }

    private void closeHolder(PBRTextureHolder pBRTextureHolder) {
        class_1044 class_10442 = pBRTextureHolder.getNormalTexture();
        class_1044 class_10443 = pBRTextureHolder.getSpecularTexture();
        if (class_10442 != this.defaultNormalTexture) {
            PBRTextureManager.closeTexture(class_10442);
        }
        if (class_10443 != this.defaultSpecularTexture) {
            PBRTextureManager.closeTexture(class_10443);
        }
    }

    private static void closeTexture(class_1044 class_10442) {
        try {
            class_10442.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        class_10442.method_4528();
    }

    public static void notifyPBRTexturesChanged() {
        if (normalTextureChangeListener != null) {
            normalTextureChangeListener.run();
        }
        if (specularTextureChangeListener != null) {
            specularTextureChangeListener.run();
        }
    }

    static {
        StateUpdateNotifiers.normalTextureChangeNotifier = runnable -> {
            normalTextureChangeListener = runnable;
        };
        StateUpdateNotifiers.specularTextureChangeNotifier = runnable -> {
            specularTextureChangeListener = runnable;
        };
    }

    private class PBRTextureConsumerImpl
    implements PBRTextureLoader.PBRTextureConsumer {
        private class_1044 normalTexture;
        private class_1044 specularTexture;
        private boolean changed;

        private PBRTextureConsumerImpl() {
        }

        @Override
        public void acceptNormalTexture(@NotNull class_1044 class_10442) {
            this.normalTexture = class_10442;
            this.changed = true;
        }

        @Override
        public void acceptSpecularTexture(@NotNull class_1044 class_10442) {
            this.specularTexture = class_10442;
            this.changed = true;
        }

        public void clear() {
            this.normalTexture = PBRTextureManager.this.defaultNormalTexture;
            this.specularTexture = PBRTextureManager.this.defaultSpecularTexture;
            this.changed = false;
        }

        public PBRTextureHolder toHolder() {
            if (this.changed) {
                return new PBRTextureHolderImpl(this.normalTexture, this.specularTexture);
            }
            return PBRTextureManager.this.defaultHolder;
        }
    }

    private static class PBRTextureHolderImpl
    implements PBRTextureHolder {
        private final class_1044 normalTexture;
        private final class_1044 specularTexture;

        public PBRTextureHolderImpl(class_1044 class_10442, class_1044 class_10443) {
            this.normalTexture = class_10442;
            this.specularTexture = class_10443;
        }

        @Override
        @NotNull
        public class_1044 getNormalTexture() {
            return this.normalTexture;
        }

        @Override
        @NotNull
        public class_1044 getSpecularTexture() {
            return this.specularTexture;
        }
    }
}

