/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.coderbot.iris.JomlConversions;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.gl.uniform.DynamicUniformHolder;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.layer.GbufferPrograms;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.mixin.statelisteners.BooleanStateAccessor;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.texture.TextureInfoCache;
import net.coderbot.iris.texture.TextureTracker;
import net.coderbot.iris.uniforms.BiomeParameters;
import net.coderbot.iris.uniforms.CameraUniforms;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CelestialUniforms;
import net.coderbot.iris.uniforms.ExternallyManagedUniforms;
import net.coderbot.iris.uniforms.FogUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.IdMapUniforms;
import net.coderbot.iris.uniforms.IrisExclusiveUniforms;
import net.coderbot.iris.uniforms.IrisInternalUniforms;
import net.coderbot.iris.uniforms.IrisTimeUniforms;
import net.coderbot.iris.uniforms.MatrixUniforms;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.coderbot.iris.uniforms.ViewportUniforms;
import net.coderbot.iris.uniforms.WorldTimeUniforms;
import net.coderbot.iris.uniforms.transforms.SmoothedFloat;
import net.coderbot.iris.uniforms.transforms.SmoothedVec2f;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.Vector2f;
import net.coderbot.iris.vendored.joml.Vector2i;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.coderbot.iris.vendored.joml.Vector4i;
import net.minecraft.class_1044;
import net.minecraft.class_1059;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_5636;
import net.minecraft.class_746;
import net.minecraft.class_757;

public final class CommonUniforms {
    private static final class_310 client = class_310.method_1551();
    private static final Vector2i ZERO_VECTOR_2i = new Vector2i();
    private static final Vector4i ZERO_VECTOR_4i = new Vector4i(0, 0, 0, 0);
    private static final Vector3d ZERO_VECTOR_3d = new Vector3d();

    private CommonUniforms() {
    }

    public static void addDynamicUniforms(DynamicUniformHolder dynamicUniformHolder, FogMode fogMode) {
        ExternallyManagedUniforms.addExternallyManagedUniforms117(dynamicUniformHolder);
        FogUniforms.addFogUniforms(dynamicUniformHolder, fogMode);
        IrisInternalUniforms.addFogUniforms(dynamicUniformHolder, fogMode);
        dynamicUniformHolder.uniform1i("entityId", CapturedRenderingState.INSTANCE::getCurrentRenderedEntity, StateUpdateNotifiers.fallbackEntityNotifier);
        dynamicUniformHolder.uniform2i("atlasSize", () -> {
            int n = RenderSystem.getShaderTexture((int)0);
            class_1044 class_10442 = TextureTracker.INSTANCE.getTexture(n);
            if (class_10442 instanceof class_1059) {
                TextureInfoCache.TextureInfo textureInfo = TextureInfoCache.INSTANCE.getInfo(n);
                return new Vector2i(textureInfo.getWidth(), textureInfo.getHeight());
            }
            return ZERO_VECTOR_2i;
        }, runnable -> {});
        dynamicUniformHolder.uniform2i("gtextureSize", () -> {
            int n = GlStateManagerAccessor.getTEXTURES()[0].field_5167;
            TextureInfoCache.TextureInfo textureInfo = TextureInfoCache.INSTANCE.getInfo(n);
            return new Vector2i(textureInfo.getWidth(), textureInfo.getHeight());
        }, StateUpdateNotifiers.bindTextureNotifier);
        dynamicUniformHolder.uniform4i("blendFunc", () -> {
            GlStateManager.class_1017 class_10172 = GlStateManagerAccessor.getBLEND();
            if (((BooleanStateAccessor)class_10172.field_5045).isEnabled()) {
                return new Vector4i(class_10172.field_5049, class_10172.field_5048, class_10172.field_5047, class_10172.field_5046);
            }
            return ZERO_VECTOR_4i;
        }, StateUpdateNotifiers.blendFuncNotifier);
        dynamicUniformHolder.uniform1i("renderStage", () -> GbufferPrograms.getCurrentPhase().ordinal(), StateUpdateNotifiers.phaseChangeNotifier);
    }

    public static void addCommonUniforms(DynamicUniformHolder dynamicUniformHolder, IdMap idMap, PackDirectives packDirectives, FrameUpdateNotifier frameUpdateNotifier, FogMode fogMode) {
        CommonUniforms.addNonDynamicUniforms(dynamicUniformHolder, idMap, packDirectives, frameUpdateNotifier);
        CommonUniforms.addDynamicUniforms(dynamicUniformHolder, fogMode);
    }

    public static void addNonDynamicUniforms(UniformHolder uniformHolder, IdMap idMap, PackDirectives packDirectives, FrameUpdateNotifier frameUpdateNotifier) {
        CameraUniforms.addCameraUniforms(uniformHolder, frameUpdateNotifier);
        ViewportUniforms.addViewportUniforms(uniformHolder);
        WorldTimeUniforms.addWorldTimeUniforms(uniformHolder);
        SystemTimeUniforms.addSystemTimeUniforms(uniformHolder);
        BiomeParameters.addBiomeUniforms(uniformHolder);
        new CelestialUniforms(packDirectives.getSunPathRotation()).addCelestialUniforms(uniformHolder);
        IrisExclusiveUniforms.addIrisExclusiveUniforms(uniformHolder);
        IrisTimeUniforms.addTimeUniforms(uniformHolder);
        MatrixUniforms.addMatrixUniforms(uniformHolder, packDirectives);
        IdMapUniforms.addIdMapUniforms(frameUpdateNotifier, uniformHolder, idMap, packDirectives.isOldHandLight());
        CommonUniforms.generalCommonUniforms(uniformHolder, frameUpdateNotifier, packDirectives);
    }

    public static void generalCommonUniforms(UniformHolder uniformHolder, FrameUpdateNotifier frameUpdateNotifier, PackDirectives packDirectives) {
        ExternallyManagedUniforms.addExternallyManagedUniforms117(uniformHolder);
        SmoothedVec2f smoothedVec2f = new SmoothedVec2f(packDirectives.getEyeBrightnessHalfLife(), packDirectives.getEyeBrightnessHalfLife(), CommonUniforms::getEyeBrightness, frameUpdateNotifier);
        uniformHolder.uniform1b(UniformUpdateFrequency.PER_FRAME, "hideGUI", () -> CommonUniforms.client.field_1690.field_1842).uniform1i(UniformUpdateFrequency.PER_FRAME, "isEyeInWater", CommonUniforms::isEyeInWater).uniform1f(UniformUpdateFrequency.PER_FRAME, "blindness", CommonUniforms::getBlindness).uniform1f(UniformUpdateFrequency.PER_FRAME, "darknessFactor", CommonUniforms::getDarknessFactor).uniform1f(UniformUpdateFrequency.PER_FRAME, "darknessLightFactor", CapturedRenderingState.INSTANCE::getDarknessLightFactor).uniform1f(UniformUpdateFrequency.PER_FRAME, "nightVision", CommonUniforms::getNightVision).uniform1b(UniformUpdateFrequency.PER_FRAME, "is_sneaking", CommonUniforms::isSneaking).uniform1b(UniformUpdateFrequency.PER_FRAME, "is_sprinting", CommonUniforms::isSprinting).uniform1b(UniformUpdateFrequency.PER_FRAME, "is_hurt", CommonUniforms::isHurt).uniform1b(UniformUpdateFrequency.PER_FRAME, "is_invisible", CommonUniforms::isInvisible).uniform1b(UniformUpdateFrequency.PER_FRAME, "is_burning", CommonUniforms::isBurning).uniform1b(UniformUpdateFrequency.PER_FRAME, "is_on_ground", CommonUniforms::isOnGround).uniform1f(UniformUpdateFrequency.PER_FRAME, "screenBrightness", () -> (Double)CommonUniforms.client.field_1690.method_42473().method_41753()).uniform4f(UniformUpdateFrequency.ONCE, "entityColor", () -> new Vector4f(0.0f, 0.0f, 0.0f, 0.0f)).uniform1i(UniformUpdateFrequency.ONCE, "blockEntityId", () -> -1).uniform1i(UniformUpdateFrequency.ONCE, "currentRenderedItemId", () -> -1).uniform1f(UniformUpdateFrequency.ONCE, "pi", () -> java.lang.Math.PI).uniform1f(UniformUpdateFrequency.PER_TICK, "playerMood", CommonUniforms::getPlayerMood).uniform2i(UniformUpdateFrequency.PER_FRAME, "eyeBrightness", CommonUniforms::getEyeBrightness).uniform2i(UniformUpdateFrequency.PER_FRAME, "eyeBrightnessSmooth", () -> {
            Vector2f vector2f = smoothedVec2f.get();
            return new Vector2i((int)vector2f.x(), (int)vector2f.y());
        }).uniform1f(UniformUpdateFrequency.PER_TICK, "rainStrength", CommonUniforms::getRainStrength).uniform1f(UniformUpdateFrequency.PER_TICK, "wetness", new SmoothedFloat(packDirectives.getWetnessHalfLife(), packDirectives.getDrynessHalfLife(), CommonUniforms::getRainStrength, frameUpdateNotifier)).uniform3d(UniformUpdateFrequency.PER_FRAME, "skyColor", CommonUniforms::getSkyColor);
    }

    private static boolean isOnGround() {
        return CommonUniforms.client.field_1724 != null && CommonUniforms.client.field_1724.method_24828();
    }

    private static boolean isHurt() {
        if (CommonUniforms.client.field_1724 != null) {
            return CommonUniforms.client.field_1724.field_6235 > 0;
        }
        return false;
    }

    private static boolean isInvisible() {
        if (CommonUniforms.client.field_1724 != null) {
            return CommonUniforms.client.field_1724.method_5767();
        }
        return false;
    }

    private static boolean isBurning() {
        if (CommonUniforms.client.field_1724 != null) {
            return CommonUniforms.client.field_1724.method_5809();
        }
        return false;
    }

    private static boolean isSneaking() {
        if (CommonUniforms.client.field_1724 != null) {
            return CommonUniforms.client.field_1724.method_18276();
        }
        return false;
    }

    private static boolean isSprinting() {
        if (CommonUniforms.client.field_1724 != null) {
            return CommonUniforms.client.field_1724.method_5624();
        }
        return false;
    }

    private static Vector3d getSkyColor() {
        if (CommonUniforms.client.field_1687 == null || CommonUniforms.client.field_1719 == null) {
            return ZERO_VECTOR_3d;
        }
        return JomlConversions.fromVec3(CommonUniforms.client.field_1687.method_23777(CommonUniforms.client.field_1719.method_19538(), CapturedRenderingState.INSTANCE.getTickDelta()));
    }

    static float getBlindness() {
        class_1293 class_12932;
        class_1297 class_12972 = client.method_1560();
        if (class_12972 instanceof class_1309 && (class_12932 = ((class_1309)class_12972).method_6112(class_1294.field_5919)) != null) {
            return Math.clamp(0.0f, 1.0f, (float)class_12932.method_5584() / 20.0f);
        }
        return 0.0f;
    }

    static float getDarknessFactor() {
        class_1293 class_12932;
        class_1297 class_12972 = client.method_1560();
        if (class_12972 instanceof class_1309 && (class_12932 = ((class_1309)class_12972).method_6112(class_1294.field_38092)) != null && class_12932.method_42129().isPresent()) {
            return ((class_1293.class_7247)class_12932.method_42129().get()).method_42134((class_1309)class_12972, CapturedRenderingState.INSTANCE.getTickDelta());
        }
        return 0.0f;
    }

    private static float getPlayerMood() {
        if (!(CommonUniforms.client.field_1719 instanceof class_746)) {
            return 0.0f;
        }
        return Math.clamp(0.0f, 1.0f, ((class_746)CommonUniforms.client.field_1719).method_26269());
    }

    static float getRainStrength() {
        if (CommonUniforms.client.field_1687 == null) {
            return 0.0f;
        }
        return Math.clamp(0.0f, 1.0f, CommonUniforms.client.field_1687.method_8430(CapturedRenderingState.INSTANCE.getTickDelta()));
    }

    private static Vector2i getEyeBrightness() {
        if (CommonUniforms.client.field_1719 == null || CommonUniforms.client.field_1687 == null) {
            return ZERO_VECTOR_2i;
        }
        class_243 class_2432 = CommonUniforms.client.field_1719.method_19538();
        class_243 class_2433 = new class_243(class_2432.field_1352, CommonUniforms.client.field_1719.method_23320(), class_2432.field_1350);
        class_2338 class_23382 = new class_2338(class_2433);
        int n = CommonUniforms.client.field_1687.method_8314(class_1944.field_9282, class_23382);
        int n2 = CommonUniforms.client.field_1687.method_8314(class_1944.field_9284, class_23382);
        return new Vector2i(n * 16, n2 * 16);
    }

    private static float getNightVision() {
        float f;
        class_1297 class_12972 = client.method_1560();
        if (class_12972 instanceof class_1309) {
            class_1309 class_13092 = (class_1309)class_12972;
            try {
                float f2 = class_757.method_3174((class_1309)class_13092, (float)CapturedRenderingState.INSTANCE.getTickDelta());
                if (f2 > 0.0f) {
                    return Math.clamp(0.0f, 1.0f, f2);
                }
            }
            catch (NullPointerException nullPointerException) {
                return 0.0f;
            }
        }
        if (CommonUniforms.client.field_1724 != null && CommonUniforms.client.field_1724.method_6059(class_1294.field_5927) && (f = CommonUniforms.client.field_1724.method_3140()) > 0.0f) {
            return Math.clamp(0.0f, 1.0f, f);
        }
        return 0.0f;
    }

    static int isEyeInWater() {
        class_5636 class_56362 = CommonUniforms.client.field_1773.method_19418().method_19334();
        if (class_56362 == class_5636.field_27886) {
            return 1;
        }
        if (class_56362 == class_5636.field_27885) {
            return 2;
        }
        if (class_56362 == class_5636.field_27887) {
            return 3;
        }
        return 0;
    }

    static {
        GbufferPrograms.init();
    }
}

