/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.api.property.properties;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.class_2498;
import net.minecraft.class_3614;
import net.minecraft.class_4970;
import tech.thatgravyboat.ironchests.api.property.MaterialHelper;
import tech.thatgravyboat.ironchests.api.property.SoundTypeHelper;
import tech.thatgravyboat.ironchests.api.property.base.BlockProperty;
import tech.thatgravyboat.ironchests.api.property.base.BlockPropertyType;

public record BuilderProperty(class_3614 material, int lightLevel, boolean noCollision, boolean noOcclusion, boolean noDrops, boolean requiresCorrectToolForDrops, float friction, float speedFactor, float jumpFactor, float destroyTime, float explosionResistance, class_2498 soundType) implements BlockProperty
{
    public static final Type TYPE = new Type();

    @Override
    public class_4970.class_2251 getProperties() {
        class_4970.class_2251 properties = class_4970.class_2251.method_9637((class_3614)this.material());
        properties.method_9631(state -> this.lightLevel());
        if (this.noCollision) {
            properties.method_9634();
        }
        if (this.noOcclusion) {
            properties.method_22488();
        }
        if (this.noDrops) {
            properties.method_42327();
        }
        if (this.requiresCorrectToolForDrops) {
            properties.method_29292();
        }
        properties.method_9628(this.friction());
        properties.method_23351(this.speedFactor());
        properties.method_23352(this.jumpFactor());
        properties.method_36557(this.destroyTime());
        properties.method_36558(this.explosionResistance());
        properties.method_9626(this.soundType());
        return properties;
    }

    @Override
    public BlockPropertyType getType() {
        return TYPE;
    }

    private static class Type
    implements BlockPropertyType {
        private static final Codec<class_3614> MATERIAL_CODEC = Codec.STRING.comapFlatMap(MaterialHelper::getMaterial, Object::toString);
        private static final Codec<class_2498> SOUND_CODEC = Codec.STRING.comapFlatMap(SoundTypeHelper::getSound, Object::toString);
        private static final Codec<BuilderProperty> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MATERIAL_CODEC.fieldOf("material").forGetter(Type.get(class_3614.field_15959)), (App)Codec.intRange((int)0, (int)15).fieldOf("lightLevel").orElse((Object)0).forGetter(Type.get(0)), (App)Codec.BOOL.fieldOf("noCollision").orElse((Object)false).forGetter(Type.get(false)), (App)Codec.BOOL.fieldOf("noOcclusion").orElse((Object)false).forGetter(Type.get(false)), (App)Codec.BOOL.fieldOf("noDrops").orElse((Object)false).forGetter(Type.get(false)), (App)Codec.BOOL.fieldOf("requiresCorrectToolForDrops").orElse((Object)false).forGetter(Type.get(false)), (App)Codec.FLOAT.fieldOf("friction").orElse((Object)Float.valueOf(0.6f)).forGetter(Type.get(Float.valueOf(0.6f))), (App)Codec.FLOAT.fieldOf("speedFactor").orElse((Object)Float.valueOf(1.0f)).forGetter(Type.get(Float.valueOf(1.0f))), (App)Codec.FLOAT.fieldOf("jumpFactor").orElse((Object)Float.valueOf(1.0f)).forGetter(Type.get(Float.valueOf(1.0f))), (App)Codec.FLOAT.fieldOf("destroyTime").orElse((Object)Float.valueOf(0.0f)).forGetter(Type.get(Float.valueOf(0.0f))), (App)Codec.FLOAT.fieldOf("explosionResistance").orElse((Object)Float.valueOf(0.0f)).forGetter(Type.get(Float.valueOf(0.0f))), (App)SOUND_CODEC.fieldOf("sound").forGetter(Type.get(class_2498.field_11544))).apply((Applicative)instance, BuilderProperty::new));

        private Type() {
        }

        private static <E, T> Function<E, T> get(T type) {
            return e -> type;
        }

        public Codec<BuilderProperty> codec() {
            return CODEC;
        }

        @Override
        public String getId() {
            return "builder";
        }
    }
}

