/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters;

import dev.latvian.mods.itemfilters.api.IItemFilter;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2378;

public class DisplayStacksCache {
    private static final int MAX_CACHE_SIZE = 1024;
    private static final Object2ObjectLinkedOpenHashMap<CacheKey, List<class_1799>> cache = new Object2ObjectLinkedOpenHashMap(1024);
    private static final class_2371<class_1799> allKnownStacks = class_2371.method_10211();

    @Nonnull
    public static List<class_1799> getCachedDisplayStacks(class_1799 filterStack) {
        CacheKey key = new CacheKey(filterStack);
        List<class_1799> result = (List<class_1799>)cache.getAndMoveToFirst((Object)key);
        if (result == null) {
            result = DisplayStacksCache.computeMatchingStacks(filterStack);
            cache.put((Object)key, result);
            if (cache.size() >= 1024) {
                cache.removeLast();
            }
        }
        return result;
    }

    private static List<class_1799> computeMatchingStacks(class_1799 filterStack) {
        if (allKnownStacks.isEmpty()) {
            for (class_1792 item : class_2378.field_11142) {
                try {
                    item.method_7850(class_1761.field_7915, allKnownStacks);
                }
                catch (Throwable throwable) {}
            }
        }
        IItemFilter f = (IItemFilter)filterStack.method_7909();
        return allKnownStacks.stream().filter(candidate -> f.filter(filterStack, (class_1799)candidate)).toList();
    }

    public static void clear() {
        cache.clear();
    }

    private static class CacheKey {
        private final int key;

        private CacheKey(class_1799 filterStack) {
            this.key = Objects.hash(class_2378.field_11142.method_10206((Object)filterStack.method_7909()), filterStack.method_7985() ? filterStack.method_7969().hashCode() : 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.key == cacheKey.key;
        }

        public int hashCode() {
            return Integer.hashCode(this.key);
        }
    }
}

