/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.registry;

import io.github.jamalam360.jamlib.JamLib;
import io.github.jamalam360.jamlib.registry.annotation.BlockItemFactory;
import io.github.jamalam360.jamlib.registry.annotation.ContentRegistry;
import io.github.jamalam360.jamlib.registry.annotation.WithIdentifier;
import io.github.jamalam360.jamlib.registry.annotation.WithoutBlockItem;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1535;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2582;
import net.minecraft.class_2591;
import net.minecraft.class_2806;
import net.minecraft.class_2939;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_3611;
import net.minecraft.class_3773;
import net.minecraft.class_3816;
import net.minecraft.class_3825;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4140;
import net.minecraft.class_4149;
import net.minecraft.class_4158;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4648;
import net.minecraft.class_4652;
import net.minecraft.class_4663;
import net.minecraft.class_4995;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5142;
import net.minecraft.class_5202;
import net.minecraft.class_5338;
import net.minecraft.class_5339;
import net.minecraft.class_5342;
import net.minecraft.class_5650;
import net.minecraft.class_5657;
import net.minecraft.class_5669;
import net.minecraft.class_5712;
import net.minecraft.class_5717;
import net.minecraft.class_5864;
import net.minecraft.class_6018;
import net.minecraft.class_6123;
import net.minecraft.class_6647;
import net.minecraft.class_6798;
import net.minecraft.class_6875;
import net.minecraft.class_7106;
import net.minecraft.class_7151;
import net.minecraft.class_7375;
import net.minecraft.class_7388;
import net.minecraft.class_7444;

public class JamLibRegistry {
    private static final Map<Class<?>, class_2378<?>> REGISTRIES = new HashMap();

    public static void addRegistry(Class<?> type, class_2378<?> registry) {
        REGISTRIES.put(type, registry);
    }

    public static void register(Class<?> ... registries) {
        for (Class<?> clazz : registries) {
            JamLibRegistry.register(clazz);
        }
    }

    public static void register(Class<?> registry) {
        if (!registry.isAnnotationPresent(ContentRegistry.class)) {
            JamLib.LOGGER.warn("@ContentRegistry annotation not present on registry class", registry.getName());
            return;
        }
        String modId = registry.getAnnotation(ContentRegistry.class).value();
        boolean checkedForBlockItemCreator = false;
        Method blockItemCreator = null;
        block8: for (Field f : registry.getFields()) {
            if (!f.canAccess(null)) {
                JamLib.LOGGER.warn("Cannot access field", f.getName(), "in registry class", registry.getName());
                continue;
            }
            Class<?> fClass = f.getType();
            Object fObj = null;
            try {
                fObj = f.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            class_2960 fId = JamLibRegistry.getIdentifier(modId, f);
            for (Map.Entry<Class<?>, class_2378<?>> e : REGISTRIES.entrySet()) {
                if (!e.getKey().isAssignableFrom(fClass)) continue;
                class_2378.method_10230(e.getValue(), (class_2960)fId, (Object)fObj);
                break;
            }
            if (class_2248.class.isAssignableFrom(fClass)) {
                if (!checkedForBlockItemCreator) {
                    for (Method method : registry.getDeclaredMethods()) {
                        if (!method.isAnnotationPresent(BlockItemFactory.class)) continue;
                        if (method.getParameterTypes().length != 1 || !class_2248.class.isAssignableFrom(method.getParameterTypes()[0]) || !class_1792.class.isAssignableFrom(method.getReturnType())) {
                            throw new IllegalArgumentException("@BlockItemFactory method " + method.getName() + " in registry class " + registry.getName() + " has invalid parameters or return type.");
                        }
                        if (!method.canAccess(null)) {
                            throw new IllegalArgumentException("Cannot access @BlockItemFactory method " + method.getName() + " in registry class " + registry.getName());
                        }
                        blockItemCreator = method;
                        break;
                    }
                    checkedForBlockItemCreator = true;
                }
                if (blockItemCreator != null && !f.isAnnotationPresent(WithoutBlockItem.class)) {
                    try {
                        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)fId, (Object)((class_1792)blockItemCreator.invoke(null, fObj)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (!class_1299.class.isAssignableFrom(fClass)) continue;
            Class<?> entityClass = null;
            try {
                entityClass = Class.forName(((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0].getTypeName());
            }
            catch (ClassNotFoundException e) {
                JamLib.LOGGER.warn("Encountered error registering entity attributes. This should absolutely be reported. Reflection was a mistake...");
                JamLib.LOGGER.warn(e.toString());
            }
            if (entityClass == null) continue;
            for (Method method : entityClass.getMethods()) {
                if (method.getDeclaringClass() != entityClass || !Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 0 || method.getReturnType() != class_5132.class_5133.class) continue;
                JamLib.DEV_LOGGER.info("Registering entity attributes for", entityClass.getName(), "automatically");
                try {
                    FabricDefaultAttributeRegistry.register((class_1299)((class_1299)fObj), (class_5132.class_5133)((class_5132.class_5133)method.invoke(null, new Object[0])));
                }
                catch (Exception e) {
                    JamLib.LOGGER.warn("Failed to register entity attributes for", entityClass.getName());
                    JamLib.LOGGER.warn(e.toString());
                }
                continue block8;
            }
        }
    }

    private static class_2960 getIdentifier(String modId, Field f) {
        String path = f.isAnnotationPresent(WithIdentifier.class) ? f.getAnnotation(WithIdentifier.class).value() : f.getName().toLowerCase(Locale.ROOT);
        return new class_2960(modId, path);
    }

    static {
        JamLibRegistry.addRegistry(class_5712.class, class_2378.field_28264);
        JamLibRegistry.addRegistry(class_3414.class, class_2378.field_11156);
        JamLibRegistry.addRegistry(class_3611.class, class_2378.field_11154);
        JamLibRegistry.addRegistry(class_1291.class, class_2378.field_11159);
        JamLibRegistry.addRegistry(class_2248.class, class_2378.field_11146);
        JamLibRegistry.addRegistry(class_1887.class, class_2378.field_11160);
        JamLibRegistry.addRegistry(class_1299.class, class_2378.field_11145);
        JamLibRegistry.addRegistry(class_1792.class, class_2378.field_11142);
        JamLibRegistry.addRegistry(class_1842.class, class_2378.field_11143);
        JamLibRegistry.addRegistry(class_2396.class, class_2378.field_11141);
        JamLibRegistry.addRegistry(class_2591.class, class_2378.field_11137);
        JamLibRegistry.addRegistry(class_1535.class, class_2378.field_11150);
        JamLibRegistry.addRegistry(class_2960.class, class_2378.field_11158);
        JamLibRegistry.addRegistry(class_2806.class, class_2378.field_16643);
        JamLibRegistry.addRegistry(class_3825.class, class_2378.field_16792);
        JamLibRegistry.addRegistry(class_4995.class, class_2378.field_23398);
        JamLibRegistry.addRegistry(class_3917.class, class_2378.field_17429);
        JamLibRegistry.addRegistry(class_3956.class, class_2378.field_17597);
        JamLibRegistry.addRegistry(class_1865.class, class_2378.field_17598);
        JamLibRegistry.addRegistry(class_5134.class, class_2378.field_23781);
        JamLibRegistry.addRegistry(class_5717.class, class_2378.field_28265);
        JamLibRegistry.addRegistry(class_2314.class, class_2378.field_38000);
        JamLibRegistry.addRegistry(class_3448.class, class_2378.field_11152);
        JamLibRegistry.addRegistry(class_3854.class, class_2378.field_17166);
        JamLibRegistry.addRegistry(class_3852.class, class_2378.field_17167);
        JamLibRegistry.addRegistry(class_4158.class, class_2378.field_18792);
        JamLibRegistry.addRegistry(class_4140.class, class_2378.field_18793);
        JamLibRegistry.addRegistry(class_4149.class, class_2378.field_18794);
        JamLibRegistry.addRegistry(class_4170.class, class_2378.field_18795);
        JamLibRegistry.addRegistry(class_4168.class, class_2378.field_18796);
        JamLibRegistry.addRegistry(class_5338.class, class_2378.field_25293);
        JamLibRegistry.addRegistry(class_5339.class, class_2378.field_25294);
        JamLibRegistry.addRegistry(class_5342.class, class_2378.field_25299);
        JamLibRegistry.addRegistry(class_5657.class, class_2378.field_28008);
        JamLibRegistry.addRegistry(class_5650.class, class_2378.field_28009);
        JamLibRegistry.addRegistry(class_5669.class, class_2378.field_28010);
        JamLibRegistry.addRegistry(class_5864.class, class_2378.field_29076);
        JamLibRegistry.addRegistry(class_6018.class, class_2378.field_33093);
        JamLibRegistry.addRegistry(class_6123.class, class_2378.field_33095);
        JamLibRegistry.addRegistry(class_6647.class, class_2378.field_35090);
        JamLibRegistry.addRegistry(class_2939.class, class_2378.field_11157);
        JamLibRegistry.addRegistry(class_3031.class, class_2378.field_11138);
        JamLibRegistry.addRegistry(class_6875.class, class_2378.field_36467);
        JamLibRegistry.addRegistry(class_3773.class, class_2378.field_16645);
        JamLibRegistry.addRegistry(class_7151.class, class_2378.field_16644);
        JamLibRegistry.addRegistry(class_6798.class, class_2378.field_35760);
        JamLibRegistry.addRegistry(class_4652.class, class_2378.field_21445);
        JamLibRegistry.addRegistry(class_4648.class, class_2378.field_21447);
        JamLibRegistry.addRegistry(class_5142.class, class_2378.field_23782);
        JamLibRegistry.addRegistry(class_7388.class, class_2378.field_38807);
        JamLibRegistry.addRegistry(class_4663.class, class_2378.field_21448);
        JamLibRegistry.addRegistry(class_5202.class, class_2378.field_24331);
        JamLibRegistry.addRegistry(class_4663.class, class_2378.field_21448);
        JamLibRegistry.addRegistry(class_3816.class, class_2378.field_16793);
        JamLibRegistry.addRegistry(class_7375.class, class_2378.field_38803);
        JamLibRegistry.addRegistry(class_7106.class, class_2378.field_38805);
        JamLibRegistry.addRegistry(class_2582.class, class_2378.field_39208);
        JamLibRegistry.addRegistry(class_7444.class, class_2378.field_39210);
    }
}

