/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkChannel;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.JecaItem;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.LPlaceholder;
import me.towdium.jecalculation.events.GuiScreenEventHandler;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.network.packets.PCalculator;
import me.towdium.jecalculation.network.packets.PEdit;
import me.towdium.jecalculation.network.packets.PRecord;
import me.towdium.jecalculation.utils.Utilities;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_6328;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@class_6328
@ParametersAreNonnullByDefault
public class JustEnoughCalculation {
    public static final String MODID = "jecalculation";
    public static final String MODNAME = "Just Enough Calculation";
    public static NetworkChannel network;
    public static Logger logger;

    public JustEnoughCalculation() {
        JecaItem.register();
        JustEnoughCalculation.registerEvents();
        if (Platform.getEnv() == EnvType.CLIENT) {
            JustEnoughCalculation.registerClientEvents();
        }
        Utilities.config().mkdirs();
    }

    private static void registerEvents() {
        LifecycleEvent.SETUP.register(JustEnoughCalculation::setupCommon);
        PlayerEvent.PLAYER_JOIN.register(Controller.Server::onJoin);
    }

    @Environment(value=EnvType.CLIENT)
    private static void registerClientEvents() {
        ClientLifecycleEvent.CLIENT_SETUP.register(JustEnoughCalculation::setupClient);
        JecaGui.registerEvents();
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(LPlaceholder::onLogOut);
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(Controller.Client::onLogOut);
    }

    public static void setupCommon() {
        Utilities.Greetings.send(logger, MODID);
        network = NetworkChannel.create((class_2960)new class_2960(MODID, "main"));
        network.register(PCalculator.class, PCalculator::write, PCalculator::new, PCalculator::handle);
        network.register(PEdit.class, PEdit::write, PEdit::new, PEdit::handle);
        network.register(PRecord.class, PRecord::write, PRecord::new, PRecord::handle);
        ILabel.initServer();
    }

    public static void setupClient(class_310 minecraft) {
        ILabel.initClient();
        Controller.loadFromLocal();
        KeyMappingRegistry.register((class_304)JecaGui.keyOpenGuiCraft);
        KeyMappingRegistry.register((class_304)JecaGui.keyOpenGuiMath);
    }

    static {
        logger = LogManager.getLogger((String)MODID);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        @Environment(value=EnvType.CLIENT)
        public static GuiScreenEventHandler GUI_HANDLER = new GuiScreenEventHandler();
    }
}

