/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.LContext;
import me.towdium.jecalculation.data.label.labels.LItemStack;
import me.towdium.jecalculation.data.label.labels.LStack;
import me.towdium.jecalculation.utils.wrappers.Wrapper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6328;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;

@class_6328
@ParametersAreNonnullByDefault
public abstract class LTag<T>
extends LContext<T> {
    public static final String KEY_NAME = "name";
    protected class_6862<T> name;

    public LTag(class_6862<T> name) {
        this(name, 1L);
    }

    public LTag(class_6862<T> name, long amount) {
        super(amount, false);
        this.name = name;
    }

    public LTag(LTag<T> lt) {
        super(lt);
        this.name = lt.name;
    }

    public LTag(class_2487 nbt) {
        super(nbt);
        this.name = class_6862.method_40092((class_5321)this.getRegistry().method_30517(), (class_2960)new class_2960(nbt.method_10558(KEY_NAME)));
    }

    protected abstract class_2378<T> getRegistry();

    public static boolean mergeSame(ILabel a, ILabel b) {
        if (a instanceof LTag) {
            LTag lodA = (LTag)a;
            if (b instanceof LTag) {
                LTag lodB = (LTag)b;
                return lodA.getName().equals(lodB.getName()) && lodA.getContext() == lodB.getContext();
            }
        }
        return false;
    }

    public static boolean mergeFuzzy(ILabel a, ILabel b) {
        if (a instanceof LTag) {
            LTag lt = (LTag)a;
            if (b instanceof LStack) {
                LStack ls = (LStack)b;
                return lt.getAmount() * ls.getAmount() < 0L && lt.getContext().matches(lt.name, ls);
            }
        }
        return false;
    }

    public static List<ILabel> suggest(List<ILabel> is, @Nullable Class<?> context) {
        return LTag.convert(is, true);
    }

    private static <T> List<ILabel> convert(List<ILabel> is, boolean biDir) {
        List iss = is.stream().filter(i -> i instanceof LStack).map(i -> (LStack)i).collect(Collectors.toList());
        if (iss.isEmpty() || iss.size() != is.size()) {
            return Collections.emptyList();
        }
        LStack lis = (LStack)iss.get(0);
        if (iss.stream().anyMatch(i -> i.getContext() != ((LStack)iss.get(0)).getContext())) {
            return Collections.emptyList();
        }
        HashSet ids = new HashSet();
        long amount = lis.getAmount();
        for (class_6862 i2 : lis.getContext().discover(lis)) {
            if (!LTag.check(i2, iss, biDir)) continue;
            ids.add(i2);
        }
        return ids.stream().map(i -> lis.getContext().create(i, amount)).collect(Collectors.toList());
    }

    public static List<ILabel> fallback(List<ILabel> is, @Nullable Class<?> context) {
        return LTag.convert(is, false);
    }

    private static <T> boolean check(class_6862<T> id, List<LStack<T>> labels, boolean biDir) {
        if (!id.method_41007(class_2378.field_25108)) {
            return false;
        }
        Stream<LStack<LStack>> ores = labels.get(0).getContext().discover(id);
        Optional<List> tag = class_2378.field_11142.method_40272().filter(pair -> ((class_6862)pair.getFirst()).equals((Object)id)).map(Pair::getSecond).findFirst().map(class_6885.class_6887::method_40239).map(s -> s.map(class_6880::comp_349)).map(Stream::toList);
        if (tag.isEmpty()) {
            return false;
        }
        Wrapper<Boolean> acceptable = new Wrapper<Boolean>(true);
        if (biDir) {
            ores.filter(ore -> labels.stream().noneMatch(ore::matches)).findAny().ifPresent(i -> {
                acceptable.value = false;
            });
        }
        labels.stream().filter(label -> label instanceof LItemStack).filter(label -> !((List)tag.get()).contains(((LItemStack)label).item)).findAny().ifPresent(i -> {
            acceptable.value = false;
        });
        return (Boolean)acceptable.value;
    }

    @Override
    public Object getRepresentation() {
        List list = this.getContext().discover(this.name).toList();
        if (list.isEmpty()) {
            return class_1799.field_8037;
        }
        long index = System.currentTimeMillis() / 1500L;
        return list.get((int)(index % (long)list.size())).getRepresentation();
    }

    @Override
    public boolean matches(Object l) {
        if (!(l instanceof LTag)) {
            return false;
        }
        LTag tag = (LTag)l;
        return tag.getContext() == this.getContext() && tag.name.equals(this.name) && super.matches(l);
    }

    @Override
    public abstract LTag<T> copy();

    @Override
    public class_2487 toNbt() {
        class_2487 ret = super.toNbt();
        ret.method_10582(KEY_NAME, this.name.comp_327().toString());
        return ret;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void getToolTip(List<String> existing, boolean detailed) {
        super.getToolTip(existing, detailed);
        existing.add("\u00a79\u00a7oJust Enough Calculation");
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() ^ super.hashCode();
    }

    public String getName() {
        return this.name.comp_327().toString();
    }
}

