/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.events;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.towdium.jecalculation.JecaItem;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.class_1661;
import net.minecraft.class_1799;

public class InventorySummary {
    protected List<ItemAmount> amounts = new ArrayList<ItemAmount>();

    public InventorySummary(class_1661 inventory) {
        inventory.field_7548.forEach(this::addItemStack);
        inventory.field_7547.forEach(this::addItemStack);
        inventory.field_7544.forEach(this::addItemStack);
    }

    protected void addItemStack(class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        Optional<ItemAmount> existingAmount = this.amounts.stream().filter(item -> this.isStackTypeEqual(item.stack, stack)).findFirst();
        if (existingAmount.isPresent()) {
            existingAmount.get().amount += stack.method_7947();
        } else {
            this.amounts.add(new ItemAmount(stack, stack.method_7947()));
        }
    }

    protected boolean isStackTypeEqual(class_1799 first, class_1799 second) {
        if (first.method_7909() != second.method_7909()) {
            return false;
        }
        if (first.method_7909() instanceof JecaItem && second.method_7909() instanceof JecaItem) {
            return first.method_7909() == second.method_7909();
        }
        return Utilities.areCapsCompatible(first, second);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventorySummary that = (InventorySummary)o;
        if (this.amounts.size() != that.amounts.size()) {
            return false;
        }
        return that.amounts.stream().allMatch(test -> {
            Optional<ItemAmount> thisAmount = this.amounts.stream().filter(item -> this.isStackTypeEqual(item.stack, test.stack)).findFirst();
            return thisAmount.isPresent() && test.amount == thisAmount.get().amount;
        });
    }

    public int hashCode() {
        return Objects.hash(this.amounts);
    }

    private static class ItemAmount {
        class_1799 stack;
        int amount;

        ItemAmount(class_1799 stack, int amount) {
            this.stack = stack;
            this.amount = amount;
        }
    }
}

