/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.fabric_like;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.towdium.jecalculation.JustEnoughCalculation;

public class JecaConfig {
    public static final Path PATH = Platform.getConfigFolder().resolve("jecalculation").resolve("common.json");
    public static boolean clientMode = false;

    public static void load() {
        try {
            if (!Files.exists(PATH, new LinkOption[0])) {
                JecaConfig.save();
                return;
            }
            if (!Files.isRegularFile(PATH, new LinkOption[0])) {
                Files.delete(PATH);
                JecaConfig.save();
                return;
            }
            JsonObject object = JsonParser.parseString((String)Files.readString(PATH)).getAsJsonObject();
            clientMode = object.get("clientMode").getAsBoolean();
        }
        catch (Exception e) {
            JustEnoughCalculation.logger.error("Can't load config file", (Throwable)e);
        }
    }

    public static void save() {
        JsonObject object = new JsonObject();
        object.addProperty("clientMode", Boolean.valueOf(clientMode));
        try {
            Files.writeString(PATH, (CharSequence)object.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

