/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.guis.GuiCraft;
import me.towdium.jecalculation.gui.guis.GuiMath;
import me.towdium.jecalculation.gui.guis.IGui;
import me.towdium.jecalculation.utils.GuiUtils;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Wrapper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5684;
import net.minecraft.class_6328;
import net.minecraft.class_757;

@ParametersAreNonnullByDefault
@class_6328
@Environment(value=EnvType.CLIENT)
public class JecaGui
extends class_465<JecaContainer> {
    public static final class_304 keyOpenGuiCraft = new class_304("jecalculation.key.gui_craft", -1, "jecalculation.key.category");
    public static final class_304 keyOpenGuiMath = new class_304("jecalculation.key.gui_math", -1, "jecalculation.key.category");
    public static final int COLOR_GUI_GREY = -6184543;
    public static final int COLOR_TEXT_RED = 0xFF0000;
    public static final int COLOR_TEXT_GREY = 0x404040;
    public static final int COLOR_TEXT_WHITE = 0xFFFFFF;
    public static final boolean ALWAYS_TOOLTIP = false;
    public static final String SEPARATOR = new String();
    public static final boolean IS_OSX = class_156.class_158.field_1137.equals((Object)class_156.method_668());
    public ILabel hand = ILabel.EMPTY;
    protected static JecaGui last;
    public static JecaGui override;
    protected JecaGui parent;
    protected class_4587 matrix;
    protected final Utilities.OffsetStack itemOffset = new Utilities.OffsetStack();
    protected final boolean isWidget;
    protected boolean preventRecipeScreen = false;
    public IGui root;

    public JecaGui(@Nullable JecaGui parent, IGui root, boolean isWidget) {
        this(parent, false, root, isWidget);
    }

    public JecaGui(@Nullable JecaGui parent, boolean acceptsTransfer, IGui root, boolean isWidget) {
        super((class_1703)(acceptsTransfer ? new ContainerTransfer() : new ContainerNonTransfer()), Utilities.getPlayer().method_31548(), (class_2561)class_2561.method_43470((String)""));
        this.parent = parent;
        this.root = root;
        this.isWidget = isWidget;
        if (this.field_2797 != null) {
            ((JecaContainer)this.field_2797).setGui(this);
        }
    }

    public static void registerEvents() {
        ClientGuiEvent.SET_SCREEN.register(JecaGui::onGuiOpen);
        ClientTooltipEvent.RENDER_PRE.register(JecaGui::onTooltip);
        ClientScreenInputEvent.MOUSE_CLICKED_PRE.register(JecaGui::onFocused);
        ClientScreenInputEvent.MOUSE_SCROLLED_PRE.register(JecaGui::onMouseScroll);
        ClientScreenInputEvent.MOUSE_CLICKED_PRE.register(JecaGui::onMouseClicked);
        ClientScreenInputEvent.MOUSE_DRAGGED_PRE.register(JecaGui::onMouseDragged);
        ClientScreenInputEvent.MOUSE_RELEASED_PRE.register(JecaGui::onMouseReleased);
        ClientRawInputEvent.KEY_PRESSED.register(JecaGui::onKeyPressed);
    }

    public void method_25423(class_310 minecraft, int width, int height) {
        if (!this.isWidget) {
            super.method_25423(minecraft, width, height);
            minecraft.field_1774.method_1462(true);
            return;
        }
        this.field_22787 = minecraft;
        this.field_22788 = minecraft.method_1480();
        this.field_22793 = minecraft.field_1772;
        this.field_22789 = width;
        this.field_22790 = height;
        this.method_25426();
        minecraft.field_1774.method_1462(true);
    }

    public void method_25432() {
        super.method_25432();
        Objects.requireNonNull(this.field_22787);
        this.field_22787.field_1774.method_1462(false);
    }

    public static int getMouseX() {
        JecaGui gui = JecaGui.getCurrent();
        class_310 mc = Objects.requireNonNull(gui.field_22787, "Internal error");
        int windowWidth = mc.method_22683().method_4480();
        if (windowWidth == 0) {
            return 0;
        }
        return (int)mc.field_1729.method_1603() * mc.method_22683().method_4486() / windowWidth - gui.field_2776;
    }

    public static int getMouseY() {
        JecaGui gui = JecaGui.getCurrent();
        class_310 mc = Objects.requireNonNull(gui.field_22787, "Internal error");
        int windowHeight = mc.method_22683().method_4507();
        if (windowHeight == 0) {
            return 0;
        }
        return (int)mc.field_1729.method_1604() * mc.method_22683().method_4502() / windowHeight - gui.field_2800;
    }

    public int getGlobalMouseX() {
        class_310 mc = Objects.requireNonNull(class_310.method_1551(), "Internal error");
        int width = mc.method_22683().method_4489();
        if (width == 0) {
            return 0;
        }
        if (IS_OSX) {
            width /= 2;
        }
        return (int)mc.field_1729.method_1603() * mc.method_22683().method_4486() / width - this.field_2776;
    }

    public int getGlobalMouseY() {
        class_310 mc = Objects.requireNonNull(class_310.method_1551(), "Internal error");
        int height = mc.method_22683().method_4506();
        if (height == 0) {
            return 0;
        }
        if (IS_OSX) {
            height /= 2;
        }
        return (int)mc.field_1729.method_1604() * mc.method_22683().method_4502() / height - this.field_2800;
    }

    public int getGuiLeft() {
        return this.field_2776;
    }

    public int getGuiTop() {
        return this.field_2800;
    }

    public int getYSize() {
        return this.field_2779;
    }

    public static EventResult onFocused(class_310 client, class_437 screen, double mouseX, double mouseY, int button) {
        if (!(screen instanceof JecaGui)) {
            return EventResult.pass();
        }
        JecaGui gui = JecaGui.getCurrent();
        int xMouse = JecaGui.getMouseX();
        int yMouse = JecaGui.getMouseY();
        gui.root.onMouseFocused(gui, xMouse, yMouse, button);
        ILabel e = Utilities.getLabelUnderMouse();
        if (e != ILabel.EMPTY) {
            gui.hand = e;
            gui.preventRecipeScreen = true;
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static EventResult onMouseClicked(class_310 client, class_437 screen, double mouseX, double mouseY, int button) {
        int yMouse;
        int xMouse;
        if (!(screen instanceof JecaGui)) {
            return EventResult.pass();
        }
        JecaGui gui = JecaGui.getCurrent();
        if (gui.root.onMouseClicked(gui, xMouse = JecaGui.getMouseX(), yMouse = JecaGui.getMouseY(), button)) {
            return EventResult.interruptFalse();
        }
        if (gui.hand != ILabel.EMPTY) {
            gui.hand = ILabel.EMPTY;
            gui.preventRecipeScreen = false;
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static EventResult onMouseScroll(class_310 client, class_437 screen, double mouseX, double mouseY, double amount) {
        if (!(screen instanceof JecaGui)) {
            return EventResult.pass();
        }
        JecaGui gui = JecaGui.getCurrent();
        int xMouse = JecaGui.getMouseX();
        int yMouse = JecaGui.getMouseY();
        if (amount != 0.0) {
            gui.root.onMouseScroll(gui, xMouse, yMouse, (int)amount);
        }
        return EventResult.pass();
    }

    public static EventResult onMouseReleased(class_310 minecraft, class_437 screen, double mouseX, double mouseY, int button) {
        if (!(screen instanceof JecaGui)) {
            return EventResult.pass();
        }
        JecaGui gui = JecaGui.getCurrent();
        int xMouse = JecaGui.getMouseX();
        int yMouse = JecaGui.getMouseY();
        gui.root.onMouseReleased(gui, xMouse, yMouse, button);
        return gui.hand == ILabel.EMPTY ? EventResult.pass() : EventResult.interruptFalse();
    }

    public static EventResult onMouseDragged(class_310 client, class_437 screen, double mouseX1, double mouseY1, int button, double mouseX2, double mouseY2) {
        if (!(screen instanceof JecaGui)) {
            return EventResult.pass();
        }
        JecaGui gui = JecaGui.getCurrent();
        int xMouse = JecaGui.getMouseX();
        int yMouse = JecaGui.getMouseY();
        gui.root.onMouseDragged(gui, xMouse, yMouse, (int)mouseX2, (int)mouseY2);
        return EventResult.pass();
    }

    public void method_37432() {
        this.root.onTick(this);
    }

    @Nullable
    public class_1735 getSlotUnderMouse() {
        Object rep;
        class_1277 i = new class_1277(new class_1799[]{class_1799.field_8037});
        class_1735 s = new class_1735((class_1263)i, 0, 0, 0);
        ILabel l = this.getLabelUnderMouse();
        Object object = rep = l == null ? null : l.getRepresentation();
        if (rep instanceof class_1799) {
            s.method_7673((class_1799)rep);
        }
        return s;
    }

    public static boolean mouseIn(int xPos, int yPos, int xSize, int ySize, int xMouse, int yMouse) {
        return xMouse > xPos && yMouse > yPos && xMouse <= xPos + xSize && yMouse <= yPos + ySize;
    }

    public static void displayGui(IGui root) {
        class_437 s = class_310.method_1551().field_1755;
        if (s instanceof JecaGui) {
            JecaGui.displayGui(root, true);
        } else {
            JecaGui.displayGui(root, null);
        }
    }

    public static void displayGui(IGui root, @Nullable JecaGui parent) {
        class_310 mc = class_310.method_1551();
        class_437 s = mc.field_1755;
        JecaGui gui = new JecaGui(parent, root.acceptsTransfer(), root, false);
        if (Utilities.isRecipeScreen(s) || s instanceof class_408) {
            override = gui;
        } else {
            Runnable runnable = () -> {
                root.onVisible(gui);
                last = gui;
                mc.method_1507((class_437)gui);
            };
            if (class_310.method_1551().method_18854()) {
                runnable.run();
            } else {
                class_310.method_1551().method_5382(runnable);
            }
        }
    }

    public static void displayGui(IGui root, boolean updateParent) {
        JecaGui current = JecaGui.getCurrent();
        JecaGui parent = updateParent ? current : current.parent;
        JecaGui.displayGui(root, parent);
    }

    public class_4587 getMatrix() {
        return this.matrix;
    }

    public void setMatrix(class_4587 matrix) {
        this.matrix = matrix;
    }

    public Utilities.OffsetStack getItemOffsetStack() {
        return this.itemOffset;
    }

    public static JecaGui getCurrent() {
        class_437 gui = class_310.method_1551().field_1755;
        JecaGui ret = gui instanceof JecaGui ? (JecaGui)gui : null;
        Objects.requireNonNull(ret);
        return ret;
    }

    public static JecaGui getLast() {
        return last;
    }

    public static void displayParent() {
        JecaGui gui = JecaGui.getCurrent().parent;
        gui.root.onVisible(gui);
        last = gui;
        class_310.method_1551().method_1507((class_437)gui);
    }

    @Nullable
    public ILabel getLabelUnderMouse() {
        Wrapper<Object> l = new Wrapper<Object>(null);
        this.root.getLabelUnderMouse(this.getGlobalMouseX(), this.getGlobalMouseY(), l);
        return (ILabel)l.value;
    }

    public static EventResult onKeyPressed(class_310 minecraft, int keyCode, int scanCode, int action, int modifiers) {
        if (keyOpenGuiCraft.method_1434()) {
            JecaGui.openGuiCraft(null, 0);
        }
        if (keyOpenGuiMath.method_1434()) {
            JecaGui.openGuiMath(null, 0);
        }
        return EventResult.pass();
    }

    public static EventResult onTooltip(class_4587 poseStack, List<? extends class_5684> components, int x, int y) {
        if (class_310.method_1551().field_1755 instanceof JecaGui) {
            JecaGui gui = JecaGui.getCurrent();
            return gui.root.onTooltip(gui, x - gui.field_2776, y - gui.field_2800, new ArrayList<String>()) ? EventResult.interruptFalse() : EventResult.pass();
        }
        return EventResult.pass();
    }

    public static CompoundEventResult<class_437> onGuiOpen(class_437 screen) {
        if (override != null) {
            JecaGui.override.root.onVisible(override);
            last = override;
            JecaGui s = override;
            override = null;
            return CompoundEventResult.interruptTrue((Object)((Object)s));
        }
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof JecaGui) {
            JecaGui gui = (JecaGui)class_4372;
            if (gui.preventRecipeScreen && Utilities.isRecipeScreen(screen)) {
                gui.preventRecipeScreen = false;
                return CompoundEventResult.interruptFalse((Object)((Object)gui));
            }
        }
        return CompoundEventResult.pass();
    }

    @Environment(value=EnvType.CLIENT)
    public static int openGuiMath(@Nullable class_1799 is, int slot) {
        boolean ret = is == null && Controller.isServerActive();
        String s = "jecalculation.chat.server_mode";
        if (ret) {
            Utilities.getPlayer().method_7353((class_2561)class_2561.method_43471((String)s), false);
        } else {
            JecaGui.displayGui(new GuiMath(is, slot));
        }
        return ret ? 1 : 0;
    }

    @Environment(value=EnvType.CLIENT)
    public static int openGuiCraft(@Nullable class_1799 is, int slot) {
        boolean ret = is == null && Controller.isServerActive();
        String s = "jecalculation.chat.server_mode";
        if (ret) {
            Utilities.getPlayer().method_7353((class_2561)class_2561.method_43471((String)s), false);
        } else {
            JecaGui.displayGui(new GuiCraft(is, slot));
        }
        return ret ? 1 : 0;
    }

    public boolean method_25421() {
        return false;
    }

    protected void method_2389(class_4587 matrixStack, float partialTicks, int x, int y) {
        this.method_25420(matrixStack);
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.matrix = matrixStack;
        matrixStack.method_22903();
        matrixStack.method_22904((double)this.field_2776, (double)this.field_2800, 0.0);
        this.root.onDraw(this, mouseX -= this.field_2776, mouseY -= this.field_2800);
        matrixStack.method_22909();
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, 0.0, 80.0);
        this.hand.drawLabel(this, mouseX + this.field_2776, mouseY + this.field_2800, true, true);
        matrixStack.method_22909();
        ArrayList<String> tooltip = new ArrayList<String>();
        this.root.onTooltip(this, mouseX, mouseY, tooltip);
        this.drawHoveringText(matrixStack, tooltip, mouseX + this.field_2776, mouseY + this.field_2800, this.field_22793);
    }

    public void drawHoveringText(class_4587 matrixStack, List<String> textLines, int x, int y, class_327 font) {
        if (!textLines.isEmpty()) {
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.enableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            matrixStack.method_22903();
            matrixStack.method_22904(0.0, 0.0, 400.0);
            int i = 0;
            int separators = 0;
            for (String s : textLines) {
                int j = this.field_22793.method_1727(s);
                if (j > i) {
                    i = j;
                }
                if (s != SEPARATOR) continue;
                ++separators;
            }
            if (textLines.get(textLines.size() - 1) == SEPARATOR) {
                --separators;
            }
            int l1 = x + 12;
            int i2 = y - 12;
            int k = 8 + (textLines.size() - separators - 1) * 10 + 2 * separators;
            if (l1 + i > this.field_22789) {
                l1 -= 28 + i;
            }
            if (i2 + k + 6 > this.field_22790) {
                i2 = this.field_22790 - k - 6;
            }
            this.method_25296(matrixStack, l1 - 3, i2 - 4, l1 + i + 3, i2 - 3, -267386864, -267386864);
            this.method_25296(matrixStack, l1 - 3, i2 + k + 3, l1 + i + 3, i2 + k + 4, -267386864, -267386864);
            this.method_25296(matrixStack, l1 - 3, i2 - 3, l1 + i + 3, i2 + k + 3, -267386864, -267386864);
            this.method_25296(matrixStack, l1 - 4, i2 - 3, l1 - 3, i2 + k + 3, -267386864, -267386864);
            this.method_25296(matrixStack, l1 + i + 3, i2 - 3, l1 + i + 4, i2 + k + 3, -267386864, -267386864);
            this.method_25296(matrixStack, l1 - 3, i2 - 3 + 1, l1 - 3 + 1, i2 + k + 3 - 1, 0x505000FF, 1344798847);
            this.method_25296(matrixStack, l1 + i + 2, i2 - 3 + 1, l1 + i + 3, i2 + k + 3 - 1, 0x505000FF, 1344798847);
            this.method_25296(matrixStack, l1 - 3, i2 - 3, l1 + i + 3, i2 - 3 + 1, 0x505000FF, 0x505000FF);
            this.method_25296(matrixStack, l1 - 3, i2 + k + 2, l1 + i + 3, i2 + k + 3, 1344798847, 1344798847);
            for (String s1 : textLines) {
                if (s1 == SEPARATOR) {
                    i2 += 2;
                    continue;
                }
                font.method_1720(matrixStack, s1, (float)l1, (float)i2, -1);
                i2 += 10;
            }
            matrixStack.method_22909();
            RenderSystem.disableBlend();
            RenderSystem.enableTexture();
        }
    }

    public void drawResource(Resource r, int xPos, int yPos) {
        this.drawResource(r, xPos, yPos, 0xFFFFFF);
    }

    public void drawResource(Resource r, int xPos, int yPos, int color) {
        this.setColor(color);
        RenderSystem.setShaderTexture((int)0, (class_2960)r.getResourceLocation());
        this.method_25302(this.matrix, xPos, yPos, r.getXPos(), r.getYPos(), r.getXSize(), r.getYSize());
    }

    public void drawResourceContinuous(Resource r, int xPos, int yPos, int xSize, int ySize, int border) {
        this.drawResourceContinuous(r, xPos, yPos, xSize, ySize, border, border, border, border);
    }

    public void drawResourceContinuous(Resource r, int xPos, int yPos, int xSize, int ySize, int borderTop, int borderBottom, int borderLeft, int borderRight) {
        GuiUtils.drawContinuousTexturedBox(this.matrix, r.getResourceLocation(), xPos, yPos, r.getXPos(), r.getYPos(), xSize, ySize, r.getXSize(), r.getYSize(), borderTop, borderBottom, borderLeft, borderRight, 0.0f);
    }

    private void setColor(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(~(color >> 24) & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void drawFluid(class_3611 f, int xPos, int yPos, int xSize, int ySize) {
        class_1058 fluidTexture = FluidStackHooks.getStillTexture((class_3611)f);
        if (fluidTexture == null) {
            fluidTexture = FluidStackHooks.getStillTexture((class_3611)class_3612.field_15910);
        }
        if (fluidTexture == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        this.setColor(FluidStackHooks.getColor((class_3611)f) & 0xFFFFFF);
        JecaGui.method_25298((class_4587)this.matrix, (int)xPos, (int)yPos, (int)0, (int)xSize, (int)ySize, (class_1058)fluidTexture);
    }

    public void drawRectangle(int xPos, int yPos, int xSize, int ySize, int color) {
        JecaGui.method_25294((class_4587)this.matrix, (int)xPos, (int)yPos, (int)(xPos + xSize), (int)(yPos + ySize), (int)color);
    }

    public int getStringWidth(String s) {
        return this.field_22793.method_1727(s);
    }

    public void drawSplitText(float xPos, float yPos, int width, FontType f, String s) {
        this.drawSplitText(xPos, yPos, f, Utilities.I18n.wrap(s, width));
    }

    public void drawSplitText(float xPos, float yPos, FontType f, List<String> ss) {
        this.drawText(xPos, yPos, f, () -> {
            int y = 0;
            for (String i : ss) {
                if (f.shadow) {
                    this.field_22793.method_1720(this.matrix, i, 0.0f, (float)y, f.color);
                } else {
                    this.field_22793.method_1729(this.matrix, i, 0.0f, (float)y, f.color);
                }
                Objects.requireNonNull(this.field_22793);
                y += 9 + 1;
            }
        });
    }

    public void drawText(float xPos, float yPos, FontType f, String s) {
        this.drawText(xPos, yPos, Integer.MAX_VALUE, f, s);
    }

    public void drawText(float xPos, float yPos, int width, FontType f, String s) {
        this.drawText(xPos, yPos, f, () -> {
            Object str = s;
            int strWidth = f.getTextWidth((String)str);
            int ellipsisWidth = f.getTextWidth("...");
            if (strWidth > width && strWidth > ellipsisWidth) {
                str = f.trimToWidth((String)str, width - ellipsisWidth).trim() + "...";
            }
            if (f.shadow) {
                this.field_22793.method_1720(this.matrix, (String)str, 0.0f, 0.0f, f.color);
            } else {
                this.field_22793.method_1729(this.matrix, (String)str, 0.0f, 0.0f, f.color);
            }
        });
    }

    private void drawText(float xPos, float yPos, FontType f, Runnable r) {
        this.getMatrix().method_22903();
        this.getMatrix().method_22904((double)xPos, (double)yPos, 200.0);
        if (f.half) {
            this.getMatrix().method_22905(0.5f, 0.5f, 1.0f);
        }
        r.run();
        this.getMatrix().method_22909();
    }

    public void drawItemStack(int xPos, int yPos, class_1799 is, boolean centred, boolean hand) {
        if (centred) {
            xPos -= 8;
            yPos -= 8;
        }
        int x = hand ? xPos : this.field_2776 + xPos;
        int y = hand ? yPos : this.field_2800 + yPos;
        RenderSystem.enableDepthTest();
        this.field_22788.method_4023(is, x + this.itemOffset.x(), y + this.itemOffset.y());
        this.field_22788.method_4022(this.field_22793, is, this.field_2776 + xPos, this.field_2800 + yPos, null);
        RenderSystem.disableDepthTest();
    }

    protected void method_25426() {
        this.field_2776 = (this.field_22789 - this.field_2792) / 2;
        this.field_2800 = (this.field_22790 - this.field_2779) / 2;
    }

    public boolean method_25400(char ch, int modifier) {
        return this.root.onChar(this, ch, modifier) || super.method_25400(ch, modifier);
    }

    public boolean method_25404(int key, int scan, int modifier) {
        if (key == 256 && this.hand != ILabel.EMPTY) {
            this.hand = ILabel.EMPTY;
        } else if (!this.root.onKeyPressed(this, key, modifier)) {
            if (key == 256 && this.parent != null) {
                JecaGui.displayParent();
            } else {
                return super.method_25404(key, scan, modifier);
            }
        }
        return true;
    }

    public boolean method_16803(int key, int scan, int modifier) {
        return this.root.onKeyReleased(this, key, modifier) || super.method_16803(key, scan, modifier);
    }

    @Environment(value=EnvType.CLIENT)
    public static class ContainerTransfer
    extends JecaContainer {
    }

    @Environment(value=EnvType.CLIENT)
    public static class ContainerNonTransfer
    extends JecaContainer {
    }

    @Environment(value=EnvType.CLIENT)
    public static class JecaContainer
    extends class_1703 {
        JecaGui gui;

        protected JecaContainer() {
            super(null, 0);
        }

        public JecaGui getGui() {
            return this.gui;
        }

        public void setGui(JecaGui gui) {
            this.gui = gui;
        }

        public class_1799 method_7601(class_1657 player, int index) {
            return null;
        }

        public boolean method_7597(class_1657 playerIn) {
            return true;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FontType {
        public static final FontType SHADOW = new FontType(0xFFFFFF, true, false, false);
        public static final FontType PLAIN = new FontType(0x404040, false, false, false);
        public static final FontType RAW = new FontType(0x404040, false, false, true);
        public static final FontType HALF = new FontType(0xFFFFFF, true, true, true);
        public int color;
        public boolean shadow;
        public boolean half;
        public boolean raw;
        private final class_327 font;

        public FontType(int color, boolean shadow, boolean half, boolean raw) {
            this.font = class_310.method_1551().field_1772;
            this.color = color;
            this.shadow = shadow;
            this.half = half;
            this.raw = raw;
        }

        public int getTextWidth(String s) {
            return (int)Math.ceil((float)this.font.method_1727(s) * (this.half ? 0.5f : 1.0f));
        }

        public int getTextHeight() {
            Objects.requireNonNull(this.font);
            return (int)Math.ceil(9.0f * (this.half ? 0.5f : 1.0f));
        }

        public String trimToWidth(String s, int i) {
            return this.font.method_27523(s, i * (this.half ? 2 : 1));
        }
    }
}

