/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.guis;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.structure.Recipe;
import me.towdium.jecalculation.data.structure.Recipes;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.guis.Gui;
import me.towdium.jecalculation.gui.guis.GuiImport;
import me.towdium.jecalculation.gui.guis.GuiRecipe;
import me.towdium.jecalculation.gui.widgets.WButton;
import me.towdium.jecalculation.gui.widgets.WButtonIcon;
import me.towdium.jecalculation.gui.widgets.WHelp;
import me.towdium.jecalculation.gui.widgets.WIcon;
import me.towdium.jecalculation.gui.widgets.WLabel;
import me.towdium.jecalculation.gui.widgets.WLabelScroll;
import me.towdium.jecalculation.gui.widgets.WOverlay;
import me.towdium.jecalculation.gui.widgets.WPanel;
import me.towdium.jecalculation.gui.widgets.WSearch;
import me.towdium.jecalculation.gui.widgets.WSwitcher;
import me.towdium.jecalculation.gui.widgets.WTextField;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Trio;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
@Environment(value=EnvType.CLIENT)
public class GuiSearch
extends Gui {
    IdentityHashMap<ILabel, Trio<Recipe, String, Integer>> recipes;
    WLabelScroll labels = new WLabelScroll(7, 51, 8, 6, false).setLsnrClick((i, v) -> {
        ILabel l = i.get((int)v).getLabel();
        if (l != ILabel.EMPTY) {
            this.setOverlay(new Overlay(i.get((int)v)));
        }
    });
    WSwitcher group;
    WTextField text = new WTextField(7, 25, 119);
    WButton no = new WButtonIcon(130, 25, 20, 20, Resource.BTN_NO, "common.cancel").setListener(i -> this.setRename(false));
    WButton yes = new WButtonIcon(149, 25, 20, 20, Resource.BTN_YES, "search.confirm").setDisabled(true).setListener(i -> {
        Controller.renameGroup(this.group.getText(), this.text.getText());
        this.refreshGroups();
        this.group.setText(this.text.getText());
        this.refreshDisplay();
        this.setRename(false);
    });
    WButton exportN = new WButtonIcon(111, 25, 20, 20, Resource.BTN_EXPORT_N, "search.export_all").setListener(i -> Controller.export());
    WButton export1 = new WButtonIcon(111, 25, 20, 20, Resource.BTN_EXPORT_1, "search.export_group").setListener(i -> Controller.export(this.group.getText()));
    WButton deleteN = new WButtonIcon(130, 25, 20, 20, Resource.BTN_DELETE_N, "search.delete_all").setListener(i -> {
        Controller.getGroups().forEach(Controller::removeGroup);
        this.refreshGroups();
        this.refreshDisplay();
    });
    WButton delete1 = new WButtonIcon(130, 25, 20, 20, Resource.BTN_DELETE_1, "search.delete_group").setListener(i -> {
        Controller.removeGroup(this.group.getText());
        this.refreshGroups();
        this.refreshDisplay();
    });
    WButton inport = new WButtonIcon(92, 25, 20, 20, Resource.BTN_IMPORT, "search.import").setListener(i -> JecaGui.displayGui(new GuiImport()));
    WButton rename = new WButtonIcon(149, 25, 20, 20, Resource.BTN_EDIT, "search.rename").setListener(i -> this.setRename(true));
    WIcon icon = new WIcon(7, 25, 20, 20, Resource.ICN_TEXT, "common.search");
    WSearch search = new WSearch(26, 25, 61, this.labels);
    List<ILabel> identifiers;

    public GuiSearch() {
        this.text.setListener(i -> {
            String s = i.getText();
            this.yes.setDisabled(s.isEmpty() || Controller.getGroups().contains(s));
        });
        this.add(new WHelp("search"), new WPanel());
        this.add(this.labels, this.icon, this.search, this.inport, this.exportN, this.deleteN, this.rename);
    }

    private void generate() {
        this.identifiers = new ArrayList<ILabel>();
        this.recipes = new IdentityHashMap();
        Consumer<Trio> add = i -> {
            ILabel id = ((Recipe)i.one).getRep();
            this.recipes.put(id, (Trio<Recipe, String, Integer>)i);
            this.identifiers.add(id);
        };
        Recipes.RecipeIterator it = this.group.getIndex() == 0 ? Controller.recipeIterator() : Controller.recipeIterator(this.group.getText());
        it.stream().map(j -> new Trio<Recipe, String, Integer>((Recipe)j, it.getGroup(), it.getIndex())).forEach(add);
    }

    @Override
    public boolean onKeyPressed(JecaGui gui, int key, int modifier) {
        if (key == 256 && this.contains(this.text)) {
            this.setRename(false);
            return true;
        }
        return super.onKeyPressed(gui, key, modifier);
    }

    public void refreshDisplay() {
        this.remove(this.exportN, this.export1, this.deleteN, this.delete1);
        this.generate();
        this.labels.setLabels(this.identifiers);
        this.add(this.group.getIndex() == 0 ? this.exportN : this.export1);
        this.add(this.group.getIndex() == 0 ? this.deleteN : this.delete1);
        this.exportN.setDisabled(this.identifiers.size() == 0);
        this.deleteN.setDisabled(this.identifiers.size() == 0);
        this.rename.setDisabled(this.group.getIndex() == 0);
    }

    public void refreshGroups() {
        int index;
        this.remove(this.group);
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(Utilities.I18n.get("gui.search.all", new Object[0]));
        groups.addAll(Controller.getGroups());
        int n = index = this.group == null ? 0 : this.group.getIndex();
        if (index >= groups.size()) {
            index = groups.size() - 1;
        }
        this.group = new WSwitcher(7, 7, 162, groups).setListener(i -> this.refreshDisplay());
        this.group.setIndex(index);
        this.add(this.group);
    }

    @Override
    public void onVisible(JecaGui gui) {
        this.refreshGroups();
        this.refreshDisplay();
    }

    private void setRename(boolean b) {
        this.group.setDisabled(b);
        if (b) {
            this.add(this.yes, this.no, this.text);
            this.remove(this.icon, this.search, this.inport, this.export1, this.exportN, this.rename);
        } else {
            this.add(this.icon, this.search, this.inport, this.group.getIndex() == 0 ? this.exportN : this.export1, this.rename);
            this.remove(this.yes, this.no, this.text);
            this.text.setText("");
            this.yes.setDisabled(true);
        }
    }

    class Overlay
    extends WOverlay {
        public Overlay(WLabel l) {
            Trio<Recipe, String, Integer> recipe = GuiSearch.this.recipes.get(l.getLabel());
            int x = l.xPos - 1;
            int y = l.yPos - 1;
            this.add(new WPanel(x - 5, y - 5, 72, 30));
            this.add(new WLabel(x, y, 20, 20, false).setLabel(l.getLabel()));
            this.add(new WButtonIcon(x + 23, y, 20, 20, Resource.BTN_EDIT, "search.edit").setListener(i -> {
                JecaGui.displayGui(new GuiRecipe((String)recipe.two, (int)((Integer)recipe.three)));
                GuiSearch.this.setOverlay(null);
            }));
            this.add(new WButtonIcon(x + 42, y, 20, 20, Resource.BTN_NO, "search.delete").setListener(i -> {
                Controller.removeRecipe((String)recipe.two, (Integer)recipe.three);
                GuiSearch.this.setOverlay(null);
                GuiSearch.this.refreshGroups();
                GuiSearch.this.refreshDisplay();
            }));
        }
    }
}

