/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.models.DragOffset;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
@Environment(value=EnvType.CLIENT)
public class WDrag
implements IWidget {
    public int xPos;
    public int yPos;
    public int xSize;
    public int ySize;
    protected int dragOffsetX = 0;
    protected int dragOffsetY = 0;
    protected int dragConsumerX = 0;
    protected int dragConsumerY = 0;
    protected boolean isDragging = false;
    protected IWidget.ListenerAction<? super WDrag> dragStartListener = null;
    protected IWidget.ListenerValue<? super WDrag, DragOffset> dragMoveListener = null;
    protected IWidget.ListenerAction<? super WDrag> dragStopListener = null;

    public WDrag(int xPos, int yPos, int xSize, int ySize) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    @Override
    public boolean onDraw(JecaGui gui, int xMouse, int yMouse) {
        boolean isHovering = this.mouseIn(xMouse, yMouse);
        Resource texture = this.getResource(isHovering);
        gui.drawResourceContinuous(texture, this.xPos, this.yPos, this.xSize, this.ySize, 1, 1, 1, 1);
        int newMouseX = gui.getGlobalMouseX();
        int newMouseY = gui.getGlobalMouseY();
        if (this.isDragging && this.dragMoveListener != null && (this.dragOffsetX != newMouseX || this.dragOffsetY != newMouseY)) {
            int deltaX = newMouseX - this.dragOffsetX;
            int deltaY = newMouseY - this.dragOffsetY;
            this.dragMoveListener.invoke(this, new DragOffset(this.dragConsumerX + deltaX, this.dragConsumerY + deltaY));
        }
        return false;
    }

    protected Resource getResource(boolean isHovering) {
        if (isHovering) {
            return Resource.WGT_DRAG_F;
        }
        return Resource.WGT_DRAG_N;
    }

    public WDrag setDragStartListener(IWidget.ListenerAction<? super WDrag> listener) {
        this.dragStartListener = listener;
        return this;
    }

    public WDrag setDragMoveListener(IWidget.ListenerValue<? super WDrag, DragOffset> listener) {
        this.dragMoveListener = listener;
        return this;
    }

    public WDrag setDragStopListener(IWidget.ListenerAction<? super WDrag> listener) {
        this.dragStopListener = listener;
        return this;
    }

    public void setConsumerOffset(int x, int y) {
        this.dragConsumerX = x;
        this.dragConsumerY = y;
    }

    @Override
    public boolean onMouseClicked(JecaGui gui, int xMouse, int yMouse, int button) {
        if (!this.mouseIn(xMouse, yMouse)) {
            return false;
        }
        this.startDragging(gui);
        return true;
    }

    @Override
    public boolean onMouseReleased(JecaGui gui, int xMouse, int yMouse, int button) {
        if (!this.isDragging) {
            return false;
        }
        this.stopDragging();
        return true;
    }

    protected void startDragging(JecaGui gui) {
        this.dragOffsetX = gui.getGlobalMouseX();
        this.dragOffsetY = gui.getGlobalMouseY();
        this.isDragging = true;
        if (this.dragStartListener != null) {
            this.dragStartListener.invoke(this);
        }
    }

    protected void stopDragging() {
        if (!this.isDragging) {
            return;
        }
        this.isDragging = false;
        if (this.dragStopListener != null) {
            this.dragStopListener.invoke(this);
        }
    }

    protected boolean mouseIn(int xMouse, int yMouse) {
        return JecaGui.mouseIn(this.xPos, this.yPos, this.xSize, this.ySize, xMouse, yMouse);
    }
}

