/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.fabric;

import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.api.event.fabric.FabricEvents;
import journeymap.client.event.handlers.ChatEventHandler;
import journeymap.client.event.handlers.ChunkMonitorHandler;
import journeymap.client.event.handlers.HudOverlayHandler;
import journeymap.client.event.handlers.KeyEventHandler;
import journeymap.client.event.handlers.PlayerConnectHandler;
import journeymap.client.event.handlers.PopupMenuEventHandler;
import journeymap.client.event.handlers.StateTickHandler;
import journeymap.client.event.handlers.TextureAtlasHandler;
import journeymap.client.event.handlers.WaypointBeaconHandler;
import journeymap.client.event.handlers.WorldEventHandler;
import journeymap.client.ui.fullscreen.Fullscreen;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class FabricEventHandlerManager {
    private static FabricEventHandlerManager INSTANCE;
    private final WorldEventHandler worldEventHandler = new WorldEventHandler();
    private final WaypointBeaconHandler waypointBeaconHandler = new WaypointBeaconHandler();
    private final TextureAtlasHandler textureAtlasHandler = new TextureAtlasHandler();
    private final StateTickHandler stateTickHandler = new StateTickHandler();
    private final PlayerConnectHandler playerConnectHandler = new PlayerConnectHandler();
    private final HudOverlayHandler hudOverlayHandler = new HudOverlayHandler();
    private final ChunkMonitorHandler chunkMonitorHandler = ChunkMonitorHandler.getInstance();
    private final ChatEventHandler chatEventHandler = new ChatEventHandler();
    private final PopupMenuEventHandler popupMenuEventHandler = new PopupMenuEventHandler();
    private final KeyEventHandler keyEventHandler = JourneymapClient.getInstance().getKeyEvents().getHandler();

    private FabricEventHandlerManager() {
        this.registerFabricEvents();
    }

    private void registerFabricEvents() {
        ClientTickEvents.END_CLIENT_TICK.register(listener -> this.stateTickHandler.onClientTick());
        FabricEvents.FULLSCREEN_POPUP_MENU_EVENT.register(event -> this.popupMenuEventHandler.onFullscreenPopupMenu(event.getPopupMenu(), (Fullscreen)event.getFullscreen()));
        FabricEvents.WAYPOINT_POPUP_MENU_EVENT.register(event -> this.popupMenuEventHandler.onWaypointPopupMenu(event.getPopupMenu(), event.getWaypoint().getId(), (Fullscreen)event.getFullscreen()));
    }

    public static FabricEventHandlerManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FabricEventHandlerManager();
        }
        return INSTANCE;
    }

    public void onWorldUnload(class_1936 world) {
        this.worldEventHandler.onUnload(world);
    }

    public void onRenderWorldLastEvent(class_4587 poseStack, boolean onlyBeacon) {
        this.waypointBeaconHandler.onRenderWorldLastEvent(poseStack, onlyBeacon);
    }

    public void onTextureStitched() {
        this.textureAtlasHandler.onTextureStitched();
    }

    public void onPlayerConnect(class_310 minecraft) {
        this.playerConnectHandler.onConnect();
    }

    public void onRenderOverlayDebug(List<String> leftText) {
        this.hudOverlayHandler.onRenderOverlayDebug(leftText);
    }

    public void onRenderOverlay(class_4587 poseStack) {
        poseStack.method_22903();
        this.hudOverlayHandler.onRenderOverlay(poseStack);
        poseStack.method_22909();
    }

    public boolean preOverlay(class_4587 poseStack) {
        return this.hudOverlayHandler.preOverlay(poseStack);
    }

    public void postOverlay(class_4587 poseStack) {
        this.hudOverlayHandler.postOverlay(poseStack);
    }

    public void onBlockUpdate(class_1936 world, class_2338 pos) {
        this.chunkMonitorHandler.onBlockUpdate(world, pos);
    }

    public void onChunkUpdate(class_1936 world, class_1923 pos) {
        this.chunkMonitorHandler.onChunkUpdate(world, pos);
    }

    public void onChunkLoad(class_1936 world, class_2791 chunkAccess) {
        this.chunkMonitorHandler.onChunkLoad(world, chunkAccess);
    }

    public class_2561 onClientChatEventReceived(class_2561 message) {
        return this.chatEventHandler.onClientChatEventReceived(message);
    }

    public boolean onChatEvent(String message) {
        return this.chatEventHandler.onChatEvent("/" + message);
    }

    public void keyPressEvent(int key) {
        this.keyEventHandler.onGameKeyboardEvent(key);
    }
}

