/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import java.awt.Color;
import journeymap.client.Constants;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class TextBox
extends class_342 {
    protected final String numericRegex;
    protected final boolean numeric;
    protected final boolean allowNegative;
    protected int minLength;
    protected Integer clampMin;
    protected Integer clampMax;
    private long lastClick = 0L;

    public TextBox(Object text, class_327 fontRenderer, int width, int height) {
        this(text, fontRenderer, width, height, false, false);
    }

    public TextBox(Object text, class_327 fontRenderer, int width, int height, boolean isNumeric, boolean negative) {
        super(fontRenderer, 0, 0, width, height, (class_2561)Constants.getStringTextComponent(text.toString()));
        this.method_1880(256);
        this.method_1852(text.toString());
        this.numeric = isNumeric;
        this.allowNegative = negative;
        String regex = null;
        if (this.numeric) {
            regex = this.allowNegative ? "[^-?\\d]" : "[^\\d]";
        }
        this.numericRegex = regex;
    }

    public void setClamp(Integer min, Integer max) {
        this.clampMin = min;
        this.clampMax = max;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void method_1867(@NotNull String par1Str) {
        if (this.numeric) {
            String fixed = par1Str.replaceAll(this.numericRegex, "");
            if (this.allowNegative) {
                par1Str = "-".equals(fixed) && this.method_1881() != 0 && !this.isAllSelected() ? "" : fixed;
            }
        }
        super.method_1867(par1Str);
    }

    public void setText(Object object) {
        super.method_1852(object.toString());
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean hasMinLength() {
        String text = this.method_1882();
        int textLen = text == null ? 0 : text.length();
        return this.minLength <= textLen;
    }

    public boolean method_25400(char c, int key) {
        boolean typed = false;
        if (this.method_25367()) {
            typed = super.method_25400(c, key);
            if (this.numeric && typed) {
                this.clamp();
            }
        }
        return typed;
    }

    public boolean method_25404(int key, int value, int modifier) {
        boolean pressed = false;
        if (this.method_25367()) {
            pressed = super.method_25404(key, value, modifier);
        }
        return pressed;
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        return super.method_25406(mouseX, mouseY, mouseButton);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.method_25405(mouseX, mouseY)) {
            if (this.method_25370() && button == 0) {
                int i = class_3532.method_15357((double)mouseX) - this.field_22760;
                if (this.method_1851()) {
                    i -= 4;
                }
                String s = this.field_2105.method_27523(this.method_1882().substring(this.field_2103), this.method_1859());
                this.method_1884(this.field_2105.method_27523(s, i).length() + this.field_2103);
                return true;
            }
            return super.method_25403(mouseX, mouseY, button, mouseDX, mouseDY);
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        super.method_1884(super.method_1881());
        if (this.method_25405(mouseX, mouseY) && super.method_25402(mouseX, mouseY, mouseButton)) {
            long sysTime = class_156.method_658();
            boolean doubleClick = sysTime - this.lastClick < 200L;
            this.lastClick = sysTime;
            if (doubleClick) {
                this.selectAll();
            }
            return true;
        }
        this.method_1876(false);
        return false;
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
    }

    public void selectAll() {
        this.method_1872();
        this.method_1884(0);
    }

    public boolean isAllSelected() {
        return this.method_1882().equals(this.method_1866());
    }

    public void method_1875(int position) {
        super.method_1875(position);
    }

    public boolean isHovered() {
        return this.field_22762;
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(poseStack, mouseX, mouseY, partialTicks);
        if (this.method_1885() && !this.hasMinLength()) {
            int red = Color.red.getRGB();
            int x1 = this.getX() - 1;
            int y1 = this.getY() - 1;
            int x2 = x1 + this.method_25368() + 1;
            int y2 = y1 + this.method_25364() + 1;
            TextBox.method_25294((class_4587)poseStack, (int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)red);
            TextBox.method_25294((class_4587)poseStack, (int)x1, (int)y2, (int)x2, (int)(y2 + 1), (int)red);
            TextBox.method_25294((class_4587)poseStack, (int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)red);
            TextBox.method_25294((class_4587)poseStack, (int)x2, (int)y1, (int)(x2 + 1), (int)y2, (int)red);
        }
    }

    public Integer clamp() {
        return this.clamp(this.method_1882());
    }

    public Integer clamp(String text) {
        int val;
        if (!this.numeric) {
            return null;
        }
        if (this.clampMin != null) {
            if (text == null || text.length() == 0 || text.equals("-")) {
                return null;
            }
            try {
                val = Math.max(this.clampMin, Integer.parseInt(text));
            }
            catch (Exception e) {
                return this.clampMin;
            }
            if (this.clampMax != null) {
                try {
                    val = Math.min(this.clampMax, val);
                }
                catch (Exception e) {
                    return this.clampMax;
                }
            }
        } else {
            try {
                val = Integer.parseInt(text);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (val != Integer.parseInt(text)) {
            this.setText(val);
        }
        return val;
    }

    public int getX() {
        return this.field_22760;
    }

    public void method_16872(int x) {
        this.field_22760 = x;
    }

    public int getY() {
        return this.field_22761;
    }

    public void setY(int y) {
        this.field_22761 = y;
    }

    public int method_25368() {
        return this.field_22758;
    }

    public void method_25358(int w) {
        this.field_22758 = w;
    }

    public int method_25364() {
        return this.field_22759;
    }

    public void setHeight(int h) {
        this.field_22759 = h;
    }

    public int getCenterX() {
        return this.getX() + this.method_25368() / 2;
    }

    public int getMiddleY() {
        return this.getY() + this.method_25364() / 2;
    }

    public int getBottomY() {
        return this.getY() + this.method_25364();
    }

    public int getRightX() {
        return this.getX() + this.method_25368();
    }
}

