/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import journeymap.common.CommonConstants;
import journeymap.common.JM;
import journeymap.common.LoaderHooks;
import journeymap.common.command.CreateWaypoint;
import journeymap.common.config.AdminAccessConfig;
import journeymap.common.config.fabric.FabricConfig;
import journeymap.common.events.fabric.FabricServerEvents;
import journeymap.common.nbt.WorldIdData;
import journeymap.common.network.data.NetworkHandler;
import journeymap.common.network.data.Side;
import journeymap.common.network.dispatch.NetworkDispatcher;
import journeymap.common.network.fabric.FabricNetworkHandler;
import journeymap.common.network.handler.PacketHandler;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.version.Version;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Journeymap
implements ModInitializer {
    public static final Version MINIMUM_SERVER_ACCEPTABLE_VERSION = new Version(5, 8, 1);
    public static final Version MINIMUM_CLIENT_ACCEPTABLE_VERSION = new Version(5, 8, 1);
    public static final Version DEV_VERSION = new Version(5, 8, 1, "dev");
    public static final String MOD_ID = "journeymap";
    public static final String SHORT_MOD_NAME = JM.SHORT_MOD_NAME;
    public static boolean DEV_MODE = false;
    public static final Version JM_VERSION = Version.from(JM.VERSION_MAJOR, JM.VERSION_MINOR, JM.VERSION_MICRO, JM.VERSION_PATCH, DEV_VERSION);
    public static final String LOADER_VERSION = JM.LOADER_VERSION;
    public static final String LOADER_NAME = JM.LOADER_NAME;
    public static final String MC_VERSION = JM.MC_VERSION;
    public static final String WEBSITE_URL = JM.WEBSITE_URL;
    public static final String DOWNLOAD_URL = JM.DOWNLOAD_URL;
    public static final String VERSION_URL = JM.VERSION_URL;
    private static Journeymap instance;
    private NetworkDispatcher dispatcher;
    private PacketHandler handler;
    private MinecraftServer server;
    private NetworkHandler networkHandler;

    public Journeymap() {
        instance = this;
    }

    public void onInitialize() {
        FabricServerEvents.getInstance();
        Journeymap.getLogger().info("Initializing ServerSide Packet Registries");
        this.handler = new PacketHandler();
        this.networkHandler = new FabricNetworkHandler(Side.SERVER);
        this.dispatcher = new NetworkDispatcher(this.networkHandler);
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, environment) -> CreateWaypoint.register((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.server = server;
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            PropertiesManager.getInstance();
            WorldIdData.getWorldId();
            AdminAccessConfig.getInstance().load(new FabricConfig());
        });
    }

    public static Journeymap getInstance() {
        return instance;
    }

    public static Logger getLogger() {
        return LogManager.getLogger((String)MOD_ID);
    }

    public static Logger getLogger(String name) {
        return LogManager.getLogger((String)("journeymap/" + name));
    }

    public NetworkDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public PacketHandler getPacketHandler() {
        return this.handler;
    }

    public NetworkHandler getNetworkHandler() {
        return this.networkHandler;
    }

    public static boolean isOp(class_1657 player) {
        if (EnvType.CLIENT.equals((Object)FabricLoader.getInstance().getEnvironmentType())) {
            boolean creative = player.method_31549().field_7477;
            boolean cheatMode = LoaderHooks.getServer().method_3760().method_14569(new GameProfile(player.method_5667(), player.method_5477().getString()));
            return creative || cheatMode;
        }
        return LoaderHooks.getServer().method_3760().method_14603().method_14640((Object)player.method_7334()) != null || CommonConstants.debugOverride((class_1297)player);
    }
}

