/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.callbacks;

import dev.latvian.mods.kubejs.block.callbacks.EntitySteppedOnBlockCallbackJS;
import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class EntityFallenOnBlockCallbackJS
extends EntitySteppedOnBlockCallbackJS {
    private final float fallHeight;

    public EntityFallenOnBlockCallbackJS(class_1937 level, class_1297 entity, class_2338 pos, class_2680 state, float fallHeight) {
        super(level, entity, pos, state);
        this.fallHeight = fallHeight;
    }

    @Info(value="Get the height the entity has fallen")
    public float getFallHeight() {
        return this.fallHeight;
    }

    @Info(value="Applies default fall damage to the entity.\nNote this does not force it, so entities that do not take fall damage are not affected.\n")
    public boolean applyFallDamage() {
        return this.applyFallDamage(1.0f);
    }

    @Info(value="Applies fall damage to the entity, multiplier by the multiplier.\nNote this does not force it, so entities that do not take fall damage are not affected.\n")
    public boolean applyFallDamage(float multiplier) {
        return this.applyFallDamage(this.fallHeight, multiplier);
    }

    @Info(value="Applies fall damage to the entity as if they had fallen from the provided height, and multiplies it by the provided multiplier.\nNote this does not force it, so entities that do not take fall damage are not affected.\n")
    public boolean applyFallDamage(float fallHeight, float multiplier) {
        return this.applyFallDamage(fallHeight, multiplier, class_1282.field_5868);
    }

    @Info(value="Damages the entity using the provided damage source, using the fall height and multiplier to calculate the damage amount.\nNote this does not force the damage, so entities that do not take fall damage are not affected.\n")
    public boolean applyFallDamage(float fallHeight, float multiplier, class_1282 damageSource) {
        return this.entity.method_5747(fallHeight, multiplier, damageSource);
    }
}

