/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.predicate;

import dev.latvian.mods.kubejs.block.predicate.BlockPredicate;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.registry.KubeJSRegistries;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;

public class BlockIDPredicate
implements BlockPredicate {
    private final class_2960 id;
    private final Map<String, String> properties;
    private class_2248 cachedBlock;
    private List<PropertyObject> cachedProperties;

    public BlockIDPredicate(class_2960 i) {
        this.id = i;
        this.properties = new HashMap<String, String>();
    }

    public String toString() {
        if (this.properties.isEmpty()) {
            return this.id.toString();
        }
        StringBuilder sb = new StringBuilder(this.id.toString());
        sb.append('[');
        boolean first = true;
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
        }
        sb.append(']');
        return sb.toString();
    }

    public BlockIDPredicate with(String key, String value) {
        this.properties.put(key, value);
        this.cachedBlock = null;
        this.cachedProperties = null;
        return this;
    }

    private class_2248 getBlock() {
        if (this.cachedBlock == null) {
            this.cachedBlock = (class_2248)KubeJSRegistries.blocks().get(this.id);
            if (this.cachedBlock == null) {
                this.cachedBlock = class_2246.field_10124;
            }
        }
        return this.cachedBlock;
    }

    public List<PropertyObject> getBlockProperties() {
        if (this.cachedProperties == null) {
            this.cachedProperties = new LinkedList<PropertyObject>();
            HashMap<String, class_2769> map = new HashMap<String, class_2769>();
            for (class_2769 class_27692 : this.getBlock().method_9564().method_28501()) {
                map.put(class_27692.method_11899(), class_27692);
            }
            for (Map.Entry entry : this.properties.entrySet()) {
                Optional o;
                class_2769 property = (class_2769)map.get(entry.getKey());
                if (property == null || !(o = property.method_11900((String)entry.getValue())).isPresent()) continue;
                PropertyObject po = new PropertyObject(property, o.get());
                this.cachedProperties.add(po);
            }
        }
        return this.cachedProperties;
    }

    public class_2680 getBlockState() {
        class_2680 state = this.getBlock().method_9564();
        for (PropertyObject object : this.getBlockProperties()) {
            state = (class_2680)state.method_11657(object.property, (Comparable)UtilsJS.cast(object.value));
        }
        return state;
    }

    @Override
    public boolean check(BlockContainerJS b) {
        return this.getBlock() != class_2246.field_10124 && this.checkState(b.getBlockState());
    }

    public boolean checkState(class_2680 state) {
        if (state.method_26204() != this.getBlock()) {
            return false;
        }
        if (this.properties.isEmpty()) {
            return true;
        }
        for (PropertyObject object : this.getBlockProperties()) {
            if (state.method_11654(object.property).equals(object.value)) continue;
            return false;
        }
        return true;
    }

    public record PropertyObject(class_2769<?> property, Object value) {
    }
}

