/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.integration.rei;

import dev.architectury.event.EventResult;
import dev.architectury.fluid.FluidStack;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.integration.rei.AddREIEventJS;
import dev.latvian.mods.kubejs.integration.rei.EntryWrapper;
import dev.latvian.mods.kubejs.integration.rei.GroupREIEntriesEventJS;
import dev.latvian.mods.kubejs.integration.rei.HideREIEventJS;
import dev.latvian.mods.kubejs.integration.rei.InformationREIEventJS;
import dev.latvian.mods.kubejs.integration.rei.KubeJSAddREIWrapperEvent;
import dev.latvian.mods.kubejs.integration.rei.REIEvents;
import dev.latvian.mods.kubejs.integration.rei.RemoveREICategoryEventJS;
import dev.latvian.mods.kubejs.integration.rei.RemoveREIRecipeEventJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class KubeJSREIPlugin
implements REIClientPlugin {
    private final Set<CategoryIdentifier<?>> categoriesRemoved = new HashSet();
    private final Map<CategoryIdentifier<?>, Collection<class_2960>> recipesRemoved = new HashMap();
    private static final Map<EntryType<?>, EntryWrapper> entryWrappers = new HashMap();

    public KubeJSREIPlugin() {
        entryWrappers.clear();
        entryWrappers.put(VanillaEntryTypes.ITEM, o -> {
            List<class_1799> list;
            if (o instanceof class_1799) {
                class_1799 is = (class_1799)o;
                list = List.of(is);
            } else {
                list = IngredientJS.of(o).kjs$getDisplayStacks().toList();
            }
            return EntryIngredients.ofItemStacks(list);
        });
        entryWrappers.put(VanillaEntryTypes.FLUID, o -> EntryIngredients.of((FluidStack)FluidStackJS.of(o).getFluidStack()));
        ((Consumer)KubeJSAddREIWrapperEvent.EVENT.invoker()).accept(entryWrappers::put);
    }

    public double getPriority() {
        return 1.0E7;
    }

    public void registerEntries(EntryRegistry registry) {
        if (REIEvents.ADD.hasListeners()) {
            entryWrappers.forEach((type, wrapper) -> REIEvents.ADD.post(new AddREIEventJS(registry, (EntryWrapper)wrapper), type.getId()));
        }
    }

    public void registerBasicEntryFiltering(BasicFilteringRule<?> rule) {
        if (REIEvents.HIDE.hasListeners()) {
            entryWrappers.forEach((type, wrapper) -> {
                BasicFilteringRule filter = FilteringRuleTypeRegistry.getInstance().basic();
                EntryRegistry registry = EntryRegistry.getInstance();
                REIEvents.HIDE.post(new HideREIEventJS(registry, (BasicFilteringRule<?>)filter, (EntryType)UtilsJS.cast(type), (EntryWrapper)wrapper), type.getId());
            });
        }
    }

    public void registerDisplays(DisplayRegistry registry) {
        if (REIEvents.INFORMATION.hasListeners()) {
            REIEvents.INFORMATION.post(new InformationREIEventJS());
        }
        registry.registerVisibilityPredicate((cat, display) -> {
            Optional id = display.getDisplayLocation();
            if (id.isPresent() && ((Collection)this.recipesRemoved.getOrDefault(cat.getCategoryIdentifier(), List.of())).contains(id.get())) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.registerVisibilityPredicate(category -> this.categoriesRemoved.contains(category.getCategoryIdentifier()) ? EventResult.interruptFalse() : EventResult.pass());
    }

    public void postStage(PluginManager<REIClientPlugin> manager, ReloadStage stage) {
        if (stage == ReloadStage.END) {
            this.categoriesRemoved.clear();
            this.recipesRemoved.clear();
            if (REIEvents.REMOVE_CATEGORIES.hasListeners()) {
                REIEvents.REMOVE_CATEGORIES.post(new RemoveREICategoryEventJS(this.categoriesRemoved));
            }
            if (REIEvents.REMOVE_RECIPES.hasListeners()) {
                REIEvents.REMOVE_RECIPES.post(new RemoveREIRecipeEventJS(this.recipesRemoved));
            }
        }
    }

    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        if (REIEvents.GROUP_ENTRIES.hasListeners()) {
            REIEvents.GROUP_ENTRIES.post(new GroupREIEntriesEventJS(registry));
        }
    }

    public static EntryType<?> getTypeOrThrow(class_2960 typeId) {
        return Objects.requireNonNull(EntryTypeRegistry.getInstance().get(typeId), "Entry type '%s' not found!".formatted(typeId)).getType();
    }

    public static EntryWrapper getWrapperOrFallback(EntryType<?> type) {
        EntryWrapper wrapper = entryWrappers.get(type);
        if (wrapper != null) {
            return wrapper;
        }
        ConsoleJS.CLIENT.warn("No wrapper found for entry type '%s', trying to fall back to id-based wrapper!".formatted(type.getId()));
        return o -> {
            Set ids = CollectionUtils.mapToSet(ListJS.orSelf(o), o1 -> UtilsJS.getMCID(ScriptType.CLIENT.manager.get().context, o1));
            return EntryRegistry.getInstance().getEntryStacks().filter(stack -> stack.getType().equals(type)).filter(stack -> ids.contains(stack.getIdentifier())).toList();
        };
    }
}

