/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.architectury.hooks.item.food.FoodPropertiesHooks;
import dev.latvian.mods.kubejs.item.FoodEatenEventJS;
import dev.latvian.mods.kubejs.registry.KubeJSRegistries;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_5321;

public class FoodBuilder {
    private int hunger;
    private float saturation;
    private boolean meat;
    private boolean alwaysEdible;
    private boolean fastToEat;
    private final List<org.apache.commons.lang3.tuple.Pair<Supplier<class_1293>, Float>> effects = Lists.newArrayList();
    public Consumer<FoodEatenEventJS> eaten;

    public FoodBuilder() {
    }

    public FoodBuilder(class_4174 properties) {
        this.hunger = properties.method_19230();
        this.saturation = properties.method_19231();
        this.meat = properties.method_19232();
        this.alwaysEdible = properties.method_19233();
        this.fastToEat = properties.method_19234();
        properties.method_19235().forEach(pair -> this.effects.add((org.apache.commons.lang3.tuple.Pair<Supplier<class_1293>, Float>)org.apache.commons.lang3.tuple.Pair.of(() -> ((Pair)pair).getFirst(), (Object)((Float)pair.getSecond()))));
    }

    @Info(value="Sets the hunger restored.")
    public FoodBuilder hunger(int h) {
        this.hunger = h;
        return this;
    }

    @Info(value="Sets the saturation modifier. Note that the saturation restored is hunger * saturation.")
    public FoodBuilder saturation(float s) {
        this.saturation = s;
        return this;
    }

    @Info(value="Sets whether the food is meat.")
    public FoodBuilder meat(boolean flag) {
        this.meat = flag;
        return this;
    }

    @Info(value="Sets the food is meat.")
    public FoodBuilder meat() {
        return this.meat(true);
    }

    @Info(value="Sets whether the food is always edible.")
    public FoodBuilder alwaysEdible(boolean flag) {
        this.alwaysEdible = flag;
        return this;
    }

    @Info(value="Sets the food is always edible.")
    public FoodBuilder alwaysEdible() {
        return this.alwaysEdible(true);
    }

    @Info(value="Sets whether the food is fast to eat (having half of the eating time).")
    public FoodBuilder fastToEat(boolean flag) {
        this.fastToEat = flag;
        return this;
    }

    @Info(value="Sets the food is fast to eat (having half of the eating time).")
    public FoodBuilder fastToEat() {
        return this.fastToEat(true);
    }

    @Info(value="Adds an effect to the food. Note that the effect duration is in ticks (20 ticks = 1 second).\n", params={@Param(name="mobEffectId", value="The id of the effect. Can be either a string or a ResourceLocation."), @Param(name="duration", value="The duration of the effect in ticks."), @Param(name="amplifier", value="The amplifier of the effect. 0 means level 1, 1 means level 2, etc."), @Param(name="probability", value="The probability of the effect being applied. 1 = 100%.")})
    public FoodBuilder effect(class_2960 mobEffectId, int duration, int amplifier, float probability) {
        this.effects.add((org.apache.commons.lang3.tuple.Pair<Supplier<class_1293>, Float>)org.apache.commons.lang3.tuple.Pair.of((Object)new EffectSupplier(mobEffectId, duration, amplifier), (Object)Float.valueOf(probability)));
        return this;
    }

    @Info(value="Removes an effect from the food.")
    public FoodBuilder removeEffect(class_1291 mobEffect) {
        if (mobEffect == null) {
            return this;
        }
        this.effects.removeIf(pair -> {
            class_1293 effectInstance = (class_1293)((Supplier)pair.getKey()).get();
            return effectInstance.method_5586().equals(mobEffect.method_5567());
        });
        return this;
    }

    @Info(value="Sets a callback that is called when the food is eaten.\n\nNote: This is currently not having effect in `ItemEvents.modification`,\nas firing this callback requires an `ItemBuilder` instance in the `Item`.\n")
    public FoodBuilder eaten(Consumer<FoodEatenEventJS> e) {
        this.eaten = e;
        return this;
    }

    public class_4174 build() {
        class_4174.class_4175 b = new class_4174.class_4175();
        b.method_19238(this.hunger);
        b.method_19237(this.saturation);
        if (this.meat) {
            b.method_19236();
        }
        if (this.alwaysEdible) {
            b.method_19240();
        }
        if (this.fastToEat) {
            b.method_19241();
        }
        for (org.apache.commons.lang3.tuple.Pair<Supplier<class_1293>, Float> effect : this.effects) {
            FoodPropertiesHooks.effect((class_4174.class_4175)b, (Supplier)((Supplier)effect.getLeft()), (float)((Float)effect.getRight()).floatValue());
        }
        return b.method_19242();
    }

    private static class EffectSupplier
    implements Supplier<class_1293> {
        private final class_2960 id;
        private final int duration;
        private final int amplifier;
        private class_1291 cachedEffect;

        public EffectSupplier(class_2960 id, int duration, int amplifier) {
            this.id = id;
            this.duration = duration;
            this.amplifier = amplifier;
        }

        @Override
        public class_1293 get() {
            if (this.cachedEffect == null) {
                this.cachedEffect = (class_1291)KubeJSRegistries.mobEffects().get(this.id);
                if (this.cachedEffect == null) {
                    Set effectIds = KubeJSRegistries.mobEffects().entrySet().stream().map(entry -> ((class_5321)entry.getKey()).method_29177()).collect(Collectors.toSet());
                    throw new RuntimeException(String.format("Missing effect '%s'. Check spelling or maybe potion id was used instead of effect id. Possible ids: %s", this.id, effectIds));
                }
            }
            return new class_1293(this.cachedEffect, this.duration, this.amplifier);
        }
    }
}

