/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.platform.fabric.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.platform.fabric.ingredient.KubeJSIngredient;
import dev.latvian.mods.kubejs.platform.fabric.ingredient.KubeJSIngredientSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public class KubeJSNbtIngredient
extends KubeJSIngredient {
    public static final KubeJSIngredientSerializer<KubeJSNbtIngredient> SERIALIZER = new KubeJSIngredientSerializer<KubeJSNbtIngredient>(KubeJS.id("nbt"), KubeJSNbtIngredient::new, KubeJSNbtIngredient::new);
    private final class_1856 base;
    @Nullable
    private final class_2487 nbt;
    private final boolean strict;

    public KubeJSNbtIngredient(class_1856 base, @Nullable class_2487 nbt, boolean strict) {
        if (nbt == null && !strict) {
            throw new IllegalArgumentException("NbtIngredient can only have null NBT in strict mode");
        }
        this.base = base;
        this.nbt = nbt;
        this.strict = strict;
    }

    public KubeJSNbtIngredient(class_2540 buf) {
        this(class_1856.method_8086((class_2540)buf), buf.method_10798(), buf.readBoolean());
    }

    public KubeJSNbtIngredient(JsonObject json) {
        this(class_1856.method_8102((JsonElement)json.get("base")), KubeJSNbtIngredient.readNbt(json.get("nbt")), class_3518.method_15258((JsonObject)json, (String)"strict", (boolean)false));
    }

    @Nullable
    private static class_2487 readNbt(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return null;
        }
        try {
            if (json.isJsonObject()) {
                return class_2522.method_10718((String)json.toString());
            }
            return class_2522.method_10718((String)class_3518.method_15287((JsonElement)json, (String)"nbt"));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new JsonSyntaxException("Invalid nbt tag: " + commandSyntaxException.getMessage());
        }
    }

    public boolean test(class_1799 stack) {
        if (!this.base.method_8093(stack)) {
            return false;
        }
        if (this.strict) {
            return Objects.equals(this.nbt, stack.method_7969());
        }
        return class_2512.method_10687((class_2520)this.nbt, (class_2520)stack.method_7969(), (boolean)true);
    }

    public List<class_1799> getMatchingStacks() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>(List.of(this.base.method_8105()));
        stacks.replaceAll(stack -> {
            class_1799 copy = stack.method_7972();
            if (this.nbt != null) {
                copy.method_7980(this.nbt.method_10553());
            }
            return copy;
        });
        stacks.removeIf(stack -> !this.base.method_8093(stack));
        return stacks;
    }

    @Override
    public boolean requiresTesting() {
        return true;
    }

    @Override
    public void toJson(JsonObject json) {
        json.add("base", this.base.method_8089());
        if (this.strict) {
            json.addProperty("strict", Boolean.valueOf(true));
        }
        if (this.nbt != null) {
            json.addProperty("nbt", this.nbt.toString());
        }
    }

    @Override
    public void write(class_2540 buf) {
        this.base.method_8088(buf);
        buf.method_10794(this.nbt);
        buf.writeBoolean(this.strict);
    }

    @Override
    public KubeJSIngredientSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

