/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.special;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.recipe.KubeJSRecipeEventHandler;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeResultCallback;
import dev.latvian.mods.kubejs.recipe.RecipesEventJS;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import dev.latvian.mods.kubejs.recipe.special.KubeJSCraftingRecipe;
import dev.latvian.mods.kubejs.registry.KubeJSRegistries;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public class ShapedKubeJSRecipe
extends class_1869
implements KubeJSCraftingRecipe {
    private final boolean mirror;
    private final List<IngredientAction> ingredientActions;
    private final ModifyRecipeResultCallback modifyResult;
    private final String stage;

    public ShapedKubeJSRecipe(class_2960 id, String group, int width, int height, class_2371<class_1856> ingredients, class_1799 result, boolean mirror, List<IngredientAction> ingredientActions, @Nullable ModifyRecipeResultCallback modifyResult, String stage) {
        super(id, group, width, height, ingredients, result);
        this.mirror = mirror;
        this.ingredientActions = ingredientActions;
        this.modifyResult = modifyResult;
        this.stage = stage;
    }

    public class_1865<?> method_8119() {
        return KubeJSRecipeEventHandler.SHAPED.get();
    }

    @Override
    public List<IngredientAction> kjs$getIngredientActions() {
        return this.ingredientActions;
    }

    @Override
    @Nullable
    public ModifyRecipeResultCallback kjs$getModifyResult() {
        return this.modifyResult;
    }

    @Override
    public String kjs$getStage() {
        return this.stage;
    }

    public class_2371<class_1799> getRemainingItems(class_1715 container) {
        return this.kjs$getRemainingItems(container);
    }

    public class_1799 method_17727(class_1715 container) {
        return this.kjs$assemble(container);
    }

    public boolean method_17728(class_1715 craftingContainer, class_1937 level) {
        for (int i = 0; i <= craftingContainer.method_17398() - this.field_9055; ++i) {
            for (int j = 0; j <= craftingContainer.method_17397() - this.field_9054; ++j) {
                if (this.mirror && this.method_8161(craftingContainer, i, j, true)) {
                    return true;
                }
                if (!this.method_8161(craftingContainer, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static class SerializerKJS
    implements class_1865<ShapedKubeJSRecipe> {
        private static final class_1865<class_1869> SHAPED = (class_1865)UtilsJS.cast(KubeJSRegistries.recipeSerializers().get(new class_2960("crafting_shaped")));

        public ShapedKubeJSRecipe fromJson(class_2960 id, JsonObject json) {
            class_1869 shapedRecipe = (class_1869)SHAPED.method_8121(id, json);
            boolean mirror = class_3518.method_15258((JsonObject)json, (String)"kubejs:mirror", (boolean)true);
            boolean shrink = class_3518.method_15258((JsonObject)json, (String)"kubejs:shrink", (boolean)true);
            Map key = class_1869.method_8157((JsonObject)class_3518.method_15296((JsonObject)json, (String)"key"));
            String[] pattern = class_1869.method_8145((JsonArray)class_3518.method_15261((JsonObject)json, (String)"pattern"));
            if (shrink) {
                pattern = class_1869.method_8146((String[])pattern);
            }
            int w = pattern[0].length();
            int h = pattern.length;
            class_2371 ingredients = class_1869.method_8148((String[])pattern, (Map)key, (int)w, (int)h);
            List<IngredientAction> ingredientActions = IngredientAction.parseList(json.get("kubejs:actions"));
            ModifyRecipeResultCallback modifyResult = null;
            if (json.has("kubejs:modify_result")) {
                modifyResult = RecipesEventJS.MODIFY_RESULT_CALLBACKS.get(id);
            }
            String stage = class_3518.method_15253((JsonObject)json, (String)"kubejs:stage", (String)"");
            return new ShapedKubeJSRecipe(id, shapedRecipe.method_8112(), w, h, (class_2371<class_1856>)ingredients, shapedRecipe.method_8110(), mirror, ingredientActions, modifyResult, stage);
        }

        public ShapedKubeJSRecipe fromNetwork(class_2960 id, class_2540 buf) {
            class_1869 shapedRecipe = (class_1869)SHAPED.method_8122(id, buf);
            byte flags = buf.readByte();
            String group = shapedRecipe.method_8112();
            int width = shapedRecipe.method_8150();
            int height = shapedRecipe.method_8158();
            class_2371 ingredients = shapedRecipe.method_8117();
            class_1799 result = shapedRecipe.method_8110();
            List<IngredientAction> ingredientActions = (flags & 1) != 0 ? IngredientAction.readList(buf) : List.of();
            String stage = (flags & 2) != 0 ? buf.method_19772() : "";
            boolean mirror = (flags & 4) != 0;
            return new ShapedKubeJSRecipe(id, group, width, height, (class_2371<class_1856>)ingredients, result, mirror, ingredientActions, null, stage);
        }

        public void toNetwork(class_2540 buf, ShapedKubeJSRecipe r) {
            SHAPED.method_8124(buf, (class_1860)r);
            int flags = 0;
            if (r.ingredientActions != null && !r.ingredientActions.isEmpty()) {
                flags |= 1;
            }
            if (r.mirror) {
                flags |= 4;
            }
            if (!r.stage.isEmpty()) {
                flags |= 2;
            }
            buf.writeByte(flags);
            if (r.ingredientActions != null && !r.ingredientActions.isEmpty()) {
                IngredientAction.writeList(buf, r.ingredientActions);
            }
            if (!r.stage.isEmpty()) {
                buf.method_10814(r.stage);
            }
        }
    }
}

