/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.registry;

import dev.latvian.mods.kubejs.client.LangEventJS;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.generator.DataJsonGenerator;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;

public abstract class BuilderBase<T>
implements Supplier<T> {
    public final class_2960 id;
    protected T object;
    public String translationKey;
    public class_2561 displayName;
    public boolean formattedDisplayName;
    public transient boolean dummyBuilder;
    public transient Set<class_2960> defaultTags;

    public BuilderBase(class_2960 i) {
        this.id = i;
        this.object = null;
        this.translationKey = "";
        this.displayName = null;
        this.formattedDisplayName = false;
        this.dummyBuilder = false;
        this.defaultTags = new HashSet<class_2960>();
    }

    public abstract RegistryInfo getRegistryType();

    public abstract T createObject();

    public T transformObject(T obj) {
        return obj;
    }

    @Override
    public final T get() {
        try {
            return this.object;
        }
        catch (Exception ex) {
            if (this.dummyBuilder) {
                throw new RuntimeException("Object '" + this.id + "' of registry '" + this.getRegistryType().key.method_29177() + "' is from a dummy builder and doesn't have a value!");
            }
            throw new RuntimeException("Object '" + this.id + "' of registry '" + this.getRegistryType().key.method_29177() + "' hasn't been registered yet!", ex);
        }
    }

    public void createAdditionalObjects() {
    }

    public String getTranslationKeyGroup() {
        return this.getRegistryType().languageKeyPrefix;
    }

    @Info(value="Sets the translation key for this object, e.g. `block.minecraft.stone`.\n")
    public BuilderBase<T> translationKey(String key) {
        this.translationKey = key;
        return this;
    }

    @Info(value="Sets the display name for this object, e.g. `Stone`.\n\nThis will be overridden by a lang file if it exists.\n")
    public BuilderBase<T> displayName(class_2561 name) {
        this.displayName = name;
        return this;
    }

    @Info(value="Makes displayName() override language files.\n")
    public BuilderBase<T> formattedDisplayName() {
        this.formattedDisplayName = true;
        return this;
    }

    @Info(value="Combined method of formattedDisplayName().displayName(name).\n")
    public BuilderBase<T> formattedDisplayName(class_2561 name) {
        return this.formattedDisplayName().displayName(name);
    }

    @Info(value="Adds a tag to this object, e.g. `minecraft:stone`.\n")
    public BuilderBase<T> tag(class_2960 tag) {
        this.defaultTags.add(tag);
        this.getRegistryType().hasDefaultTags = true;
        return this;
    }

    public class_2960 newID(String pre, String post) {
        if (pre.isEmpty() && post.isEmpty()) {
            return this.id;
        }
        return new class_2960(this.id.method_12836() + ":" + pre + this.id.method_12832() + post);
    }

    public void generateDataJsons(DataJsonGenerator generator) {
    }

    public void generateAssetJsons(AssetJsonGenerator generator) {
    }

    @Deprecated
    public void generateLang(Map<String, String> lang) {
    }

    public String getBuilderTranslationKey() {
        if (this.translationKey.isEmpty()) {
            return class_156.method_646((String)this.getTranslationKeyGroup(), (class_2960)this.id);
        }
        return this.translationKey;
    }

    public void generateLang(LangEventJS lang) {
        if (this.displayName != null) {
            lang.add(this.id.method_12836(), this.getBuilderTranslationKey(), this.displayName.getString());
        } else {
            lang.add(this.id.method_12836(), this.getBuilderTranslationKey(), UtilsJS.snakeCaseToTitleCase(this.id.method_12832()));
        }
    }

    @Deprecated
    public void addResourcePackLocations(String path, List<class_2960> list, class_3264 packType) {
    }

    protected T createTransformedObject() {
        this.object = this.transformObject(this.createObject());
        return this.object;
    }

    public String toString() {
        String n = this.getClass().getName();
        int i = n.lastIndexOf(46);
        if (i != -1) {
            n = n.substring(i + 1);
        }
        return n + "[" + this.id + "]";
    }
}

