/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret.gui;

import com.jtorleonstudios.libraryferret.gui.AbstractScreen;
import com.jtorleonstudios.libraryferret.gui.AbstractUI;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.lwjgl.opengl.GL11;

public class ScrollableTextUI
extends AbstractUI {
    private List<String> texts;
    private final int barWidth = 6;
    private final int barLeft;
    private boolean scrolling;
    private double scrollDistance;

    public ScrollableTextUI(AbstractScreen parent, String text, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        int var10001 = this.right;
        Objects.requireNonNull(this);
        this.barLeft = var10001 - 6;
        this.texts = this.resizeTextToWidth(text);
        this.scrolling = false;
        this.scrollDistance = 0.0;
    }

    public void method_25394(class_4587 matrix, int mouseX, int mouseY, float partialTicks) {
        double scale = this.parent.getWindow().method_4495();
        class_289 tess = class_289.method_1348();
        class_287 worldr = tess.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scale)), (int)((int)((double)this.parent.getWindow().method_4507() - (double)this.bottom * scale)), (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        this.renderTexts(this.texts, matrix, this.left + this.getInnerPadding(), this.getInnerPadding() + (int)((double)this.y - this.scrollDistance), 0xFFFFFF);
        if (this.requireScroll()) {
            int extraHeight;
            int barHeight = this.getBarHeight();
            int barTop = (int)this.scrollDistance * (this.height - barHeight) / (extraHeight = this.getContentHeight() - this.height) + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            RenderSystem.disableTexture();
            RenderSystem.setShader(class_757::method_34540);
            worldr.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            worldr.method_22912((double)this.barLeft, (double)this.bottom, 0.0).method_1336(0, 0, 0, 255).method_1344();
            worldr.method_22912((double)(this.barLeft + 6), (double)this.bottom, 0.0).method_1336(0, 0, 0, 255).method_1344();
            worldr.method_22912((double)(this.barLeft + 6), (double)this.top, 0.0).method_1336(0, 0, 0, 255).method_1344();
            worldr.method_22912((double)this.barLeft, (double)this.top, 0.0).method_1336(0, 0, 0, 255).method_1344();
            tess.method_1350();
            worldr.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            worldr.method_22912((double)this.barLeft, (double)(barTop + barHeight), 0.0).method_1336(128, 128, 128, 255).method_1344();
            worldr.method_22912((double)(this.barLeft + 6), (double)(barTop + barHeight), 0.0).method_1336(128, 128, 128, 255).method_1344();
            worldr.method_22912((double)(this.barLeft + 6), (double)barTop, 0.0).method_1336(128, 128, 128, 255).method_1344();
            worldr.method_22912((double)this.barLeft, (double)barTop, 0.0).method_1336(128, 128, 128, 255).method_1344();
            tess.method_1350();
            worldr.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            worldr.method_22912((double)this.barLeft, (double)(barTop + barHeight - 1), 0.0).method_1336(192, 192, 192, 255).method_1344();
            worldr.method_22912((double)(this.barLeft + 6 - 1), (double)(barTop + barHeight - 1), 0.0).method_1336(192, 192, 192, 255).method_1344();
            worldr.method_22912((double)(this.barLeft + 6 - 1), (double)barTop, 0.0).method_1336(192, 192, 192, 255).method_1344();
            worldr.method_22912((double)this.barLeft, (double)barTop, 0.0).method_1336(192, 192, 192, 255).method_1344();
            tess.method_1350();
            RenderSystem.enableTexture();
        }
        RenderSystem.disableBlend();
        GL11.glDisable((int)3089);
    }

    public boolean method_25401(double mouseX, double mouseY, double scroll) {
        if (!super.method_25401(mouseX, mouseY, scroll) && scroll != 0.0 && this.requireScroll()) {
            this.scrollDistance += -scroll * 20.0;
            this.applyScrollLimits();
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return false;
        }
        this.scrolling = this.requireScroll() && button == 0 && mouseX >= (double)this.barLeft && mouseX < (double)(this.barLeft + 6);
        return this.scrolling;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (super.method_25406(mouseX, mouseY, button)) {
            return false;
        }
        this.scrolling = !this.scrolling;
        return !this.scrolling;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!super.method_25403(mouseX, mouseY, button, deltaX, deltaY) && this.scrolling) {
            int maxScroll = this.height - this.getBarHeight();
            double moved = deltaY / (double)maxScroll;
            this.scrollDistance += (double)(this.getContentHeight() - this.height) * moved;
            this.applyScrollLimits();
            return true;
        }
        return false;
    }

    private void applyScrollLimits() {
        int max = this.getContentHeight() - this.height;
        if (max < 0) {
            max /= 2;
        }
        this.scrollDistance = this.scrollDistance < 0.0 ? 0.0 : Math.min(this.scrollDistance, (double)max);
    }

    public void setTexts(String text) {
        this.texts = this.resizeTextToWidth(text);
    }

    private int getContentHeight() {
        int h = this.texts.size() * this.parent.getLineHeight() + this.getInnerPadding() * 2;
        if (h < this.bottom - this.top - 8) {
            h = this.bottom - this.top - 8;
        }
        return h;
    }

    private int getBarHeight() {
        int barHeight = this.height * this.height / this.getContentHeight();
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > this.height * 2) {
            barHeight = this.height * 2;
        }
        return barHeight;
    }

    private boolean requireScroll() {
        return this.getContentHeight() > this.height;
    }

    private int getInnerPadding() {
        return 6;
    }
}

