/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.client.block;

import java.util.UUID;
import net.minecraft.class_1059;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_746;
import net.minecraft.class_826;
import net.zestyblaze.lootr.blocks.entities.LootrChestBlockEntity;
import net.zestyblaze.lootr.config.LootrModConfig;
import net.zestyblaze.lootr.registry.LootrBlockEntityInit;

public class LootrChestBlockRenderer<T extends LootrChestBlockEntity>
extends class_826<T> {
    private UUID playerId = null;
    public static final class_4730 CHEST = new class_4730(class_1059.field_5275, new class_2960("lootr", "chest"));
    public static final class_4730 CHEST_OPENED = new class_4730(class_1059.field_5275, new class_2960("lootr", "chest_opened"));
    public static final class_4730 OLD_CHEST = new class_4730(class_1059.field_5275, new class_2960("lootr", "old_chest"));
    public static final class_4730 OLD_CHEST_OPENED = new class_4730(class_1059.field_5275, new class_2960("lootr", "old_chest_opened"));
    public static final class_4730 TRAPPED_CHEST = new class_4730(class_1059.field_5275, new class_2960("lootr", "chest_trapped"));
    public static final class_4730 TRAPPED_CHEST_OPENED = new class_4730(class_1059.field_5275, new class_2960("lootr", "chest_trapped_opened"));
    public static final class_4730 OLD_TRAPPED_CHEST = new class_4730(class_1059.field_5275, new class_2960("lootr", "old_chest_trapped"));
    public static final class_4730 OLD_TRAPPED_CHEST_OPENED = new class_4730(class_1059.field_5275, new class_2960("lootr", "old_chest_trapped_opened"));
    private final class_630 lid;
    private final class_630 bottom;
    private final class_630 lock;

    public LootrChestBlockRenderer(class_5614.class_5615 context) {
        super(context);
        class_630 modelPart = context.method_32140(class_5602.field_27689);
        this.bottom = modelPart.method_32086("bottom");
        this.lid = modelPart.method_32086("lid");
        this.lock = modelPart.method_32086("lock");
    }

    public void render(T blockEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_1937 level = blockEntity.method_10997();
        class_2680 blockState = level != null ? blockEntity.method_11010() : (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.field_11035);
        poseStack.method_22903();
        float f = ((class_2350)blockState.method_11654((class_2769)class_2281.field_10768)).method_10144();
        poseStack.method_22904(0.5, 0.5, 0.5);
        poseStack.method_22907(class_1160.field_20705.method_23214(-f));
        poseStack.method_22904(-0.5, -0.5, -0.5);
        float g = ((LootrChestBlockEntity)blockEntity).method_11274(partialTick);
        g = 1.0f - g;
        g = 1.0f - g * g * g;
        class_4730 material = this.getMaterial(blockEntity);
        class_4588 vertexConsumer = material.method_24145(bufferSource, class_1921::method_23576);
        this.render(poseStack, vertexConsumer, this.lid, this.lock, this.bottom, g, packedLight, packedOverlay);
        poseStack.method_22909();
    }

    private void render(class_4587 poseStack, class_4588 consumer, class_630 lidPart, class_630 lockPart, class_630 bottomPart, float lidAngle, int packedLight, int packedOverlay) {
        lockPart.field_3654 = lidPart.field_3654 = -(lidAngle * 1.5707964f);
        lidPart.method_22698(poseStack, consumer, packedLight, packedOverlay);
        lockPart.method_22698(poseStack, consumer, packedLight, packedOverlay);
        bottomPart.method_22698(poseStack, consumer, packedLight, packedOverlay);
    }

    protected class_4730 getMaterial(T tile) {
        boolean t;
        if (LootrModConfig.isVanillaTextures()) {
            return class_4722.field_21720;
        }
        boolean o = LootrModConfig.isOldTextures();
        boolean bl = t = tile.method_11017() == LootrBlockEntityInit.SPECIAL_TRAPPED_LOOT_CHEST;
        if (this.playerId == null) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                this.playerId = player.method_5667();
            } else {
                if (o) {
                    if (t) {
                        return OLD_TRAPPED_CHEST;
                    }
                    return OLD_CHEST;
                }
                if (t) {
                    return TRAPPED_CHEST;
                }
                return CHEST;
            }
        }
        if (((LootrChestBlockEntity)tile).isOpened()) {
            if (o) {
                if (t) {
                    return OLD_TRAPPED_CHEST_OPENED;
                }
                return OLD_CHEST_OPENED;
            }
            if (t) {
                return TRAPPED_CHEST_OPENED;
            }
            return CHEST_OPENED;
        }
        if (((LootrChestBlockEntity)tile).getOpeners().contains(this.playerId)) {
            if (o) {
                if (t) {
                    return OLD_TRAPPED_CHEST_OPENED;
                }
                return OLD_CHEST_OPENED;
            }
            if (t) {
                return TRAPPED_CHEST_OPENED;
            }
            return CHEST_OPENED;
        }
        if (o) {
            if (t) {
                return OLD_TRAPPED_CHEST;
            }
            return OLD_CHEST;
        }
        if (t) {
            return TRAPPED_CHEST;
        }
        return CHEST;
    }
}

