/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.data;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class TickingData
extends class_18 {
    private final Object2IntMap<UUID> tickMap = new Object2IntOpenHashMap();

    public TickingData() {
        this.tickMap.defaultReturnValue(-1);
    }

    public boolean isComplete(UUID id) {
        int tickVal = this.tickMap.getInt((Object)id);
        return tickVal == 0 || tickVal == 1;
    }

    public int getValue(UUID id) {
        return this.tickMap.getInt((Object)id);
    }

    public boolean setValue(UUID id, int decayAmount) {
        return this.tickMap.put((Object)id, decayAmount) == -1;
    }

    public int remove(UUID id) {
        return this.tickMap.removeInt((Object)id);
    }

    public boolean tick() {
        if (this.tickMap.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Object2IntMap.Entry entry : this.tickMap.object2IntEntrySet()) {
            int value = entry.getIntValue();
            if (value <= 0) continue;
            entry.setValue(value - 1);
            changed = true;
        }
        return changed;
    }

    public static TickingData load(class_2487 pCompound) {
        TickingData data = new TickingData();
        data.tickMap.clear();
        data.tickMap.defaultReturnValue(-1);
        class_2499 decayList = pCompound.method_10554("result", 10);
        for (int i = 0; i < decayList.size(); ++i) {
            class_2487 thisTag = decayList.method_10602(i);
            data.tickMap.put((Object)thisTag.method_25926("id"), thisTag.method_10550("value"));
        }
        return data;
    }

    public class_2487 method_75(class_2487 compound) {
        class_2499 decayList = new class_2499();
        for (Object2IntMap.Entry entry : this.tickMap.object2IntEntrySet()) {
            class_2487 thisTag = new class_2487();
            thisTag.method_25927("id", (UUID)entry.getKey());
            thisTag.method_10569("value", entry.getIntValue());
            decayList.add((Object)thisTag);
        }
        compound.method_10566("result", (class_2520)decayList);
        return compound;
    }

    public void method_17919(File pFile) {
        if (this.method_79()) {
            pFile.getParentFile().mkdirs();
        }
        super.method_17919(pFile);
    }
}

